/*
 * Decompiled with CFR 0.152.
 */
package lazy.baubles.api;

import lazy.baubles.api.bauble.BaubleType;
import lazy.baubles.api.cap.BaublesCapabilities;
import lazy.baubles.api.cap.IBaublesItemHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraftforge.common.util.LazyOptional;

public class BaublesAPI {
    public static final String MOD_ID = "baubles";

    public static LazyOptional<IBaublesItemHandler> getBaublesHandler(PlayerEntity player) {
        return player.getCapability(BaublesCapabilities.BAUBLES);
    }

    public static int isBaubleEquipped(PlayerEntity player, Item bauble) {
        return BaublesAPI.getBaublesHandler(player).map(handler -> {
            for (int a = 0; a < handler.getSlots(); ++a) {
                if (handler.getStackInSlot(a).func_190926_b() || handler.getStackInSlot(a).func_77973_b() != bauble) continue;
                return a;
            }
            return -1;
        }).orElse(-1);
    }

    public static int getEmptySlotForBaubleType(PlayerEntity playerEntity, BaubleType type) {
        IBaublesItemHandler itemHandler = (IBaublesItemHandler)BaublesAPI.getBaublesHandler(playerEntity).orElseThrow(NullPointerException::new);
        for (int i : type.getValidSlots()) {
            if (!itemHandler.getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }
}

