/*
 * Decompiled with CFR 0.152.
 */
package lazy.baubles.capability;

import javax.annotation.Nonnull;
import lazy.baubles.api.cap.BaublesCapabilities;
import lazy.baubles.api.cap.IBaublesItemHandler;
import lazy.baubles.capability.BaublesContainer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class BaublesContainerProvider
implements INBTSerializable<CompoundNBT>,
ICapabilityProvider {
    private BaublesContainer inner;
    private LazyOptional<IBaublesItemHandler> opt;

    public BaublesContainerProvider(PlayerEntity player) {
        this.inner = new BaublesContainer((LivingEntity)player);
        this.opt = LazyOptional.of(() -> this.inner);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        return BaublesCapabilities.BAUBLES.orEmpty(capability, this.opt);
    }

    public CompoundNBT serializeNBT() {
        return this.inner.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.inner.deserializeNBT(nbt);
    }
}

