/*
 * Decompiled with CFR 0.152.
 */
package lazy.baubles.datadriven;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lazy.baubles.datadriven.model.BaubleModel;
import lazy.baubles.datadriven.model.EffectModel;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.fml.loading.FMLPaths;

public class BaubleJson {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Path BAUBLES_PATH = Paths.get(FMLPaths.GAMEDIR.get().toString() + "/baubles/", new String[0]);

    public static List<BaubleModel> loadBaubles() {
        ArrayList<BaubleModel> baubles = new ArrayList<BaubleModel>();
        for (File file : BaubleJson.getAllJsonBaubles()) {
            if (baubles.stream().noneMatch(baubleModel -> baubleModel.getRegistryName().equals(BaubleJson.read(file).getRegistryName()))) {
                baubles.add(BaubleJson.read(file));
                continue;
            }
            System.out.println("Bauble with " + BaubleJson.read(file).getRegistryName() + " already exists!");
        }
        return baubles;
    }

    public static BaubleModel read(File file) {
        BaubleModel baubleModel = null;
        try {
            JsonObject json = JSONUtils.func_212743_a((Reader)new FileReader(file));
            String registryName = JSONUtils.func_151219_a((JsonObject)json, (String)"registryName", (String)"");
            String type = JSONUtils.func_151219_a((JsonObject)json, (String)"type", (String)"");
            boolean glint = JSONUtils.func_151209_a((JsonObject)json, (String)"glint", (boolean)false);
            boolean showEffectTooltip = JSONUtils.func_151209_a((JsonObject)json, (String)"showEffectsTooltip", (boolean)false);
            String displayName = JSONUtils.func_151219_a((JsonObject)json, (String)"displayName", (String)"Ring");
            ArrayList<String> tooltips = new ArrayList();
            ArrayList<String> requireMod = new ArrayList();
            List<Object> effects = new ArrayList<EffectModel>();
            if (JSONUtils.func_151204_g((JsonObject)json, (String)"tooltips")) {
                tooltips = Arrays.asList((Object[])((String[])GSON.fromJson((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"tooltips"), String[].class)).clone());
            }
            if (JSONUtils.func_151204_g((JsonObject)json, (String)"requireMod")) {
                requireMod = Arrays.asList((Object[])((String[])GSON.fromJson((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"requireMod"), String[].class)).clone());
            }
            if (JSONUtils.func_151204_g((JsonObject)json, (String)"effects")) {
                effects = Arrays.asList((Object[])((EffectModel[])GSON.fromJson((JsonElement)JSONUtils.func_151214_t((JsonObject)json, (String)"effects"), EffectModel[].class)).clone());
            }
            baubleModel = new BaubleModel(type, registryName, glint, showEffectTooltip, displayName, tooltips, requireMod, effects);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return baubleModel;
    }

    public static List<File> getAllJsonBaubles() {
        ArrayList<File> jsonBaubles = new ArrayList<File>();
        try {
            Files.createDirectories(BAUBLES_PATH, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (Stream<Path> walk = Files.walk(BAUBLES_PATH, new FileVisitOption[0]);){
            List<String> result = walk.map(x -> x.toString()).filter(f -> f.endsWith(".json")).collect(Collectors.toList());
            result.forEach(s -> jsonBaubles.add(new File((String)s)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jsonBaubles;
    }
}

