/*
 * Decompiled with CFR 0.152.
 */
package lazy.baubles.event;

import java.util.Collection;
import java.util.Collections;
import lazy.baubles.api.BaublesAPI;
import lazy.baubles.api.bauble.IBauble;
import lazy.baubles.api.cap.BaublesCapabilities;
import lazy.baubles.api.cap.IBaublesItemHandler;
import lazy.baubles.capability.BaublesContainer;
import lazy.baubles.capability.BaublesContainerProvider;
import lazy.baubles.network.PacketHandler;
import lazy.baubles.network.SyncPacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandlerEntity {
    @SubscribeEvent
    public static void cloneCapabilitiesEvent(PlayerEvent.Clone event) {
        try {
            event.getOriginal().getCapability(BaublesCapabilities.BAUBLES).ifPresent(bco -> {
                CompoundNBT nbt = ((BaublesContainer)bco).serializeNBT();
                event.getOriginal().getCapability(BaublesCapabilities.BAUBLES).ifPresent(bcn -> ((BaublesContainer)bcn).deserializeNBT(nbt));
            });
        }
        catch (Exception e) {
            System.out.println("Could not clone player [" + event.getOriginal().func_200200_C_() + "] baubles when changing dimensions");
        }
    }

    @SubscribeEvent
    public static void attachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("baubles", "container"), (ICapabilityProvider)new BaublesContainerProvider((PlayerEntity)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void playerJoin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            EventHandlerEntity.syncSlots((PlayerEntity)player, Collections.singletonList(player));
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity target = event.getTarget();
        if (target instanceof ServerPlayerEntity) {
            EventHandlerEntity.syncSlots((PlayerEntity)((ServerPlayerEntity)target), Collections.singletonList(event.getPlayer()));
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            PlayerEntity player = event.player;
            player.getCapability(BaublesCapabilities.BAUBLES).ifPresent(IBaublesItemHandler::tick);
        }
    }

    @SubscribeEvent
    public static void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        ItemStack itemstack = event.getPlayer().func_184586_b(event.getHand());
        if (itemstack.func_77973_b() instanceof IBauble) {
            IBauble bauble = (IBauble)itemstack.func_77973_b();
            IBaublesItemHandler itemHandler = (IBaublesItemHandler)BaublesAPI.getBaublesHandler(event.getPlayer()).orElseThrow(NullPointerException::new);
            int emptySlot = BaublesAPI.getEmptySlotForBaubleType(event.getPlayer(), bauble.getBaubleType(itemstack));
            if (emptySlot != -1) {
                itemHandler.setStackInSlot(emptySlot, itemstack.func_77946_l());
                itemstack.func_190920_e(0);
            }
        } else if (itemstack.getCapability(BaublesCapabilities.ITEM_BAUBLE).isPresent()) {
            IBauble bauble = (IBauble)itemstack.getCapability(BaublesCapabilities.ITEM_BAUBLE).orElseThrow(NullPointerException::new);
            IBaublesItemHandler itemHandler = (IBaublesItemHandler)BaublesAPI.getBaublesHandler(event.getPlayer()).orElseThrow(NullPointerException::new);
            int emptySlot = BaublesAPI.getEmptySlotForBaubleType(event.getPlayer(), bauble.getBaubleType(itemstack));
            if (emptySlot != -1) {
                itemHandler.setStackInSlot(emptySlot, itemstack.func_77946_l());
                itemstack.func_190920_e(0);
            }
        }
    }

    private static void syncSlots(PlayerEntity player, Collection<? extends PlayerEntity> receivers) {
        player.getCapability(BaublesCapabilities.BAUBLES).ifPresent(baubles -> {
            for (byte i = 0; i < baubles.getSlots(); i = (byte)(i + 1)) {
                EventHandlerEntity.syncSlot(player, i, baubles.getStackInSlot(i), receivers);
            }
        });
    }

    public static void syncSlot(PlayerEntity player, byte slot, ItemStack stack, Collection<? extends PlayerEntity> receivers) {
        SyncPacket pkt = new SyncPacket(player.func_145782_y(), slot, stack);
        for (PlayerEntity playerEntity : receivers) {
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)receiver), (Object)pkt);
        }
    }

    @SubscribeEvent
    public static void playerDeath(LivingDropsEvent event) {
        if (event.getEntity() instanceof PlayerEntity && !event.getEntity().field_70170_p.field_72995_K && !event.getEntity().field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
            EventHandlerEntity.dropItemsAt((PlayerEntity)event.getEntity(), event.getDrops());
        }
    }

    private static void dropItemsAt(PlayerEntity player, Collection<ItemEntity> drops) {
        player.getCapability(BaublesCapabilities.BAUBLES).ifPresent(baubles -> {
            for (int i = 0; i < baubles.getSlots(); ++i) {
                if (baubles.getStackInSlot(i).func_190926_b()) continue;
                ItemEntity ei = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_(), baubles.getStackInSlot(i).func_77946_l());
                ei.func_174867_a(40);
                drops.add(ei);
                baubles.setStackInSlot(i, ItemStack.field_190927_a);
            }
        });
    }
}

