/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.compat.jei;

import de.ellpeck.prettypipes.compat.jei.CraftingModuleTransferHandler;
import de.ellpeck.prettypipes.compat.jei.CraftingTerminalTransferHandler;
import de.ellpeck.prettypipes.misc.PlayerPrefs;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalGui;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IIngredientFilter;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@JeiPlugin
public class JEIPrettyPipesPlugin
implements IModPlugin {
    private IJeiRuntime runtime;
    private String lastTerminalText;
    private String lastJeiText;
    private Button jeiSyncButton;

    public JEIPrettyPipesPlugin() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("prettypipes", "jei_plugin");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        this.runtime = jeiRuntime;
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new CraftingTerminalTransferHandler(), VanillaRecipeCategoryUid.CRAFTING);
        registration.addUniversalRecipeTransferHandler((IRecipeTransferHandler)new CraftingModuleTransferHandler());
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(ItemTerminalGui.class, (IGuiContainerHandler)new IGuiContainerHandler<ItemTerminalGui>(){

            public List<Rectangle2d> getGuiExtraAreas(ItemTerminalGui containerScreen) {
                ArrayList<Rectangle2d> ret = new ArrayList<Rectangle2d>();
                ret.add(new Rectangle2d(containerScreen.getGuiLeft() - 22, containerScreen.getGuiTop(), 22, 64));
                if (containerScreen.currentlyCrafting != null && !containerScreen.currentlyCrafting.isEmpty()) {
                    ret.add(new Rectangle2d(containerScreen.getGuiLeft() + containerScreen.getXSize(), containerScreen.getGuiTop() + 4, 65, 89));
                }
                return ret;
            }
        });
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        Screen screen = event.getGui();
        if (!(screen instanceof ItemTerminalGui)) {
            return;
        }
        ItemTerminalGui terminal = (ItemTerminalGui)screen;
        this.jeiSyncButton = new Button(terminal.getGuiLeft() - 22, terminal.getGuiTop() + 44, 20, 20, (ITextComponent)new StringTextComponent(""), button -> {
            PlayerPrefs prefs = PlayerPrefs.get();
            prefs.syncJei = !prefs.syncJei;
            prefs.save();
            terminal.updateWidgets();
        });
        event.addWidget((Widget)this.jeiSyncButton);
        if (PlayerPrefs.get().syncJei) {
            terminal.search.func_146180_a(this.runtime.getIngredientFilter().getFilterText());
        }
    }

    @SubscribeEvent
    public void onRenderGui(GuiScreenEvent.DrawScreenEvent event) {
        Screen screen = event.getGui();
        if (!(screen instanceof ItemTerminalGui)) {
            return;
        }
        ItemTerminalGui terminal = (ItemTerminalGui)screen;
        boolean sync = PlayerPrefs.get().syncJei;
        if (event instanceof GuiScreenEvent.DrawScreenEvent.Post) {
            if (this.jeiSyncButton.func_230449_g_()) {
                terminal.func_238652_a_(event.getMatrixStack(), (ITextComponent)new TranslationTextComponent("info.prettypipes.sync_jei." + (sync ? "on" : "off")), event.getMouseX(), event.getMouseY());
            }
        } else if (event instanceof GuiScreenEvent.DrawScreenEvent.Pre) {
            this.jeiSyncButton.func_238482_a_((ITextComponent)new StringTextComponent((sync ? TextFormatting.GREEN : TextFormatting.RED) + "J"));
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!PlayerPrefs.get().syncJei) {
            return;
        }
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (!(screen instanceof ItemTerminalGui)) {
            this.lastTerminalText = null;
            this.lastJeiText = null;
            return;
        }
        ItemTerminalGui terminal = (ItemTerminalGui)screen;
        IIngredientFilter filter = this.runtime.getIngredientFilter();
        String terminalText = terminal.search.func_146179_b();
        String jeiText = filter.getFilterText();
        if (!jeiText.equals(this.lastJeiText)) {
            this.lastTerminalText = jeiText;
            this.lastJeiText = jeiText;
            terminal.search.func_146180_a(jeiText);
        } else if (!terminalText.equals(this.lastTerminalText)) {
            this.lastTerminalText = terminalText;
            this.lastJeiText = terminalText;
            filter.setFilterText(terminalText);
        }
    }
}

