/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.misc;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.ellpeck.prettypipes.misc.FilterSlot;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ItemFilter
extends ItemStackHandler {
    private final ItemStack stack;
    private final PipeTileEntity pipe;
    public boolean isWhitelist;
    public boolean canPopulateFromInventories;
    public boolean canModifyWhitelist = true;
    private boolean modified;

    public ItemFilter(int size, ItemStack stack, PipeTileEntity pipe) {
        super(size);
        this.stack = stack;
        this.pipe = pipe;
        if (stack.func_77942_o()) {
            this.deserializeNBT(stack.func_77978_p().func_74775_l("filter"));
        }
    }

    public List<Slot> getSlots(int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < this.getSlots(); ++i) {
            slots.add((Slot)new FilterSlot((IItemHandler)this, i, x + i % 9 * 18, y + i / 9 * 18, true));
        }
        return slots;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Widget> getButtons(final Screen gui, int x, int y) {
        ArrayList<Widget> buttons = new ArrayList<Widget>();
        if (this.canModifyWhitelist) {
            Supplier<TranslationTextComponent> whitelistText = () -> new TranslationTextComponent("info.prettypipes." + (this.isWhitelist ? "whitelist" : "blacklist"));
            buttons.add((Widget)new Button(x, y, 70, 20, (ITextComponent)whitelistText.get(), button -> {
                PacketButton.sendAndExecute(this.pipe.func_174877_v(), PacketButton.ButtonResult.FILTER_CHANGE, 0);
                button.func_238482_a_((ITextComponent)whitelistText.get());
            }));
        }
        if (this.canPopulateFromInventories) {
            buttons.add((Widget)new Button(x + 72, y, 70, 20, (ITextComponent)new TranslationTextComponent("info.prettypipes.populate"), button -> PacketButton.sendAndExecute(this.pipe.func_174877_v(), PacketButton.ButtonResult.FILTER_CHANGE, 1)){

                public void func_230443_a_(MatrixStack matrix, int x, int y) {
                    gui.func_238652_a_(matrix, (ITextComponent)new TranslationTextComponent("info.prettypipes.populate.description").func_240699_a_(TextFormatting.GRAY), x, y);
                }
            });
        }
        return buttons;
    }

    public void onButtonPacket(int id) {
        if (id == 0 && this.canModifyWhitelist) {
            this.isWhitelist = !this.isWhitelist;
            this.modified = true;
            this.save();
        } else if (id == 1 && this.canPopulateFromInventories) {
            List<ItemFilter> filters = this.pipe.getFilters();
            for (Direction direction : Direction.values()) {
                IItemHandler handler = this.pipe.getItemHandler(direction);
                if (handler == null) continue;
                block1: for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.func_190926_b() || this.isFiltered(stack)) continue;
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190920_e(1);
                    for (ItemFilter filter : filters) {
                        if (!ItemHandlerHelper.insertItem((IItemHandler)filter, (ItemStack)copy, (boolean)false).func_190926_b()) continue;
                        filter.save();
                        continue block1;
                    }
                }
            }
        }
    }

    public boolean isAllowed(ItemStack stack) {
        return this.isFiltered(stack) == this.isWhitelist;
    }

    private boolean isFiltered(ItemStack stack) {
        ItemEquality[] types = ItemFilter.getEqualityTypes(this.pipe);
        for (ItemStackHandler itemStackHandler : this.pipe.getFilters()) {
            for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
                ItemStack filter = itemStackHandler.getStackInSlot(i);
                if (filter.func_190926_b() || !ItemEquality.compareItems(stack, filter, types)) continue;
                return true;
            }
        }
        return false;
    }

    public void save() {
        if (this.modified) {
            this.stack.func_196082_o().func_218657_a("filter", (INBT)this.serializeNBT());
            this.modified = false;
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        if (this.canModifyWhitelist) {
            nbt.func_74757_a("whitelist", this.isWhitelist);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        if (this.canModifyWhitelist) {
            this.isWhitelist = nbt.func_74767_n("whitelist");
        }
    }

    protected void onContentsChanged(int slot) {
        this.modified = true;
    }

    public static ItemEquality[] getEqualityTypes(PipeTileEntity pipe) {
        return (ItemEquality[])pipe.streamModules().filter(m -> m.getRight() instanceof FilterModifierModuleItem).map(m -> ((FilterModifierModuleItem)m.getRight()).getEqualityType((ItemStack)m.getLeft())).toArray(ItemEquality[]::new);
    }

    public static interface IFilteredContainer {
        public ItemFilter getFilter();
    }
}

