/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.network;

import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;

public class NetworkLocation
implements INBTSerializable<CompoundNBT> {
    public BlockPos pipePos;
    public Direction direction;
    private Map<Integer, ItemStack> itemCache;
    private IItemHandler handlerCache;

    public NetworkLocation(BlockPos pipePos, Direction direction) {
        this.pipePos = pipePos;
        this.direction = direction;
    }

    public NetworkLocation(CompoundNBT nbt) {
        this.deserializeNBT(nbt);
    }

    public List<Integer> getStackSlots(World world, ItemStack stack, ItemEquality ... equalityTypes) {
        if (this.isEmpty(world)) {
            return Collections.emptyList();
        }
        return this.getItems(world).entrySet().stream().filter(kv -> ItemEquality.compareItems((ItemStack)kv.getValue(), stack, equalityTypes) && this.canExtract(world, (Integer)kv.getKey())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public int getItemAmount(World world, ItemStack stack, ItemEquality ... equalityTypes) {
        if (this.isEmpty(world)) {
            return 0;
        }
        return this.getItems(world).entrySet().stream().filter(kv -> ItemEquality.compareItems(stack, (ItemStack)kv.getValue(), equalityTypes) && this.canExtract(world, (Integer)kv.getKey())).mapToInt(kv -> ((ItemStack)kv.getValue()).func_190916_E()).sum();
    }

    public Map<Integer, ItemStack> getItems(World world) {
        IItemHandler handler;
        if (this.itemCache == null && (handler = this.getItemHandler(world)) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                if (this.itemCache == null) {
                    this.itemCache = new HashMap<Integer, ItemStack>();
                }
                this.itemCache.put(i, stack);
            }
        }
        return this.itemCache;
    }

    public boolean canExtract(World world, int slot) {
        IItemHandler handler = this.getItemHandler(world);
        return handler != null && !handler.extractItem(slot, 1, true).func_190926_b();
    }

    public IItemHandler getItemHandler(World world) {
        if (this.handlerCache == null) {
            PipeNetwork network = PipeNetwork.get(world);
            PipeTileEntity pipe = network.getPipe(this.pipePos);
            this.handlerCache = pipe.getItemHandler(this.direction);
        }
        return this.handlerCache;
    }

    public boolean isEmpty(World world) {
        Map<Integer, ItemStack> items = this.getItems(world);
        return items == null || items.isEmpty();
    }

    public BlockPos getPos() {
        return this.pipePos.func_177972_a(this.direction);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("pipe_pos", (INBT)NBTUtil.func_186859_a((BlockPos)this.pipePos));
        nbt.func_74768_a("direction", this.direction.func_176745_a());
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.pipePos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("pipe_pos"));
        this.direction = Direction.func_82600_a((int)nbt.func_74762_e("direction"));
    }
}

