/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.misc.ItemFilter;
import de.ellpeck.prettypipes.network.NetworkLock;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import de.ellpeck.prettypipes.pipe.containers.MainPipeContainer;
import de.ellpeck.prettypipes.pressurizer.PressurizerTileEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.profiler.IProfiler;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class PipeTileEntity
extends TileEntity
implements INamedContainerProvider,
ITickableTileEntity,
IPipeConnectable {
    public final ItemStackHandler modules = new ItemStackHandler(3){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            Item item = stack.func_77973_b();
            if (!(item instanceof IModule)) {
                return false;
            }
            IModule module = (IModule)item;
            return PipeTileEntity.this.streamModules().allMatch(m -> module.isCompatible(stack, PipeTileEntity.this, (IModule)m.getRight()) && ((IModule)m.getRight()).isCompatible((ItemStack)m.getLeft(), PipeTileEntity.this, module));
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    public final Queue<NetworkLock> craftIngredientRequests = new LinkedList<NetworkLock>();
    public final List<Pair<BlockPos, ItemStack>> craftResultRequests = new ArrayList<Pair<BlockPos, ItemStack>>();
    public PressurizerTileEntity pressurizer;
    public BlockState cover;
    public int moduleDropCheck;
    protected List<IPipeItem> items;
    private int lastItemAmount;
    private int priority;
    private final LazyOptional<PipeTileEntity> lazyThis = LazyOptional.of(() -> this);
    private final Lazy<Integer> workRandomizer = Lazy.of(() -> this.field_145850_b.field_73012_v.nextInt(200));

    public PipeTileEntity() {
        this(Registry.pipeTileEntity);
    }

    protected PipeTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public void onChunkUnloaded() {
        PipeNetwork.get(this.field_145850_b).uncachePipe(this.field_174879_c);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("modules", (INBT)this.modules.serializeNBT());
        compound.func_74768_a("module_drop_check", this.moduleDropCheck);
        compound.func_218657_a("requests", (INBT)Utility.serializeAll(this.craftIngredientRequests));
        if (this.cover != null) {
            compound.func_218657_a("cover", (INBT)NBTUtil.func_190009_a((BlockState)this.cover));
        }
        ListNBT results = new ListNBT();
        for (Pair<BlockPos, ItemStack> triple : this.craftResultRequests) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74772_a("dest_pipe", ((BlockPos)triple.getLeft()).func_218275_a());
            nbt.func_218657_a("item", (INBT)((ItemStack)triple.getRight()).serializeNBT());
            results.add((Object)nbt);
        }
        compound.func_218657_a("craft_results", (INBT)results);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.modules.deserializeNBT(compound.func_74775_l("modules"));
        this.moduleDropCheck = compound.func_74762_e("module_drop_check");
        this.cover = compound.func_74764_b("cover") ? NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("cover")) : null;
        this.craftIngredientRequests.clear();
        this.craftIngredientRequests.addAll(Utility.deserializeAll(compound.func_150295_c("requests", 10), NetworkLock::new));
        this.craftResultRequests.clear();
        ListNBT results = compound.func_150295_c("craft_results", 10);
        for (int i = 0; i < results.size(); ++i) {
            CompoundNBT nbt = results.func_150305_b(i);
            this.craftResultRequests.add((Pair<BlockPos, ItemStack>)Pair.of((Object)BlockPos.func_218283_e((long)nbt.func_74763_f("dest_pipe")), (Object)ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("item"))));
        }
        super.func_230337_a_(state, compound);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = this.func_189515_b(new CompoundNBT());
        nbt.func_218657_a("items", (INBT)Utility.serializeAll(this.getItems()));
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        this.func_230337_a_(state, nbt);
        List<IPipeItem> items = this.getItems();
        items.clear();
        items.addAll(Utility.deserializeAll(nbt.func_150295_c("items", 10), IPipeItem::load));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void func_73660_a() {
        if (this.pressurizer != null && this.pressurizer.func_145837_r()) {
            this.pressurizer = null;
        }
        if (!this.field_145850_b.isAreaLoaded(this.field_174879_c, 1)) {
            return;
        }
        IProfiler profiler = this.field_145850_b.func_217381_Z();
        if (!this.field_145850_b.field_72995_K) {
            if (this.moduleDropCheck > 0) {
                --this.moduleDropCheck;
                if (this.moduleDropCheck <= 0 && !this.canHaveModules()) {
                    Utility.dropInventory(this, (IItemHandler)this.modules);
                }
            }
            profiler.func_76320_a("ticking_modules");
            int prio = 0;
            Iterator modules = this.streamModules().iterator();
            while (modules.hasNext()) {
                Pair module = (Pair)modules.next();
                ((IModule)module.getRight()).tick((ItemStack)module.getLeft(), this);
                prio += ((IModule)module.getRight()).getPriority((ItemStack)module.getLeft(), this);
            }
            if (prio != this.priority) {
                this.priority = prio;
                PipeNetwork.get(this.field_145850_b).clearDestinationCache(this.field_174879_c);
            }
            profiler.func_76319_b();
        }
        profiler.func_76320_a("ticking_items");
        List<IPipeItem> items = this.getItems();
        for (int i = items.size() - 1; i >= 0; --i) {
            items.get(i).updateInPipe(this);
        }
        if (items.size() != this.lastItemAmount) {
            this.lastItemAmount = items.size();
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
        profiler.func_76319_b();
    }

    public List<IPipeItem> getItems() {
        if (this.items == null) {
            this.items = PipeNetwork.get(this.field_145850_b).getItemsInPipe(this.field_174879_c);
        }
        return this.items;
    }

    public void addNewItem(IPipeItem item) {
        if (!this.getItems().contains(item)) {
            this.getItems().add(item);
        }
        if (this.pressurizer != null) {
            this.pressurizer.pressurizeItem(item.getContent(), false);
        }
    }

    public boolean isConnected(Direction dir) {
        return ((ConnectionType)((Object)this.func_195044_w().func_177229_b((Property)PipeBlock.DIRECTIONS.get(dir)))).isConnected();
    }

    public Pair<BlockPos, ItemStack> getAvailableDestinationOrConnectable(ItemStack stack, boolean force, boolean preventOversending) {
        Pair<BlockPos, ItemStack> dest = this.getAvailableDestination(stack, force, preventOversending);
        if (dest != null) {
            return dest;
        }
        for (Direction dir : Direction.values()) {
            ItemStack connectableRemain;
            IPipeConnectable connectable = this.getPipeConnectable(dir);
            if (connectable == null || (connectableRemain = connectable.insertItem(this.func_174877_v(), dir, stack, true)).func_190916_E() == stack.func_190916_E()) continue;
            ItemStack inserted = stack.func_77946_l();
            inserted.func_190918_g(connectableRemain.func_190916_E());
            return Pair.of((Object)this.func_174877_v().func_177972_a(dir), (Object)inserted);
        }
        return null;
    }

    public Pair<BlockPos, ItemStack> getAvailableDestination(ItemStack stack, boolean force, boolean preventOversending) {
        if (!this.canWork()) {
            return null;
        }
        if (!force && this.streamModules().anyMatch(m -> !((IModule)m.getRight()).canAcceptItem((ItemStack)m.getLeft(), this, stack))) {
            return null;
        }
        for (Direction dir : Direction.values()) {
            PipeNetwork network;
            int onTheWay;
            ItemStack remain;
            IItemHandler handler = this.getItemHandler(dir);
            if (handler == null || (remain = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true)).func_190916_E() == stack.func_190916_E()) continue;
            ItemStack toInsert = stack.func_77946_l();
            toInsert.func_190918_g(remain.func_190916_E());
            int maxAmount = this.streamModules().mapToInt(m -> ((IModule)m.getRight()).getMaxInsertionAmount((ItemStack)m.getLeft(), this, stack, handler)).min().orElse(Integer.MAX_VALUE);
            if (maxAmount < toInsert.func_190916_E()) {
                toInsert.func_190920_e(maxAmount);
            }
            BlockPos offset = this.field_174879_c.func_177972_a(dir);
            if ((preventOversending || maxAmount < Integer.MAX_VALUE) && (onTheWay = (network = PipeNetwork.get(this.field_145850_b)).getItemsOnTheWay(offset, null, new ItemEquality[0])) > 0) {
                if (maxAmount < Integer.MAX_VALUE) {
                    int onTheWaySame = network.getItemsOnTheWay(offset, stack, new ItemEquality[0]);
                    if (toInsert.func_190916_E() + onTheWaySame > maxAmount) {
                        toInsert.func_190920_e(maxAmount - onTheWaySame);
                    }
                }
                int totalSpace = 0;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack copy = stack.func_77946_l();
                    int maxStackSize = copy.func_77976_d();
                    int limit = handler.getSlotLimit(i);
                    if (limit > 64) {
                        maxStackSize = limit;
                    }
                    copy.func_190920_e(maxStackSize);
                    ItemStack left = handler.insertItem(i, copy, true);
                    totalSpace += maxStackSize - left.func_190916_E();
                }
                if (onTheWay + toInsert.func_190916_E() > totalSpace) {
                    toInsert.func_190920_e(totalSpace - onTheWay);
                }
            }
            if (toInsert.func_190926_b()) continue;
            return Pair.of((Object)offset, (Object)toInsert);
        }
        return null;
    }

    public int getPriority() {
        return this.priority;
    }

    public float getItemSpeed(ItemStack stack) {
        float moduleSpeed = (float)this.streamModules().mapToDouble(m -> ((IModule)m.getRight()).getItemSpeedIncrease((ItemStack)m.getLeft(), this)).sum();
        float pressureSpeed = this.pressurizer != null && this.pressurizer.pressurizeItem(stack, true) ? 0.45f : 0.0f;
        return 0.05f + moduleSpeed + pressureSpeed;
    }

    public boolean canWork() {
        return this.streamModules().allMatch(m -> ((IModule)m.getRight()).canPipeWork((ItemStack)m.getLeft(), this));
    }

    public List<ItemStack> getAllCraftables() {
        return this.streamModules().flatMap(m -> ((IModule)m.getRight()).getAllCraftables((ItemStack)m.getLeft(), this).stream()).collect(Collectors.toList());
    }

    public int getCraftableAmount(Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain) {
        int total = 0;
        Iterator modules = this.streamModules().iterator();
        while (modules.hasNext()) {
            int amount;
            Pair module = (Pair)modules.next();
            if (!dependencyChain.stream().noneMatch(d -> ItemEquality.compareItems((ItemStack)module.getLeft(), d, ItemEquality.NBT)) || (amount = ((IModule)module.getRight()).getCraftableAmount((ItemStack)module.getLeft(), this, unavailableConsumer, stack, dependencyChain)) <= 0) continue;
            total += amount;
        }
        return total;
    }

    public ItemStack craft(BlockPos destPipe, Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain) {
        Pair module;
        Iterator modules = this.streamModules().iterator();
        while (modules.hasNext() && !(stack = ((IModule)(module = (Pair)modules.next()).getRight()).craft((ItemStack)module.getLeft(), this, destPipe, unavailableConsumer, stack, dependencyChain)).func_190926_b()) {
        }
        return stack;
    }

    public IItemHandler getItemHandler(Direction dir) {
        IItemHandler handler = (IItemHandler)this.getNeighborCap(dir, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (handler != null) {
            return handler;
        }
        return Utility.getBlockItemHandler(this.field_145850_b, this.field_174879_c.func_177972_a(dir), dir.func_176734_d());
    }

    public <T> T getNeighborCap(Direction dir, Capability<T> cap) {
        if (!this.isConnected(dir)) {
            return null;
        }
        BlockPos pos = this.field_174879_c.func_177972_a(dir);
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        if (tile != null) {
            return (T)tile.getCapability(cap, dir.func_176734_d()).orElse(null);
        }
        return null;
    }

    public IPipeConnectable getPipeConnectable(Direction dir) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
        if (tile != null) {
            return (IPipeConnectable)tile.getCapability(Registry.pipeConnectableCapability, dir.func_176734_d()).orElse(null);
        }
        return null;
    }

    public boolean isConnectedInventory(Direction dir) {
        return this.getItemHandler(dir) != null;
    }

    public boolean canHaveModules() {
        for (Direction dir : Direction.values()) {
            if (this.isConnectedInventory(dir)) {
                return true;
            }
            IPipeConnectable connectable = this.getPipeConnectable(dir);
            if (connectable == null || !connectable.allowsModules(this.field_174879_c, dir)) continue;
            return true;
        }
        return false;
    }

    public boolean canNetworkSee() {
        return this.streamModules().allMatch(m -> ((IModule)m.getRight()).canNetworkSee((ItemStack)m.getLeft(), this));
    }

    public Stream<Pair<ItemStack, IModule>> streamModules() {
        Stream.Builder<Pair> builder = Stream.builder();
        for (int i = 0; i < this.modules.getSlots(); ++i) {
            ItemStack stack = this.modules.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            builder.accept(Pair.of((Object)stack, (Object)((IModule)stack.func_77973_b())));
        }
        return builder.build();
    }

    public void removeCover(PlayerEntity player, Hand hand) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        List drops = Block.func_220077_a((BlockState)this.cover, (ServerWorld)((ServerWorld)this.field_145850_b), (BlockPos)this.field_174879_c, null, (Entity)player, (ItemStack)player.func_184586_b(hand));
        for (ItemStack drop : drops) {
            Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, (ItemStack)drop);
        }
        this.cover = null;
    }

    public boolean shouldWorkNow(int speed) {
        return (this.field_145850_b.func_82737_E() + (long)((Integer)this.workRandomizer.get()).intValue()) % (long)speed == 0L;
    }

    public int getNextNode(List<BlockPos> nodes, int index) {
        return this.streamModules().map(m -> ((IModule)m.getRight()).getCustomNextNode((ItemStack)m.getLeft(), this, nodes, index)).filter(Objects::nonNull).findFirst().orElse(index);
    }

    public List<ItemFilter> getFilters() {
        return this.streamModules().map(p -> ((IModule)p.getRight()).getItemFilter((ItemStack)p.getLeft(), this)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.getItems().clear();
        PipeNetwork network = PipeNetwork.get(this.field_145850_b);
        for (NetworkLock lock : this.craftIngredientRequests) {
            network.resolveNetworkLock(lock);
        }
        this.lazyThis.invalidate();
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.prettypipes.pipe");
    }

    @Nullable
    public Container createMenu(int window, PlayerInventory inv, PlayerEntity player) {
        return new MainPipeContainer(Registry.pipeContainer, window, player, this.field_174879_c);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Registry.pipeConnectableCapability) {
            return this.lazyThis.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public ConnectionType getConnectionType(BlockPos pipePos, Direction direction) {
        BlockState state = this.field_145850_b.func_180495_p(pipePos.func_177972_a(direction));
        if (state.func_177229_b((Property)PipeBlock.DIRECTIONS.get(direction.func_176734_d())) == ConnectionType.BLOCKED) {
            return ConnectionType.BLOCKED;
        }
        return ConnectionType.CONNECTED;
    }
}

