/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe.modules.craft;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.items.ModuleItem;
import de.ellpeck.prettypipes.items.ModuleTier;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.misc.ItemFilter;
import de.ellpeck.prettypipes.network.NetworkLocation;
import de.ellpeck.prettypipes.network.NetworkLock;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleContainer;
import de.ellpeck.prettypipes.terminal.CraftingTerminalTileEntity;
import de.ellpeck.prettypipes.terminal.ItemTerminalTileEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class CraftingModuleItem
extends ModuleItem {
    public final int inputSlots;
    public final int outputSlots;
    private final int speed;

    public CraftingModuleItem(String name, ModuleTier tier) {
        super(name);
        this.inputSlots = tier.forTier(1, 4, 9);
        this.outputSlots = tier.forTier(1, 2, 4);
        this.speed = tier.forTier(20, 10, 5);
    }

    @Override
    public boolean isCompatible(ItemStack module, PipeTileEntity tile, IModule other) {
        return true;
    }

    @Override
    public boolean hasContainer(ItemStack module, PipeTileEntity tile) {
        return true;
    }

    @Override
    public AbstractPipeContainer<?> getContainer(ItemStack module, PipeTileEntity tile, int windowId, PlayerInventory inv, PlayerEntity player, int moduleIndex) {
        return new CraftingModuleContainer(Registry.craftingModuleContainer, windowId, player, tile.func_174877_v(), moduleIndex);
    }

    @Override
    public boolean canNetworkSee(ItemStack module, PipeTileEntity tile) {
        return false;
    }

    @Override
    public boolean canAcceptItem(ItemStack module, PipeTileEntity tile, ItemStack stack) {
        return false;
    }

    @Override
    public void tick(ItemStack module, PipeTileEntity tile) {
        ItemStack remain;
        ItemEquality[] equalityTypes;
        if (!tile.shouldWorkNow(this.speed) || !tile.canWork()) {
            return;
        }
        PipeNetwork network = PipeNetwork.get(tile.func_145831_w());
        if (!tile.craftIngredientRequests.isEmpty()) {
            network.startProfile("crafting_ingredients");
            NetworkLock request = tile.craftIngredientRequests.peek();
            equalityTypes = ItemFilter.getEqualityTypes(tile);
            Pair<BlockPos, ItemStack> dest = tile.getAvailableDestination(request.stack, true, true);
            if (dest != null) {
                ItemStack requestRemain = network.requestExistingItem(request.location, tile.func_174877_v(), (BlockPos)dest.getLeft(), request, (ItemStack)dest.getRight(), equalityTypes);
                network.resolveNetworkLock(request);
                tile.craftIngredientRequests.remove();
                remain = request.stack.func_77946_l();
                remain.func_190918_g(((ItemStack)dest.getRight()).func_190916_E() - requestRemain.func_190916_E());
                if (!remain.func_190926_b()) {
                    NetworkLock remainRequest = new NetworkLock(request.location, remain);
                    tile.craftIngredientRequests.add(remainRequest);
                    network.createNetworkLock(remainRequest);
                }
            }
            network.endProfile();
        }
        if (!tile.craftResultRequests.isEmpty()) {
            network.startProfile("crafting_results");
            List<NetworkLocation> items = network.getOrderedNetworkItems(tile.func_174877_v());
            equalityTypes = ItemFilter.getEqualityTypes(tile);
            for (Pair<BlockPos, ItemStack> request : tile.craftResultRequests) {
                Pair<BlockPos, ItemStack> dest;
                remain = ((ItemStack)request.getRight()).func_77946_l();
                PipeTileEntity destPipe = network.getPipe((BlockPos)request.getLeft());
                if (destPipe == null || (dest = destPipe.getAvailableDestinationOrConnectable(remain, true, true)) == null) continue;
                for (NetworkLocation item : items) {
                    ItemStack requestRemain = network.requestExistingItem(item, (BlockPos)request.getLeft(), (BlockPos)dest.getLeft(), null, (ItemStack)dest.getRight(), equalityTypes);
                    remain.func_190918_g(((ItemStack)dest.getRight()).func_190916_E() - requestRemain.func_190916_E());
                    if (!remain.func_190926_b()) continue;
                    break;
                }
                if (remain.func_190916_E() == ((ItemStack)request.getRight()).func_190916_E()) continue;
                tile.craftResultRequests.remove(request);
                if (!remain.func_190926_b()) {
                    tile.craftResultRequests.add((Pair<BlockPos, ItemStack>)Pair.of((Object)request.getLeft(), (Object)remain));
                }
                network.endProfile();
                return;
            }
            network.endProfile();
        }
    }

    @Override
    public List<ItemStack> getAllCraftables(ItemStack module, PipeTileEntity tile) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ItemStackHandler output = this.getOutput(module);
        for (int i = 0; i < output.getSlots(); ++i) {
            ItemStack stack = output.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ret.add(stack);
        }
        return ret;
    }

    @Override
    public int getCraftableAmount(ItemStack module, PipeTileEntity tile, Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain) {
        PipeNetwork network = PipeNetwork.get(tile.func_145831_w());
        List<NetworkLocation> items = network.getOrderedNetworkItems(tile.func_174877_v());
        ItemEquality[] equalityTypes = ItemFilter.getEqualityTypes(tile);
        ItemStackHandler input = this.getInput(module);
        int craftable = 0;
        ItemStackHandler output = this.getOutput(module);
        for (int i = 0; i < output.getSlots(); ++i) {
            ItemStack out = output.getStackInSlot(i);
            if (out.func_190926_b() || !ItemEquality.compareItems(out, stack, equalityTypes)) continue;
            int availableCrafts = CraftingTerminalTileEntity.getAvailableCrafts(tile, input.getSlots(), arg_0 -> ((ItemStackHandler)input).getStackInSlot(arg_0), k -> true, s -> items, unavailableConsumer, CraftingModuleItem.addDependency(dependencyChain, module), equalityTypes);
            if (availableCrafts <= 0) continue;
            craftable += out.func_190916_E() * availableCrafts;
        }
        return craftable;
    }

    @Override
    public ItemStack craft(ItemStack module, PipeTileEntity tile, BlockPos destPipe, Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain) {
        int craftableAmount = this.getCraftableAmount(module, tile, unavailableConsumer, stack, dependencyChain);
        if (craftableAmount <= 0) {
            return stack;
        }
        PipeNetwork network = PipeNetwork.get(tile.func_145831_w());
        List<NetworkLocation> items = network.getOrderedNetworkItems(tile.func_174877_v());
        ItemEquality[] equalityTypes = ItemFilter.getEqualityTypes(tile);
        int resultAmount = this.getResultAmountPerCraft(module, stack, equalityTypes);
        int requiredCrafts = MathHelper.func_76123_f((float)((float)stack.func_190916_E() / (float)resultAmount));
        int toCraft = Math.min(craftableAmount, requiredCrafts);
        ItemStackHandler input = this.getInput(module);
        for (int i = 0; i < input.getSlots(); ++i) {
            ItemStack in = input.getStackInSlot(i);
            if (in.func_190926_b()) continue;
            ItemStack copy = in.func_77946_l();
            copy.func_190920_e(in.func_190916_E() * toCraft);
            Pair<List<NetworkLock>, ItemStack> ret = ItemTerminalTileEntity.requestItemLater(tile.func_145831_w(), tile.func_174877_v(), items, unavailableConsumer, copy, CraftingModuleItem.addDependency(dependencyChain, module), equalityTypes);
            tile.craftIngredientRequests.addAll((Collection)ret.getLeft());
        }
        ItemStack remain = stack.func_77946_l();
        remain.func_190918_g(resultAmount * toCraft);
        ItemStack result = stack.func_77946_l();
        result.func_190918_g(remain.func_190916_E());
        tile.craftResultRequests.add((Pair<BlockPos, ItemStack>)Pair.of((Object)destPipe, (Object)result));
        return remain;
    }

    public ItemStackHandler getInput(ItemStack module) {
        ItemStackHandler handler = new ItemStackHandler(this.inputSlots);
        if (module.func_77942_o()) {
            handler.deserializeNBT(module.func_77978_p().func_74775_l("input"));
        }
        return handler;
    }

    public ItemStackHandler getOutput(ItemStack module) {
        ItemStackHandler handler = new ItemStackHandler(this.outputSlots);
        if (module.func_77942_o()) {
            handler.deserializeNBT(module.func_77978_p().func_74775_l("output"));
        }
        return handler;
    }

    public void save(ItemStackHandler input, ItemStackHandler output, ItemStack module) {
        CompoundNBT tag = module.func_196082_o();
        if (input != null) {
            tag.func_218657_a("input", (INBT)input.serializeNBT());
        }
        if (output != null) {
            tag.func_218657_a("output", (INBT)output.serializeNBT());
        }
    }

    private int getResultAmountPerCraft(ItemStack module, ItemStack stack, ItemEquality ... equalityTypes) {
        ItemStackHandler output = this.getOutput(module);
        int resultAmount = 0;
        for (int i = 0; i < output.getSlots(); ++i) {
            ItemStack out = output.getStackInSlot(i);
            if (!ItemEquality.compareItems(stack, out, equalityTypes)) continue;
            resultAmount += out.func_190916_E();
        }
        return resultAmount;
    }

    private static Stack<ItemStack> addDependency(Stack<ItemStack> deps, ItemStack module) {
        deps = (Stack)deps.clone();
        deps.push(module);
        return deps;
    }
}

