/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal.containers;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.ellpeck.prettypipes.misc.ItemTerminalWidget;
import de.ellpeck.prettypipes.misc.PlayerPrefs;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.packets.PacketRequest;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.internal.Strings;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Pair;

public class ItemTerminalGui
extends ContainerScreen<ItemTerminalContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("prettypipes", "textures/gui/item_terminal.png");
    public List<ItemStack> currentlyCrafting;
    public TextFieldWidget search;
    private final List<Pair<ItemStack, Boolean>> sortedItems = new ArrayList<Pair<ItemStack, Boolean>>();
    private List<ItemStack> items;
    private List<ItemStack> craftables;
    private Button minusButton;
    private Button plusButton;
    private Button requestButton;
    private Button orderButton;
    private Button ascendingButton;
    private Button cancelCraftingButton;
    private String lastSearchText;
    private int requestAmount = 1;
    private int scrollOffset;
    private ItemStack hoveredCrafting;
    private boolean isScrolling;

    public ItemTerminalGui(ItemTerminalContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_146999_f = 191;
        this.field_147000_g = 236;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.search = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.field_147003_i + this.getXOffset() + 97, this.field_147009_r + 6, 86, 8, (ITextComponent)new StringTextComponent("")));
        this.search.func_146185_a(false);
        this.lastSearchText = "";
        if (this.items != null) {
            this.updateWidgets();
        }
        this.plusButton = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + this.getXOffset() + 95 - 7 + 12, this.field_147009_r + 103, 12, 12, (ITextComponent)new StringTextComponent("+"), button -> {
            int modifier = ItemTerminalGui.requestModifier();
            this.requestAmount = modifier > 1 && this.requestAmount == 1 ? modifier : (this.requestAmount += modifier);
            if (this.requestAmount > 384) {
                this.requestAmount = 384;
            }
        }));
        this.minusButton = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + this.getXOffset() + 95 - 7 - 24, this.field_147009_r + 103, 12, 12, (ITextComponent)new StringTextComponent("-"), button -> {
            this.requestAmount -= ItemTerminalGui.requestModifier();
            if (this.requestAmount < 1) {
                this.requestAmount = 1;
            }
        }));
        this.minusButton.field_230693_o_ = false;
        this.requestButton = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + this.getXOffset() + 95 - 7 - 25, this.field_147009_r + 115, 50, 20, (ITextComponent)new TranslationTextComponent("info.prettypipes.request"), button -> {
            Optional<ItemTerminalWidget> widget = this.streamWidgets().filter(w -> w.selected).findFirst();
            if (!widget.isPresent()) {
                return;
            }
            ItemStack stack = widget.get().stack.func_77946_l();
            stack.func_190920_e(1);
            PacketHandler.sendToServer(new PacketRequest(((ItemTerminalContainer)this.field_147002_h).tile.func_174877_v(), stack, this.requestAmount));
            this.requestAmount = 1;
        }));
        this.requestButton.field_230693_o_ = false;
        this.orderButton = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i - 22, this.field_147009_r, 20, 20, (ITextComponent)new StringTextComponent(""), button -> {
            if (this.sortedItems == null) {
                return;
            }
            PlayerPrefs prefs = PlayerPrefs.get();
            prefs.terminalItemOrder = prefs.terminalItemOrder.next();
            prefs.save();
            this.updateWidgets();
        }));
        this.ascendingButton = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i - 22, this.field_147009_r + 22, 20, 20, (ITextComponent)new StringTextComponent(""), button -> {
            if (this.sortedItems == null) {
                return;
            }
            PlayerPrefs prefs = PlayerPrefs.get();
            prefs.terminalAscending = !prefs.terminalAscending;
            prefs.save();
            this.updateWidgets();
        }));
        this.cancelCraftingButton = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + this.field_146999_f + 4, this.field_147009_r + 4 + 64, 54, 20, (ITextComponent)new TranslationTextComponent("info.prettypipes.cancel_all"), b -> {}));
        this.cancelCraftingButton.field_230694_p_ = false;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_230480_a_(new ItemTerminalWidget(this.field_147003_i + this.getXOffset() + 8 + x * 18, this.field_147009_r + 18 + y * 18, x, y, this));
            }
        }
    }

    protected int getXOffset() {
        return 0;
    }

    public void func_231023_e_() {
        String text;
        super.func_231023_e_();
        this.requestButton.field_230693_o_ = this.streamWidgets().anyMatch(w -> w.selected);
        this.plusButton.field_230693_o_ = this.requestAmount < 384;
        this.minusButton.field_230693_o_ = this.requestAmount > 1;
        this.search.func_146178_a();
        if (this.items != null && !this.lastSearchText.equals(text = this.search.func_146179_b())) {
            this.lastSearchText = text;
            this.updateWidgets();
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (button == 0 && mouseX >= (double)(this.field_147003_i + this.getXOffset() + 172) && (double)this.field_147009_r + mouseY >= 18.0 && mouseX < (double)(this.field_147003_i + this.getXOffset() + 172 + 12) && mouseY < (double)(this.field_147009_r + 18 + 70)) {
            this.isScrolling = true;
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.cancelCraftingButton.field_230694_p_ && this.cancelCraftingButton.func_230449_g_() && this.currentlyCrafting != null && !this.currentlyCrafting.isEmpty()) {
            PacketHandler.sendToServer(new PacketButton(((ItemTerminalContainer)this.field_147002_h).tile.func_174877_v(), PacketButton.ButtonResult.CANCEL_CRAFTING, new int[0]));
            return true;
        }
        if (button == 0) {
            this.isScrolling = false;
        } else if (button == 1 && mouseX >= (double)this.search.field_230690_l_ && mouseX <= (double)(this.search.field_230690_l_ + this.search.func_230998_h_()) && mouseY >= (double)this.search.field_230691_m_ && mouseY <= (double)(this.search.field_230691_m_ + 8)) {
            this.search.func_146180_a("");
            return true;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int i, double j, double k) {
        if (this.isScrolling) {
            float percentage = MathHelper.func_76131_a((float)(((float)mouseY - (float)(this.field_147009_r + 18) - 7.5f) / 55.0f), (float)0.0f, (float)1.0f);
            int offset = (int)(percentage * (float)(this.sortedItems.size() / 9 - 3));
            if (offset != this.scrollOffset) {
                this.scrollOffset = offset;
                this.updateWidgets();
            }
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, i, j, k);
    }

    public boolean func_231046_a_(int x, int y, int z) {
        InputMappings.Input mouseKey;
        if (this.search.func_230999_j_() && this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey = InputMappings.func_197954_a((int)x, (int)y))) {
            return false;
        }
        return super.func_231046_a_(x, y, z);
    }

    public void updateItemList(List<ItemStack> items, List<ItemStack> craftables, List<ItemStack> currentlyCrafting) {
        this.items = items;
        this.craftables = craftables;
        this.currentlyCrafting = currentlyCrafting;
        this.updateWidgets();
    }

    public void updateWidgets() {
        PlayerPrefs prefs = PlayerPrefs.get();
        this.ascendingButton.func_238482_a_((ITextComponent)new StringTextComponent(prefs.terminalAscending ? "^" : "v"));
        this.orderButton.func_238482_a_((ITextComponent)new StringTextComponent(prefs.terminalItemOrder.name().substring(0, 1)));
        this.cancelCraftingButton.field_230694_p_ = this.currentlyCrafting != null && !this.currentlyCrafting.isEmpty();
        Comparator<ItemStack> comparator = prefs.terminalItemOrder.comparator;
        if (!prefs.terminalAscending) {
            comparator = comparator.reversed();
        }
        this.sortedItems.clear();
        for (ItemStack stack : this.items) {
            this.sortedItems.add((Pair<ItemStack, Boolean>)Pair.of((Object)stack, (Object)false));
        }
        for (ItemStack stack : this.craftables) {
            this.sortedItems.add((Pair<ItemStack, Boolean>)Pair.of((Object)stack, (Object)true));
        }
        Comparator<Pair> fullComparator = Comparator.comparing(Pair::getRight);
        this.sortedItems.sort(fullComparator.thenComparing(Pair::getLeft, comparator));
        String searchText = this.search.func_146179_b();
        if (!Strings.isNullOrEmpty((String)searchText)) {
            this.sortedItems.removeIf(s -> {
                String toCompare;
                String search = searchText;
                if (search.startsWith("@")) {
                    toCompare = ((ItemStack)s.getLeft()).func_77973_b().getCreatorModId((ItemStack)s.getLeft());
                    search = search.substring(1);
                } else {
                    toCompare = ((ItemStack)s.getLeft()).func_200301_q().getString();
                }
                return !toCompare.toLowerCase(Locale.ROOT).contains(search.toLowerCase(Locale.ROOT));
            });
        }
        if (this.sortedItems.size() < 36) {
            this.scrollOffset = 0;
        }
        List widgets = this.streamWidgets().collect(Collectors.toList());
        for (int i = 0; i < widgets.size(); ++i) {
            ItemTerminalWidget widget = (ItemTerminalWidget)((Object)widgets.get(i));
            int index = i + this.scrollOffset * 9;
            if (index >= this.sortedItems.size()) {
                widget.stack = ItemStack.field_190927_a;
                widget.craftable = false;
                widget.field_230694_p_ = false;
                continue;
            }
            Pair<ItemStack, Boolean> stack = this.sortedItems.get(index);
            widget.stack = (ItemStack)stack.getLeft();
            widget.craftable = (Boolean)stack.getRight();
            widget.field_230694_p_ = true;
        }
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        for (Widget widget : this.field_230710_m_) {
            if (!(widget instanceof ItemTerminalWidget)) continue;
            widget.func_230443_a_(matrix, mouseX, mouseY);
        }
        if (this.sortedItems != null) {
            PlayerPrefs prefs = PlayerPrefs.get();
            if (this.orderButton.func_230449_g_()) {
                this.func_238652_a_(matrix, (ITextComponent)new TranslationTextComponent("info.prettypipes.order", new Object[]{I18n.func_135052_a((String)("info.prettypipes.order." + prefs.terminalItemOrder.name().toLowerCase(Locale.ROOT)), (Object[])new Object[0])}), mouseX, mouseY);
            }
            if (this.ascendingButton.func_230449_g_()) {
                this.func_238652_a_(matrix, (ITextComponent)new TranslationTextComponent("info.prettypipes." + (prefs.terminalAscending ? "ascending" : "descending")), mouseX, mouseY);
            }
        }
        if (this.cancelCraftingButton.field_230694_p_ && this.cancelCraftingButton.func_230449_g_()) {
            String[] tooltip = I18n.func_135052_a((String)"info.prettypipes.cancel_all.desc", (Object[])new Object[0]).split("\n");
            this.func_243308_b(matrix, Arrays.stream(tooltip).map(StringTextComponent::new).collect(Collectors.toList()), mouseX, mouseY);
        }
        if (!this.hoveredCrafting.func_190926_b()) {
            this.func_230457_a_(matrix, this.hoveredCrafting, mouseX, mouseY);
        }
        this.func_230459_a_(matrix, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(matrix, this.field_213127_e.func_145748_c_().getString(), (float)(8 + this.getXOffset()), (float)(this.field_147000_g - 96 + 2), 0x404040);
        this.field_230712_o_.func_238421_b_(matrix, this.field_230704_d_.getString(), 8.0f, 6.0f, 0x404040);
        String amount = String.valueOf(this.requestAmount);
        this.field_230712_o_.func_238421_b_(matrix, amount, (float)(191 - this.field_230712_o_.func_78256_a(amount)) / 2.0f - 7.0f + (float)this.getXOffset(), 106.0f, 0x404040);
        if (this.currentlyCrafting != null && !this.currentlyCrafting.isEmpty()) {
            this.field_230712_o_.func_238421_b_(matrix, I18n.func_135052_a((String)"info.prettypipes.crafting", (Object[])new Object[0]), (float)(this.field_146999_f + 4), 10.0f, 0x404040);
            if (this.currentlyCrafting.size() > 6) {
                this.field_230712_o_.func_238421_b_(matrix, ". . .", (float)(this.field_146999_f + 24), 55.0f, 0x404040);
            }
        }
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.getMinecraft().func_110434_K().func_110577_a(this.getTexture());
        this.func_238474_b_(matrix, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.sortedItems != null && this.sortedItems.size() >= 36) {
            float percentage = (float)this.scrollOffset / (float)(this.sortedItems.size() / 9 - 3);
            this.func_238474_b_(matrix, this.field_147003_i + this.getXOffset() + 172, this.field_147009_r + 18 + (int)(percentage * 55.0f), 232, 241, 12, 15);
        } else {
            this.func_238474_b_(matrix, this.field_147003_i + this.getXOffset() + 172, this.field_147009_r + 18, 244, 241, 12, 15);
        }
        this.hoveredCrafting = ItemStack.field_190927_a;
        if (this.currentlyCrafting != null && !this.currentlyCrafting.isEmpty()) {
            this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
            this.func_238474_b_(matrix, this.field_147003_i + this.field_146999_f, this.field_147009_r + 4, 191, 0, 65, 89);
            int x = 0;
            int y = 0;
            for (ItemStack stack : this.currentlyCrafting) {
                int itemX = this.field_147003_i + this.field_146999_f + 4 + x * 18;
                int itemY = this.field_147009_r + 4 + 16 + y * 18;
                this.field_230707_j_.func_180450_b(stack, itemX, itemY);
                this.field_230707_j_.func_180453_a(this.field_230712_o_, stack, itemX, itemY, String.valueOf(stack.func_190916_E()));
                if (mouseX >= itemX && mouseY >= itemY && mouseX < itemX + 16 && mouseY < itemY + 18) {
                    this.hoveredCrafting = stack;
                }
                if (++x < 3) continue;
                x = 0;
                if (++y < 2) continue;
                break;
            }
        }
    }

    protected ResourceLocation getTexture() {
        return TEXTURE;
    }

    public boolean func_231043_a_(double x, double y, double scroll) {
        int offset;
        if (this.sortedItems != null && this.sortedItems.size() >= 36 && (offset = MathHelper.func_76125_a((int)(this.scrollOffset - (int)Math.signum(scroll)), (int)0, (int)(this.sortedItems.size() / 9 - 3))) != this.scrollOffset) {
            this.scrollOffset = offset;
            this.updateWidgets();
        }
        return true;
    }

    public Stream<ItemTerminalWidget> streamWidgets() {
        return this.field_230710_m_.stream().filter(w -> w instanceof ItemTerminalWidget).map(w -> (ItemTerminalWidget)((Object)w));
    }

    public static int requestModifier() {
        if (ItemTerminalGui.func_231172_r_()) {
            return 10;
        }
        if (ItemTerminalGui.func_231173_s_()) {
            return 64;
        }
        return 1;
    }
}

