/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity;

import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.types.EnergyPipeType;
import de.maxhenkel.pipez.blocks.tileentity.types.FluidPipeType;
import de.maxhenkel.pipez.blocks.tileentity.types.ItemPipeType;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.utils.DirectionalLazyOptionalCache;
import de.maxhenkel.pipez.utils.DummyFluidHandler;
import de.maxhenkel.pipez.utils.DummyItemHandler;
import de.maxhenkel.pipez.utils.PipeEnergyStorage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class PipeLogicTileEntity
extends UpgradeTileEntity {
    protected PipeType<?>[] types;
    protected final int[][] rrIndex;
    protected DirectionalLazyOptionalCache<PipeEnergyStorage> energyCache;
    protected DirectionalLazyOptionalCache<DummyFluidHandler> fluidCache;
    protected DirectionalLazyOptionalCache<DummyItemHandler> itemCache;

    public PipeLogicTileEntity(TileEntityType<?> tileEntityTypeIn, PipeType<?>[] types) {
        super(tileEntityTypeIn);
        this.types = types;
        this.rrIndex = new int[Direction.values().length][types.length];
        this.energyCache = new DirectionalLazyOptionalCache();
        this.fluidCache = new DirectionalLazyOptionalCache();
        this.itemCache = new DirectionalLazyOptionalCache();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.field_145846_f) {
            return super.getCapability(cap, side);
        }
        if (cap == CapabilityEnergy.ENERGY && this.hasType(EnergyPipeType.INSTANCE)) {
            if (side != null) {
                return this.energyCache.get(side).cast();
            }
        } else if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.hasType(FluidPipeType.INSTANCE)) {
            if (side != null) {
                return this.fluidCache.get(side).cast();
            }
        } else if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.hasType(ItemPipeType.INSTANCE) && side != null) {
            return this.itemCache.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean hasType(PipeType<?> type) {
        for (PipeType<?> t : this.types) {
            if (t != type) continue;
            return true;
        }
        return false;
    }

    public int getRoundRobinIndex(Direction direction, PipeType<?> pipeType) {
        return this.rrIndex[direction.func_176745_a()][this.getIndex(pipeType)];
    }

    public void setRoundRobinIndex(Direction direction, PipeType<?> pipeType, int value) {
        this.rrIndex[direction.func_176745_a()][this.getIndex(pipeType)] = value;
    }

    public boolean isEnabled(Direction side, PipeType<?> pipeType) {
        UpgradeTileEntity.RedstoneMode redstoneMode = this.getRedstoneMode(side, pipeType);
        return redstoneMode != UpgradeTileEntity.RedstoneMode.ALWAYS_OFF;
    }

    public int getPreferredPipeIndex(Direction side) {
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.isEnabled(side, this.types[i])) continue;
            return i;
        }
        return 0;
    }

    public boolean shouldWork(Direction side, PipeType<?> pipeType) {
        UpgradeTileEntity.RedstoneMode redstoneMode = this.getRedstoneMode(side, pipeType);
        if (redstoneMode.equals(UpgradeTileEntity.RedstoneMode.ALWAYS_OFF)) {
            return false;
        }
        if (redstoneMode.equals(UpgradeTileEntity.RedstoneMode.OFF_WHEN_POWERED)) {
            return !this.isRedstonePowered();
        }
        if (redstoneMode.equals(UpgradeTileEntity.RedstoneMode.ON_WHEN_POWERED)) {
            return this.isRedstonePowered();
        }
        return true;
    }

    public boolean isRedstonePowered() {
        return this.field_145850_b.func_175640_z(this.field_174879_c);
    }

    public PipeType<?>[] getPipeTypes() {
        return this.types;
    }

    public int getIndex(PipeType<?> pipeType) {
        for (int i = 0; i < this.getPipeTypes().length; ++i) {
            PipeType<?> type = this.getPipeTypes()[i];
            if (type != pipeType) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (PipeType<?> pipeType : this.getPipeTypes()) {
            pipeType.tick(this);
        }
        if (this.hasType(EnergyPipeType.INSTANCE)) {
            for (PipeType<?> pipeType : Direction.values()) {
                if (!this.isExtracting((Direction)pipeType)) continue;
                this.energyCache.get((Direction)pipeType).ifPresent(PipeEnergyStorage::tick);
            }
        }
    }

    @Override
    public void setExtracting(Direction side, boolean extracting) {
        super.setExtracting(side, extracting);
        if (this.hasType(EnergyPipeType.INSTANCE)) {
            this.energyCache.revalidate(side, s -> extracting, s -> new PipeEnergyStorage(this, (Direction)s));
        }
        if (this.hasType(FluidPipeType.INSTANCE)) {
            this.fluidCache.revalidate(side, s -> extracting, s -> DummyFluidHandler.INSTANCE);
        }
        if (this.hasType(ItemPipeType.INSTANCE)) {
            this.itemCache.revalidate(side, s -> extracting, s -> DummyItemHandler.INSTANCE);
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (this.hasType(EnergyPipeType.INSTANCE)) {
            this.energyCache.revalidate(this::isExtracting, s -> new PipeEnergyStorage(this, (Direction)s));
        }
        if (this.hasType(FluidPipeType.INSTANCE)) {
            this.fluidCache.revalidate(this::isExtracting, s -> DummyFluidHandler.INSTANCE);
        }
        if (this.hasType(ItemPipeType.INSTANCE)) {
            this.itemCache.revalidate(this::isExtracting, s -> DummyItemHandler.INSTANCE);
        }
    }

    @Override
    public void func_145843_s() {
        this.energyCache.invalidate();
        this.fluidCache.invalidate();
        this.itemCache.invalidate();
        super.func_145843_s();
    }

    @Override
    public boolean canInsert(TileEntity tileEntity, Direction direction) {
        for (PipeType<?> type : this.types) {
            if (!type.canInsert(tileEntity, direction)) continue;
            return true;
        }
        return false;
    }
}

