/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity.types;

import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.ItemFilter;
import de.maxhenkel.pipez.Main;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.ModBlocks;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.corelib.item.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemPipeType
extends PipeType<Item> {
    public static final ItemPipeType INSTANCE = new ItemPipeType();

    @Override
    public String getKey() {
        return "Item";
    }

    @Override
    public boolean canInsert(TileEntity tileEntity, Direction direction) {
        return tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).isPresent();
    }

    @Override
    public Filter<Item> createFilter() {
        return new ItemFilter();
    }

    @Override
    public UpgradeTileEntity.Distribution getDefaultDistribution() {
        return UpgradeTileEntity.Distribution.NEAREST;
    }

    @Override
    public String getTranslationKey() {
        return "tooltip.pipez.item";
    }

    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)ModBlocks.ITEM_PIPE);
    }

    @Override
    public ITextComponent getTransferText(@Nullable Upgrade upgrade) {
        return new TranslationTextComponent("tooltip.pipez.rate.item", new Object[]{this.getRate(upgrade), this.getSpeed(upgrade)});
    }

    @Override
    public void tick(PipeLogicTileEntity tileEntity) {
        for (Direction side : Direction.values()) {
            IItemHandler itemHandler;
            if (tileEntity.func_145831_w().func_82737_E() % (long)this.getSpeed(tileEntity, side) != 0L || !tileEntity.isExtracting(side) || !tileEntity.shouldWork(side, this) || (itemHandler = this.getItemHandler(tileEntity, tileEntity.func_174877_v().func_177972_a(side), side.func_176734_d())) == null) continue;
            List<PipeTileEntity.Connection> connections = tileEntity.getSortedConnections(side, this);
            if (tileEntity.getDistribution(side, this).equals(UpgradeTileEntity.Distribution.ROUND_ROBIN)) {
                this.insertEqually(tileEntity, side, connections, itemHandler);
                continue;
            }
            this.insertOrdered(tileEntity, side, connections, itemHandler);
        }
    }

    protected void insertEqually(PipeLogicTileEntity tileEntity, Direction side, List<PipeTileEntity.Connection> connections, IItemHandler itemHandler) {
        if (connections.isEmpty()) {
            return;
        }
        int itemsToTransfer = this.getRate(tileEntity, side);
        boolean[] inventoriesFull = new boolean[connections.size()];
        int p = tileEntity.getRoundRobinIndex(side, this) % connections.size();
        while (itemsToTransfer > 0 && this.hasNotInserted(inventoriesFull)) {
            PipeTileEntity.Connection connection = connections.get(p);
            IItemHandler destination = this.getItemHandler(tileEntity, connection.getPos(), connection.getDirection());
            boolean hasInserted = false;
            if (destination != null && !inventoriesFull[p] && !this.isFull(destination)) {
                for (int j = 0; j < itemHandler.getSlots(); ++j) {
                    ItemStack simulatedExtract = itemHandler.extractItem(j, 1, true);
                    if (simulatedExtract.func_190926_b() || this.canInsert(connection, simulatedExtract, tileEntity.getFilters(side, this)) == tileEntity.getFilterMode(side, this).equals(UpgradeTileEntity.FilterMode.BLACKLIST)) continue;
                    ItemStack stack = ItemHandlerHelper.insertItem((IItemHandler)destination, (ItemStack)simulatedExtract, (boolean)false);
                    int insertedAmount = simulatedExtract.func_190916_E() - stack.func_190916_E();
                    if (insertedAmount <= 0) continue;
                    itemsToTransfer -= insertedAmount;
                    itemHandler.extractItem(j, insertedAmount, false);
                    hasInserted = true;
                    break;
                }
            }
            if (!hasInserted) {
                inventoriesFull[p] = true;
            }
            p = (p + 1) % connections.size();
        }
        tileEntity.setRoundRobinIndex(side, this, p);
    }

    protected void insertOrdered(PipeLogicTileEntity tileEntity, Direction side, List<PipeTileEntity.Connection> connections, IItemHandler itemHandler) {
        int itemsToTransfer = this.getRate(tileEntity, side);
        ArrayList<ItemStack> nonFittingItems = new ArrayList<ItemStack>();
        block0: for (PipeTileEntity.Connection connection : connections) {
            nonFittingItems.clear();
            IItemHandler destination = this.getItemHandler(tileEntity, connection.getPos(), connection.getDirection());
            if (destination == null || this.isFull(destination)) continue;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                if (itemsToTransfer <= 0) break block0;
                ItemStack simulatedExtract = itemHandler.extractItem(i, itemsToTransfer, true);
                if (simulatedExtract.func_190926_b() || nonFittingItems.stream().anyMatch(stack -> ItemUtils.isStackable(stack, simulatedExtract)) || this.canInsert(connection, simulatedExtract, tileEntity.getFilters(side, this)) == tileEntity.getFilterMode(side, this).equals(UpgradeTileEntity.FilterMode.BLACKLIST)) continue;
                ItemStack stack2 = ItemHandlerHelper.insertItem((IItemHandler)destination, (ItemStack)simulatedExtract, (boolean)false);
                int insertedAmount = simulatedExtract.func_190916_E() - stack2.func_190916_E();
                if (insertedAmount <= 0) {
                    nonFittingItems.add(simulatedExtract);
                }
                itemsToTransfer -= insertedAmount;
                itemHandler.extractItem(i, insertedAmount, false);
            }
        }
    }

    private boolean isFull(IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(i);
            if (stackInSlot.func_190916_E() >= itemHandler.getSlotLimit(i)) continue;
            return false;
        }
        return true;
    }

    private boolean canInsert(PipeTileEntity.Connection connection, ItemStack stack, List<Filter<?>> filters) {
        for (Filter filter2 : filters.stream().map(filter -> filter).filter(Filter::isInvert).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList())) {
            if (!this.matches(filter2, stack)) continue;
            return false;
        }
        List collect = filters.stream().map(filter -> filter).filter(f -> !f.isInvert()).filter(f -> this.matchesConnection(connection, f)).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return true;
        }
        for (Filter filter3 : collect) {
            if (!this.matches(filter3, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(Filter<Item> filter, ItemStack stack) {
        CompoundNBT metadata = filter.getMetadata();
        if (metadata == null) {
            return filter.getTag() == null || stack.func_77973_b().func_206844_a(filter.getTag());
        }
        if (filter.isExactMetadata()) {
            if (this.deepExactCompare((INBT)metadata, (INBT)stack.func_77978_p())) {
                return filter.getTag() == null || stack.func_77973_b().func_206844_a(filter.getTag());
            }
            return false;
        }
        CompoundNBT stackNBT = stack.func_77978_p();
        if (stackNBT == null) {
            return metadata.func_186856_d() <= 0;
        }
        if (!this.deepFuzzyCompare((INBT)metadata, (INBT)stackNBT)) {
            return false;
        }
        return filter.getTag() == null || stack.func_77973_b().func_206844_a(filter.getTag());
    }

    private boolean hasNotInserted(boolean[] inventoriesFull) {
        for (boolean b : inventoriesFull) {
            if (b) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private IItemHandler getItemHandler(PipeLogicTileEntity tileEntity, BlockPos pos, Direction direction) {
        TileEntity te = tileEntity.func_145831_w().func_175625_s(pos);
        if (te == null) {
            return null;
        }
        return (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).orElse(null);
    }

    public int getSpeed(PipeLogicTileEntity tileEntity, Direction direction) {
        return this.getSpeed(tileEntity.getUpgrade(direction));
    }

    public int getSpeed(@Nullable Upgrade upgrade) {
        if (upgrade == null) {
            return (Integer)Main.SERVER_CONFIG.itemPipeSpeed.get();
        }
        switch (upgrade) {
            case BASIC: {
                return (Integer)Main.SERVER_CONFIG.itemPipeSpeedBasic.get();
            }
            case IMPROVED: {
                return (Integer)Main.SERVER_CONFIG.itemPipeSpeedImproved.get();
            }
            case ADVANCED: {
                return (Integer)Main.SERVER_CONFIG.itemPipeSpeedAdvanced.get();
            }
            case ULTIMATE: {
                return (Integer)Main.SERVER_CONFIG.itemPipeSpeedUltimate.get();
            }
        }
        return 1;
    }

    @Override
    public int getRate(@Nullable Upgrade upgrade) {
        if (upgrade == null) {
            return (Integer)Main.SERVER_CONFIG.itemPipeAmount.get();
        }
        switch (upgrade) {
            case BASIC: {
                return (Integer)Main.SERVER_CONFIG.itemPipeAmountBasic.get();
            }
            case IMPROVED: {
                return (Integer)Main.SERVER_CONFIG.itemPipeAmountImproved.get();
            }
            case ADVANCED: {
                return (Integer)Main.SERVER_CONFIG.itemPipeAmountAdvanced.get();
            }
            case ULTIMATE: {
                return (Integer)Main.SERVER_CONFIG.itemPipeAmountUltimate.get();
            }
        }
        return Integer.MAX_VALUE;
    }
}

