/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks.tileentity.types;

import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;

public abstract class PipeType<T> {
    public abstract String getKey();

    public abstract void tick(PipeLogicTileEntity var1);

    public abstract int getRate(@Nullable Upgrade var1);

    public abstract boolean canInsert(TileEntity var1, Direction var2);

    public abstract Filter<T> createFilter();

    public abstract String getTranslationKey();

    public abstract ItemStack getIcon();

    public abstract ITextComponent getTransferText(@Nullable Upgrade var1);

    public boolean hasFilter() {
        return true;
    }

    public UpgradeTileEntity.Distribution getDefaultDistribution() {
        return UpgradeTileEntity.Distribution.ROUND_ROBIN;
    }

    public UpgradeTileEntity.RedstoneMode getDefaultRedstoneMode() {
        return UpgradeTileEntity.RedstoneMode.IGNORED;
    }

    public UpgradeTileEntity.FilterMode getDefaultFilterMode() {
        return UpgradeTileEntity.FilterMode.WHITELIST;
    }

    public int getRate(PipeLogicTileEntity tileEntity, Direction direction) {
        return this.getRate(tileEntity.getUpgrade(direction));
    }

    public boolean matchesConnection(PipeTileEntity.Connection connection, Filter<T> filter) {
        if (filter.getDestination() == null) {
            return true;
        }
        return filter.getDestination().equals(new DirectionalPosition(connection.getPos(), connection.getDirection()));
    }

    public boolean deepExactCompare(INBT meta, INBT item) {
        if (meta instanceof CompoundNBT) {
            if (!(item instanceof CompoundNBT)) {
                return false;
            }
            CompoundNBT c = (CompoundNBT)meta;
            CompoundNBT i = (CompoundNBT)item;
            HashSet allKeys = new HashSet();
            allKeys.addAll(c.func_150296_c());
            allKeys.addAll(i.func_150296_c());
            for (String key : allKeys) {
                if (c.func_74764_b(key)) {
                    if (i.func_74764_b(key)) {
                        INBT nbt = c.func_74781_a(key);
                        if (this.deepExactCompare(nbt, i.func_74781_a(key))) continue;
                        return false;
                    }
                    return false;
                }
                return false;
            }
            return true;
        }
        if (meta instanceof ListNBT) {
            ListNBT l = (ListNBT)meta;
            if (!(item instanceof ListNBT)) {
                return false;
            }
            ListNBT il = (ListNBT)item;
            if (!l.stream().allMatch(inbt -> il.stream().anyMatch(inbt1 -> this.deepExactCompare((INBT)inbt, (INBT)inbt1)))) {
                return false;
            }
            return il.stream().allMatch(inbt -> l.stream().anyMatch(inbt1 -> this.deepExactCompare((INBT)inbt, (INBT)inbt1)));
        }
        return meta != null && meta.equals(item);
    }

    public boolean deepFuzzyCompare(INBT meta, INBT item) {
        if (meta instanceof CompoundNBT) {
            if (!(item instanceof CompoundNBT)) {
                return false;
            }
            CompoundNBT c = (CompoundNBT)meta;
            CompoundNBT i = (CompoundNBT)item;
            for (String key : c.func_150296_c()) {
                INBT nbt;
                if (i.func_150297_b(key, (int)(nbt = c.func_74781_a(key)).func_74732_a())) {
                    if (this.deepFuzzyCompare(nbt, i.func_74781_a(key))) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        if (meta instanceof ListNBT) {
            ListNBT l = (ListNBT)meta;
            if (!(item instanceof ListNBT)) {
                return false;
            }
            ListNBT il = (ListNBT)item;
            return l.stream().allMatch(inbt -> il.stream().anyMatch(inbt1 -> this.deepFuzzyCompare((INBT)inbt, (INBT)inbt1)));
        }
        return meta != null && meta.equals(item);
    }

    public static int getConnectionsNotFullCount(boolean[] connections) {
        int count = 0;
        for (boolean connection : connections) {
            if (connection) continue;
            ++count;
        }
        return count;
    }
}

