/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.FluidFilter;
import de.maxhenkel.pipez.GasFilter;
import de.maxhenkel.pipez.ItemFilter;
import de.maxhenkel.pipez.Main;
import de.maxhenkel.pipez.Upgrade;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import de.maxhenkel.pipez.corelib.inventory.ScreenBase;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.gui.CycleIconButton;
import de.maxhenkel.pipez.gui.ExtractContainer;
import de.maxhenkel.pipez.gui.FilterList;
import de.maxhenkel.pipez.gui.UpgradeSlot;
import de.maxhenkel.pipez.net.CycleDistributionMessage;
import de.maxhenkel.pipez.net.CycleFilterModeMessage;
import de.maxhenkel.pipez.net.CycleRedstoneModeMessage;
import de.maxhenkel.pipez.net.EditFilterMessage;
import de.maxhenkel.pipez.net.RemoveFilterMessage;
import de.maxhenkel.pipez.net.UpdateFilterMessage;
import de.maxhenkel.pipez.utils.GasUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import mekanism.api.chemical.gas.GasStack;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidUtil;

public class ExtractScreen
extends ScreenBase<ExtractContainer> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("pipez", "textures/gui/container/extract.png");
    private CycleIconButton redstoneButton;
    private CycleIconButton sortButton;
    private CycleIconButton filterButton;
    private Button addFilterButton;
    private Button editFilterButton;
    private Button removeFilterButton;
    private ScreenBase.HoverArea redstoneArea;
    private ScreenBase.HoverArea sortArea;
    private ScreenBase.HoverArea filterArea;
    private ScreenBase.HoverArea[] tabs;
    private PipeType<?>[] pipeTypes;
    private int currentindex;
    private FilterList filterList;

    public ExtractScreen(ExtractContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(BACKGROUND, container, playerInventory, title);
        this.field_146999_f = 176;
        this.field_147000_g = 196;
        this.pipeTypes = container.getPipe().getPipeTypes();
        if (this.pipeTypes.length > 1) {
            this.tabs = new ScreenBase.HoverArea[this.pipeTypes.length];
        }
        this.currentindex = container.getIndex();
        if (this.currentindex < 0) {
            this.currentindex = ((ExtractContainer)this.func_212873_a_()).getPipe().getPreferredPipeIndex(((ExtractContainer)this.func_212873_a_()).getSide());
        }
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.hoverAreas.clear();
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        PipeLogicTileEntity pipe = ((ExtractContainer)this.func_212873_a_()).getPipe();
        Direction side = ((ExtractContainer)this.func_212873_a_()).getSide();
        this.filterList = new FilterList(this, 32, 8, 136, 66, () -> pipe.getFilters(side, this.pipeTypes[this.currentindex]));
        Supplier<Integer> redstoneModeIndex = () -> pipe.getRedstoneMode(((ExtractContainer)this.func_212873_a_()).getSide(), this.pipeTypes[this.currentindex]).ordinal();
        List<CycleIconButton.Icon> redstoneModeIcons = Arrays.asList(new CycleIconButton.Icon(BACKGROUND, 176, 16), new CycleIconButton.Icon(BACKGROUND, 192, 16), new CycleIconButton.Icon(BACKGROUND, 208, 16), new CycleIconButton.Icon(BACKGROUND, 224, 16));
        this.redstoneButton = new CycleIconButton(this.field_147003_i + 7, this.field_147009_r + 7, redstoneModeIcons, redstoneModeIndex, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new CycleRedstoneModeMessage(this.currentindex)));
        Supplier<Integer> distributionIndex = () -> pipe.getDistribution(((ExtractContainer)this.func_212873_a_()).getSide(), this.pipeTypes[this.currentindex]).ordinal();
        List<CycleIconButton.Icon> distributionIcons = Arrays.asList(new CycleIconButton.Icon(BACKGROUND, 176, 0), new CycleIconButton.Icon(BACKGROUND, 192, 0), new CycleIconButton.Icon(BACKGROUND, 208, 0), new CycleIconButton.Icon(BACKGROUND, 224, 0));
        this.sortButton = new CycleIconButton(this.field_147003_i + 7, this.field_147009_r + 31, distributionIcons, distributionIndex, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new CycleDistributionMessage(this.currentindex)));
        Supplier<Integer> filterModeIndex = () -> this.pipeTypes[this.currentindex].hasFilter() ? pipe.getFilterMode(((ExtractContainer)this.func_212873_a_()).getSide(), this.pipeTypes[this.currentindex]).ordinal() : 0;
        List<CycleIconButton.Icon> filterModeIcons = Arrays.asList(new CycleIconButton.Icon(BACKGROUND, 176, 32), new CycleIconButton.Icon(BACKGROUND, 192, 32));
        this.filterButton = new CycleIconButton(this.field_147003_i + 7, this.field_147009_r + 55, filterModeIcons, filterModeIndex, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new CycleFilterModeMessage(this.currentindex)));
        this.addFilterButton = new Button(this.field_147003_i + 31, this.field_147009_r + 79, 40, 20, (ITextComponent)new TranslationTextComponent("message.pipez.filter.add"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new EditFilterMessage(this.pipeTypes[this.currentindex].createFilter(), this.currentindex)));
        this.editFilterButton = new Button(this.field_147003_i + 80, this.field_147009_r + 79, 40, 20, (ITextComponent)new TranslationTextComponent("message.pipez.filter.edit"), button -> {
            if (this.filterList.getSelected() >= 0) {
                Main.SIMPLE_CHANNEL.sendToServer((Object)new EditFilterMessage(pipe.getFilters(side, this.pipeTypes[this.currentindex]).get(this.filterList.getSelected()), this.currentindex));
            }
        });
        this.removeFilterButton = new Button(this.field_147003_i + 129, this.field_147009_r + 79, 40, 20, (ITextComponent)new TranslationTextComponent("message.pipez.filter.remove"), button -> {
            if (this.filterList.getSelected() >= 0) {
                Main.SIMPLE_CHANNEL.sendToServer((Object)new RemoveFilterMessage(pipe.getFilters(side, this.pipeTypes[this.currentindex]).get(this.filterList.getSelected()).getId(), this.currentindex));
            }
        });
        this.func_230480_a_(this.redstoneButton);
        this.func_230480_a_(this.sortButton);
        this.func_230480_a_(this.filterButton);
        this.func_230480_a_(this.addFilterButton);
        this.func_230480_a_(this.editFilterButton);
        this.func_230480_a_(this.removeFilterButton);
        if (this.hasTabs()) {
            for (int i = 0; i < this.pipeTypes.length; ++i) {
                int tabIndex = i;
                this.tabs[i] = new ScreenBase.HoverArea(-23, 5 + 25 * i, 24, 24, () -> {
                    ArrayList<IReorderingProcessor> tooltip = new ArrayList<IReorderingProcessor>();
                    tooltip.add(new TranslationTextComponent(this.pipeTypes[tabIndex].getTranslationKey()).func_241878_f());
                    return tooltip;
                });
                this.hoverAreas.add(this.tabs[i]);
            }
        }
        this.redstoneArea = new ScreenBase.HoverArea(7, 7, 20, 20, () -> {
            if (this.redstoneButton.field_230693_o_) {
                return Arrays.asList(new TranslationTextComponent("tooltip.pipez.redstone_mode", new Object[]{new TranslationTextComponent("tooltip.pipez.redstone_mode." + pipe.getRedstoneMode(side, this.pipeTypes[this.currentindex]).getName())}).func_241878_f());
            }
            return Collections.emptyList();
        });
        this.sortArea = new ScreenBase.HoverArea(7, 31, 20, 20, () -> {
            if (this.sortButton.field_230693_o_) {
                return Arrays.asList(new TranslationTextComponent("tooltip.pipez.distribution", new Object[]{new TranslationTextComponent("tooltip.pipez.distribution." + pipe.getDistribution(side, this.pipeTypes[this.currentindex]).getName())}).func_241878_f());
            }
            return Collections.emptyList();
        });
        this.filterArea = new ScreenBase.HoverArea(7, 55, 20, 20, () -> {
            if (this.filterButton.field_230693_o_) {
                return Arrays.asList(new TranslationTextComponent("tooltip.pipez.filter_mode", new Object[]{new TranslationTextComponent("tooltip.pipez.filter_mode." + pipe.getFilterMode(side, this.pipeTypes[this.currentindex]).getName())}).func_241878_f());
            }
            return Collections.emptyList();
        });
        this.hoverAreas.add(this.redstoneArea);
        this.hoverAreas.add(this.sortArea);
        this.hoverAreas.add(this.filterArea);
        this.checkButtons();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.checkButtons();
        this.filterList.tick();
    }

    private void checkButtons() {
        Upgrade upgrade = ((ExtractContainer)this.func_212873_a_()).getPipe().getUpgrade(((ExtractContainer)this.func_212873_a_()).getSide());
        if (upgrade == null) {
            this.redstoneButton.field_230693_o_ = false;
            this.sortButton.field_230693_o_ = false;
            this.filterButton.field_230693_o_ = false;
            this.addFilterButton.field_230693_o_ = false;
            this.editFilterButton.field_230693_o_ = false;
            this.removeFilterButton.field_230693_o_ = false;
        } else if (upgrade.equals((Object)Upgrade.BASIC)) {
            this.redstoneButton.field_230693_o_ = true;
            this.sortButton.field_230693_o_ = false;
            this.filterButton.field_230693_o_ = false;
            this.addFilterButton.field_230693_o_ = false;
            this.editFilterButton.field_230693_o_ = false;
            this.removeFilterButton.field_230693_o_ = false;
        } else if (upgrade.equals((Object)Upgrade.IMPROVED)) {
            this.redstoneButton.field_230693_o_ = true;
            this.sortButton.field_230693_o_ = true;
            this.filterButton.field_230693_o_ = false;
            this.addFilterButton.field_230693_o_ = false;
            this.editFilterButton.field_230693_o_ = false;
            this.removeFilterButton.field_230693_o_ = false;
        } else {
            this.redstoneButton.field_230693_o_ = true;
            this.sortButton.field_230693_o_ = true;
            this.filterButton.field_230693_o_ = this.pipeTypes[this.currentindex].hasFilter();
            this.addFilterButton.field_230693_o_ = this.pipeTypes[this.currentindex].hasFilter();
            this.editFilterButton.field_230693_o_ = this.filterList.getSelected() >= 0;
            this.removeFilterButton.field_230693_o_ = this.filterList.getSelected() >= 0;
        }
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.field_230712_o_.func_243248_b(matrixStack, this.field_213127_e.func_145748_c_(), 8.0f, (float)(this.field_147000_g - 96 + 3), 0x404040);
        this.filterList.drawGuiContainerForegroundLayer(matrixStack, mouseX, mouseY);
        this.drawHoverAreas(matrixStack, mouseX, mouseY);
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        this.filterList.drawGuiContainerBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
        if (this.hasTabs()) {
            int i;
            for (i = 0; i < this.pipeTypes.length; ++i) {
                if (i == this.currentindex) {
                    this.func_238474_b_(matrixStack, this.field_147003_i - 26 + 3, this.field_147009_r + 5 + 25 * i, 176, 48, 26, 24);
                    continue;
                }
                this.func_238474_b_(matrixStack, this.field_147003_i - 26 + 3, this.field_147009_r + 5 + 25 * i, 176, 72, 26, 24);
            }
            for (i = 0; i < this.pipeTypes.length; ++i) {
                if (i == this.currentindex) {
                    this.field_230707_j_.func_184391_a((LivingEntity)this.field_230706_i_.field_71439_g, this.pipeTypes[i].getIcon(), this.field_147003_i - 26 + 3 + 4, this.field_147009_r + 5 + 25 * i + 4);
                    continue;
                }
                this.field_230707_j_.func_184391_a((LivingEntity)this.field_230706_i_.field_71439_g, this.pipeTypes[i].getIcon(), this.field_147003_i - 26 + 3 + 4 + 2, this.field_147009_r + 5 + 25 * i + 4);
            }
        }
    }

    public int getTabsX() {
        return this.field_147003_i - this.getTabsWidth();
    }

    public int getTabsY() {
        return this.field_147009_r + 5;
    }

    public int getTabsHeight() {
        if (this.hasTabs()) {
            return 25 * this.tabs.length;
        }
        return 0;
    }

    public int getTabsWidth() {
        return 23;
    }

    public boolean hasTabs() {
        return this.tabs != null;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        Slot sl;
        if (this.filterList.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hasTabs()) {
            for (int i = 0; i < this.tabs.length; ++i) {
                ScreenBase.HoverArea hoverArea = this.tabs[i];
                if (this.currentindex == i || !hoverArea.isHovered(this.field_147003_i, this.field_147009_r, (int)mouseX, (int)mouseY)) continue;
                this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.currentindex = i;
                this.func_231160_c_();
                return true;
            }
        }
        if (ExtractScreen.func_231173_s_() && (sl = this.getSlotUnderMouse()) != null && !(sl instanceof UpgradeSlot)) {
            this.addQuickFilter(sl.func_75211_c());
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public void addQuickFilter(ItemStack stack) {
        GasStack gas;
        if (stack == null || stack.func_190926_b()) {
            return;
        }
        if (!this.filterButton.field_230693_o_) {
            return;
        }
        Filter<?> filter = this.pipeTypes[this.currentindex].createFilter();
        filter.setExactMetadata(true);
        if (filter instanceof ItemFilter) {
            filter.setTag(new SingleElementTag<Item>(stack.func_77973_b()));
            if (stack.func_77942_o()) {
                filter.setMetadata(stack.func_77978_p().func_74737_b());
            } else {
                filter.setMetadata(null);
            }
            Main.SIMPLE_CHANNEL.sendToServer((Object)new UpdateFilterMessage(filter, this.currentindex));
        } else if (filter instanceof FluidFilter) {
            FluidUtil.getFluidContained((ItemStack)stack).ifPresent(s -> {
                filter.setTag(new SingleElementTag<Fluid>(s.getFluid()));
                if (s.hasTag()) {
                    filter.setMetadata(s.getTag().func_74737_b());
                } else {
                    filter.setMetadata(null);
                }
                Main.SIMPLE_CHANNEL.sendToServer((Object)new UpdateFilterMessage(filter, this.currentindex));
            });
        } else if (filter instanceof GasFilter && (gas = GasUtils.getGasContained(stack)) != null) {
            filter.setTag(new SingleElementTag(gas.getType()));
            filter.setMetadata(null);
            Main.SIMPLE_CHANNEL.sendToServer((Object)new UpdateFilterMessage(filter, this.currentindex));
        }
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.filterList.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        return this.filterList.mouseScrolled(mouseX, mouseY, delta);
    }

    public <T extends Widget> T func_230480_a_(T button) {
        return (T)super.func_230480_a_(button);
    }

    public void addHoverArea(ScreenBase.HoverArea hoverArea) {
        this.hoverAreas.add(hoverArea);
    }
}

