/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.corelib.CachedMap;
import de.maxhenkel.pipez.corelib.helpers.AbstractStack;
import de.maxhenkel.pipez.corelib.helpers.Pair;
import de.maxhenkel.pipez.corelib.helpers.WrappedFluidStack;
import de.maxhenkel.pipez.corelib.helpers.WrappedItemStack;
import de.maxhenkel.pipez.corelib.inventory.ScreenBase;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.gui.ExtractScreen;
import de.maxhenkel.pipez.gui.WidgetBase;
import de.maxhenkel.pipez.utils.WrappedGasStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fluids.FluidStack;

public class FilterList
extends WidgetBase {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("pipez", "textures/gui/container/extract.png");
    protected Supplier<List<Filter<?>>> filters;
    protected int offset;
    protected int selected;
    private ScreenBase.HoverArea[] hoverAreas;
    private ScreenBase.HoverArea[] itemHoverAreas;
    private ScreenBase.HoverArea[] blockHoverAreas;
    private int columnHeight;
    private int columnCount;
    private CachedMap<DirectionalPosition, Pair<BlockState, ItemStack>> filterPosCache;

    public FilterList(ExtractScreen screen, int posX, int posY, int xSize, int ySize, Supplier<List<Filter<?>>> filters) {
        super(screen, posX, posY, xSize, ySize);
        this.filters = filters;
        this.columnHeight = 22;
        this.columnCount = 3;
        this.selected = -1;
        this.hoverAreas = new ScreenBase.HoverArea[this.columnCount];
        this.itemHoverAreas = new ScreenBase.HoverArea[this.columnCount];
        this.blockHoverAreas = new ScreenBase.HoverArea[this.columnCount];
        for (int i = 0; i < this.hoverAreas.length; ++i) {
            this.hoverAreas[i] = new ScreenBase.HoverArea(0, i * this.columnHeight, xSize, this.columnHeight);
            this.itemHoverAreas[i] = new ScreenBase.HoverArea(3, 3 + i * this.columnHeight, 16, 16);
            this.blockHoverAreas[i] = new ScreenBase.HoverArea(xSize - 3 - 16 - 11, 3 + i * this.columnHeight, 16, 16);
        }
        this.filterPosCache = new CachedMap(1000L);
    }

    @Override
    protected void drawGuiContainerForegroundLayer(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(matrixStack, mouseX, mouseY);
        List<Filter<?>> f = this.filters.get();
        for (int i = 0; i < this.hoverAreas.length && this.getOffset() + i < f.size(); ++i) {
            Filter<?> filter = f.get(this.getOffset() + i);
            if (this.itemHoverAreas[i].isHovered(this.guiLeft, this.guiTop, mouseX, mouseY)) {
                AbstractStack<?> stack = FilterList.getStack(filter);
                if (stack == null || stack.isEmpty()) continue;
                List<ITextComponent> tooltip = stack.getTooltip((Screen)this.screen);
                if (filter.isInvert()) {
                    tooltip.set(0, (ITextComponent)new TranslationTextComponent("tooltip.pipez.filter.not").func_240699_a_(TextFormatting.DARK_RED).func_240702_b_(" ").func_230529_a_(tooltip.get(0)));
                }
                if (filter.getTag() != null && !(filter.getTag() instanceof SingleElementTag)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.pipez.filter.accepts_tag", new Object[]{new StringTextComponent(filter.getTag().func_230234_a_().toString()).func_240699_a_(TextFormatting.BLUE)}).func_240699_a_(TextFormatting.GRAY));
                }
                this.screen.renderToolTip(matrixStack, tooltip.stream().map(ITextComponent::func_241878_f).collect(Collectors.toList()), mouseX - this.screen.getGuiLeft(), mouseY - this.screen.getGuiTop(), this.mc.field_71466_p);
                continue;
            }
            if (!this.blockHoverAreas[i].isHovered(this.guiLeft, this.guiTop, mouseX, mouseY) || filter.getDestination() == null) continue;
            ArrayList<Object> tooltip = new ArrayList<Object>();
            Pair<BlockState, ItemStack> destPair = this.getBlockAt(filter.getDestination());
            if (destPair.getKey() == null) {
                tooltip.add(TextComponentUtils.func_240647_a_((ITextComponent)new TranslationTextComponent("tooltip.pipez.filter.unknown_block")).func_240699_a_(TextFormatting.DARK_RED));
            } else {
                tooltip.add(destPair.getKey().func_177230_c().func_235333_g_().func_240699_a_(TextFormatting.BLUE));
            }
            BlockPos pos = filter.getDestination().getPos();
            tooltip.add(new TranslationTextComponent("tooltip.pipez.filter.destination_location", new Object[]{this.number(pos.func_177958_n()), this.number(pos.func_177956_o()), this.number(pos.func_177952_p())}));
            tooltip.add(new TranslationTextComponent("tooltip.pipez.filter.destination_distance", new Object[]{this.number(pos.func_218139_n((Vector3i)this.getContainer().getPipe().func_174877_v()))}));
            tooltip.add(new TranslationTextComponent("tooltip.pipez.filter.destination_side", new Object[]{new TranslationTextComponent("message.pipez.direction." + filter.getDestination().getDirection().func_176742_j()).func_240699_a_(TextFormatting.DARK_GREEN)}));
            this.screen.renderToolTip(matrixStack, tooltip.stream().map(ITextComponent::func_241878_f).collect(Collectors.toList()), mouseX - this.screen.getGuiLeft(), mouseY - this.screen.getGuiTop(), this.mc.field_71466_p);
        }
    }

    private IFormattableTextComponent number(int num) {
        return new StringTextComponent(String.valueOf(num)).func_240699_a_(TextFormatting.DARK_GREEN);
    }

    @Nullable
    public static AbstractStack<?> getStack(Filter<?> filter) {
        Object o = null;
        if (filter.getTag() != null) {
            o = FilterList.get(filter.getTag());
        }
        if (o instanceof Item) {
            ItemStack stack = new ItemStack((IItemProvider)((Item)o));
            if (filter.getMetadata() != null) {
                stack.func_77982_d(filter.getMetadata().func_74737_b());
            }
            return new WrappedItemStack(stack);
        }
        if (o instanceof Fluid) {
            FluidStack stack = new FluidStack((Fluid)o, 1000);
            if (filter.getMetadata() != null) {
                stack.setTag(filter.getMetadata().func_74737_b());
            }
            return new WrappedFluidStack(stack);
        }
        if (o instanceof Gas) {
            GasStack stack = new GasStack(o, 1000L);
            return new WrappedGasStack(stack);
        }
        return null;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
        List<Filter<?>> f = this.filters.get();
        for (int i = this.getOffset(); i < f.size() && i < this.getOffset() + this.columnCount; ++i) {
            this.mc.func_110434_K().func_110577_a(BACKGROUND);
            int pos = i - this.getOffset();
            int startY = this.guiTop + pos * this.columnHeight;
            Filter<?> filter = f.get(i);
            if (i == this.getSelected()) {
                AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)this.guiLeft, (int)startY, (float)0.0f, (float)218.0f, (int)125, (int)this.columnHeight, (int)256, (int)256);
            } else {
                AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)this.guiLeft, (int)startY, (float)0.0f, (float)196.0f, (int)125, (int)this.columnHeight, (int)256, (int)256);
            }
            AbstractStack<?> stack = FilterList.getStack(filter);
            if (stack != null && !stack.isEmpty()) {
                stack.render(matrixStack, this.guiLeft + 3, startY + 3);
                if (filter.getTag() != null) {
                    if (filter.getTag() instanceof SingleElementTag) {
                        this.drawStringSmall(matrixStack, this.guiLeft + 22, startY + 5, (ITextComponent)new TranslationTextComponent("message.pipez.filter.item", new Object[]{new TranslationTextComponent(stack.getDisplayName().getString()).func_240699_a_(TextFormatting.BLUE)}).func_240699_a_(TextFormatting.WHITE));
                    } else {
                        this.drawStringSmall(matrixStack, this.guiLeft + 22, startY + 5, (ITextComponent)new TranslationTextComponent("message.pipez.filter.tag", new Object[]{new StringTextComponent(filter.getTag().func_230234_a_().toString()).func_240699_a_(TextFormatting.BLUE)}).func_240699_a_(TextFormatting.WHITE));
                    }
                }
            } else {
                this.drawStringSmall(matrixStack, this.guiLeft + 22, startY + 5, (ITextComponent)new TranslationTextComponent("message.pipez.filter.any_item").func_240699_a_(TextFormatting.WHITE));
            }
            if (filter.getMetadata() != null && filter.getMetadata().func_186856_d() > 0) {
                IFormattableTextComponent tags = new TranslationTextComponent("message.pipez.filter.nbt.tag" + (filter.getMetadata().func_186856_d() != 1 ? "s" : ""), new Object[]{filter.getMetadata().func_186856_d()}).func_240699_a_(TextFormatting.DARK_PURPLE);
                IFormattableTextComponent nbtStr = new TranslationTextComponent("message.pipez.filter.nbt", new Object[]{tags}).func_240699_a_(TextFormatting.WHITE);
                if (filter.isExactMetadata()) {
                    nbtStr.func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("message.pipez.filter.nbt.exact"));
                }
                this.drawStringSmall(matrixStack, this.guiLeft + 22, startY + 10, (ITextComponent)nbtStr);
            }
            if (filter.isInvert()) {
                this.drawStringSmall(matrixStack, this.guiLeft + 22, startY + 15, (ITextComponent)new TranslationTextComponent("message.pipez.filter.inverted").func_240699_a_(TextFormatting.DARK_RED));
            }
            if (filter.getDestination() == null) continue;
            Pair<BlockState, ItemStack> dstPair = this.getBlockAt(filter.getDestination());
            this.mc.func_175599_af().func_184391_a((LivingEntity)this.mc.field_71439_g, dstPair.getValue(), this.guiLeft + this.xSize - 3 - 16 - 11, startY + 3);
            this.mc.func_175599_af().func_180453_a(this.mc.field_71466_p, dstPair.getValue(), this.guiLeft + this.xSize - 3 - 16 - 11, startY + 3, String.valueOf(filter.getDestination().getDirection().name().charAt(0)));
        }
        this.mc.func_110434_K().func_110577_a(BACKGROUND);
        if (f.size() > this.columnCount) {
            float h = 49.0f;
            float perc = (float)this.getOffset() / (float)(f.size() - this.columnCount);
            int posY = this.guiTop + (int)(h * perc);
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(this.guiLeft + this.xSize - 10), (int)posY, (float)125.0f, (float)196.0f, (int)10, (int)17, (int)256, (int)256);
        } else {
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(this.guiLeft + this.xSize - 10), (int)this.guiTop, (float)135.0f, (float)196.0f, (int)10, (int)17, (int)256, (int)256);
        }
    }

    private Pair<BlockState, ItemStack> getBlockAt(DirectionalPosition destination) {
        return this.filterPosCache.get(destination, () -> {
            ItemStack pickBlock;
            ItemStack stack = new ItemStack((IItemProvider)Items.field_221931_gX);
            BlockState state = null;
            if (this.mc.field_71441_e.isAreaLoaded(destination.getPos(), 1) && (pickBlock = (state = this.mc.field_71441_e.func_180495_p(destination.getPos())).func_177230_c().getPickBlock(state, (RayTraceResult)new BlockRayTraceResult(new Vector3d((double)destination.getPos().func_177958_n() + 0.5, (double)destination.getPos().func_177956_o() + 0.5, (double)destination.getPos().func_177952_p() + 0.5), destination.getDirection(), destination.getPos(), true), (IBlockReader)this.mc.field_71441_e, destination.getPos(), (PlayerEntity)this.mc.field_71439_g)) != null && !pickBlock.func_190926_b()) {
                stack = pickBlock;
            }
            return new Pair<Object, ItemStack>(state, stack);
        });
    }

    @Override
    public void tick() {
        super.tick();
        this.filterPosCache.clear();
    }

    public int getOffset() {
        List<Filter<?>> f = this.filters.get();
        if (f.size() <= this.columnCount) {
            this.offset = 0;
        } else if (this.offset > f.size() - this.columnCount) {
            this.offset = f.size() - this.columnCount;
        }
        return this.offset;
    }

    public int getSelected() {
        if (this.selected >= this.filters.get().size()) {
            this.selected = -1;
        }
        return this.selected;
    }

    private void drawStringSmall(MatrixStack matrixStack, int x, int y, ITextComponent text) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)x, (double)y, 0.0);
        matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
        this.mc.field_71466_p.func_243248_b(matrixStack, text, 0.0f, 0.0f, 0);
        matrixStack.func_227865_b_();
    }

    public static <T> T get(ITag.INamedTag<T> tag) {
        long time = Minecraft.func_71410_x().field_71441_e.func_82737_E();
        List allElements = tag.func_230236_b_();
        return (T)allElements.get((int)(time / 20L % (long)allElements.size()));
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        List<Filter<?>> f = this.filters.get();
        if (f.size() > this.columnCount) {
            this.offset = delta < 0.0 ? Math.min(this.getOffset() + 1, f.size() - this.columnCount) : Math.max(this.getOffset() - 1, 0);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, delta);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        List<Filter<?>> f = this.filters.get();
        for (int i = 0; i < this.hoverAreas.length && this.getOffset() + i < f.size(); ++i) {
            if (!this.hoverAreas[i].isHovered(this.guiLeft, this.guiTop, (int)mouseX, (int)mouseY)) continue;
            this.selected = this.getOffset() + i;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

