/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.FluidFilter;
import de.maxhenkel.pipez.GasFilter;
import de.maxhenkel.pipez.ItemFilter;
import de.maxhenkel.pipez.Main;
import de.maxhenkel.pipez.corelib.helpers.AbstractStack;
import de.maxhenkel.pipez.corelib.inventory.ScreenBase;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.corelib.tag.TagUtils;
import de.maxhenkel.pipez.gui.CycleIconButton;
import de.maxhenkel.pipez.gui.FilterContainer;
import de.maxhenkel.pipez.gui.FilterList;
import de.maxhenkel.pipez.items.FilterDestinationToolItem;
import de.maxhenkel.pipez.net.OpenExtractMessage;
import de.maxhenkel.pipez.net.UpdateFilterMessage;
import de.maxhenkel.pipez.utils.GasUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidUtil;

public class FilterScreen
extends ScreenBase<FilterContainer> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("pipez", "textures/gui/container/filter.png");
    private TextFieldWidget item;
    private TextFieldWidget nbt;
    private CycleIconButton nbtButton;
    private CycleIconButton invertButton;
    private Button submitButton;
    private Button cancelButton;
    private ScreenBase.HoverArea itemHoverArea;
    private ScreenBase.HoverArea itemTextHoverArea;
    private ScreenBase.HoverArea nbtTextHoverArea;
    private ScreenBase.HoverArea exactNBTHoverArea;
    private ScreenBase.HoverArea invertHoverArea;
    private ScreenBase.HoverArea destinationHoverArea;
    private ScreenBase.HoverArea destinationTextHoverArea;
    private Filter<?> filter;

    public FilterScreen(FilterContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(BACKGROUND, container, playerInventory, title);
        this.field_146999_f = 176;
        this.field_147000_g = 222;
        this.filter = ((FilterContainer)this.func_212873_a_()).getFilter();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.hoverAreas.clear();
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        List<CycleIconButton.Icon> nbtIcons = Arrays.asList(new CycleIconButton.Icon(BACKGROUND, 176, 16), new CycleIconButton.Icon(BACKGROUND, 192, 16));
        this.nbtButton = new CycleIconButton(this.field_147003_i + 125, this.field_147009_r + 81, nbtIcons, () -> this.filter.isExactMetadata() ? 1 : 0, button -> this.filter.setExactMetadata(!this.filter.isExactMetadata()));
        this.func_230480_a_((Widget)this.nbtButton);
        List<CycleIconButton.Icon> invertIcons = Arrays.asList(new CycleIconButton.Icon(BACKGROUND, 176, 32), new CycleIconButton.Icon(BACKGROUND, 192, 32));
        this.invertButton = new CycleIconButton(this.field_147003_i + 149, this.field_147009_r + 81, invertIcons, () -> this.filter.isInvert() ? 1 : 0, button -> this.filter.setInvert(!this.filter.isInvert()));
        this.func_230480_a_((Widget)this.invertButton);
        this.cancelButton = new Button(this.field_147003_i + 25, this.field_147009_r + 105, 60, 20, (ITextComponent)new TranslationTextComponent("message.pipez.filter.cancel"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new OpenExtractMessage(((FilterContainer)this.func_212873_a_()).getIndex())));
        this.func_230480_a_((Widget)this.cancelButton);
        this.submitButton = new Button(this.field_147003_i + 91, this.field_147009_r + 105, 60, 20, (ITextComponent)new TranslationTextComponent("message.pipez.filter.submit"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new UpdateFilterMessage(this.filter, ((FilterContainer)this.field_147002_h).getIndex())));
        this.func_230480_a_((Widget)this.submitButton);
        this.item = new TextFieldWidget(this.field_230712_o_, this.field_147003_i + 30, this.field_147009_r + 18, 138, 16, StringTextComponent.field_240750_d_);
        this.item.func_146193_g(TextFormatting.WHITE.func_211163_e().intValue());
        this.item.func_146185_a(true);
        this.item.func_146203_f(1024);
        if (this.filter.getTag() != null) {
            if (this.filter.getTag() instanceof SingleElementTag) {
                this.item.func_146180_a(this.filter.getTag().func_230234_a_().toString());
            } else {
                this.item.func_146180_a("#" + this.filter.getTag().func_230234_a_().toString());
            }
        }
        this.item.func_212954_a(this::onItemTextChanged);
        this.item.func_200675_a(s -> {
            if (s.startsWith("#")) {
                s = s.substring(1);
            }
            return ResourceLocation.func_217855_b((String)s);
        });
        this.func_230480_a_((Widget)this.item);
        this.nbt = new TextFieldWidget(this.field_230712_o_, this.field_147003_i + 8, this.field_147009_r + 50, 160, 16, StringTextComponent.field_240750_d_);
        this.nbt.func_146193_g(TextFormatting.WHITE.func_211163_e().intValue());
        this.nbt.func_146185_a(true);
        this.nbt.func_146203_f(1024);
        this.nbt.func_146180_a(this.filter.getMetadata() != null ? this.filter.getMetadata().toString() : "");
        this.nbt.func_212954_a(this::onNbtTextChanged);
        this.nbt.field_230694_p_ = this.hasNBT();
        this.func_230480_a_((Widget)this.nbt);
        this.nbtButton.field_230693_o_ = this.filter.getMetadata() != null;
        this.itemHoverArea = new ScreenBase.HoverArea(8, 18, 16, 16, () -> {
            List<Object> tooltip = new ArrayList();
            AbstractStack<?> stack = FilterList.getStack(this.filter);
            if (stack != null) {
                tooltip = stack.getTooltip((Screen)this);
                if (this.filter.getTag() != null && !(this.filter.getTag() instanceof SingleElementTag)) {
                    tooltip.add(new TranslationTextComponent("tooltip.pipez.filter.accepts_tag", new Object[]{new StringTextComponent(this.filter.getTag().func_230234_a_().toString()).func_240699_a_(TextFormatting.BLUE)}).func_240699_a_(TextFormatting.GRAY));
                }
            }
            return tooltip.stream().map(ITextComponent::func_241878_f).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.itemHoverArea);
        this.itemTextHoverArea = new ScreenBase.HoverArea(29, 17, 140, 18, () -> {
            ArrayList<TranslationTextComponent> tooltip = new ArrayList<TranslationTextComponent>();
            tooltip.add(new TranslationTextComponent("tooltip.pipez.filter.item_tag.description"));
            return tooltip.stream().map(ITextComponent::func_241878_f).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.itemTextHoverArea);
        this.nbtTextHoverArea = new ScreenBase.HoverArea(7, 49, 162, 18, () -> {
            ArrayList<TranslationTextComponent> tooltip = new ArrayList<TranslationTextComponent>();
            if (this.hasNBT()) {
                tooltip.add(new TranslationTextComponent("tooltip.pipez.filter.nbt_string.description"));
            } else {
                tooltip.add(new TranslationTextComponent("tooltip.pipez.filter.nbt_string.no_nbt"));
            }
            return tooltip.stream().map(ITextComponent::func_241878_f).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.nbtTextHoverArea);
        this.exactNBTHoverArea = new ScreenBase.HoverArea(126, 82, 20, 20, () -> {
            ArrayList<TranslationTextComponent> tooltip = new ArrayList<TranslationTextComponent>();
            if (this.filter.isExactMetadata()) {
                tooltip.add(new TranslationTextComponent("tooltip.pipez.filter.nbt.exact"));
            } else {
                tooltip.add(new TranslationTextComponent("tooltip.pipez.filter.nbt.not_exact"));
            }
            return tooltip.stream().map(ITextComponent::func_241878_f).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.exactNBTHoverArea);
        this.invertHoverArea = new ScreenBase.HoverArea(150, 82, 20, 20, () -> {
            ArrayList<TranslationTextComponent> tooltip = new ArrayList<TranslationTextComponent>();
            if (this.filter.isInvert()) {
                tooltip.add(new TranslationTextComponent("tooltip.pipez.filter.inverted"));
            } else {
                tooltip.add(new TranslationTextComponent("tooltip.pipez.filter.not_inverted"));
            }
            return tooltip.stream().map(ITextComponent::func_241878_f).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.invertHoverArea);
        this.destinationHoverArea = new ScreenBase.HoverArea(8, 83, 16, 16, () -> {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(new TranslationTextComponent("tooltip.pipez.filter.destination.description"));
            if (this.filter.getDestination() != null) {
                tooltip.add(new TranslationTextComponent("tooltip.pipez.filter.destination.click_to_remove").func_240699_a_(TextFormatting.GRAY));
            }
            return tooltip.stream().map(ITextComponent::func_241878_f).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.destinationHoverArea);
        this.destinationTextHoverArea = new ScreenBase.HoverArea(25, 82, 96, 18, () -> {
            ArrayList<TranslationTextComponent> tooltip = new ArrayList<TranslationTextComponent>();
            if (this.filter.getDestination() != null) {
                DirectionalPosition dst = this.filter.getDestination();
                tooltip.add(new TranslationTextComponent("tooltip.pipez.filter_destination_tool.destination", new Object[]{this.number(dst.getPos().func_177958_n()), this.number(dst.getPos().func_177956_o()), this.number(dst.getPos().func_177952_p()), new TranslationTextComponent("message.pipez.direction." + dst.getDirection().func_176742_j()).func_240699_a_(TextFormatting.DARK_GREEN)}));
            }
            return tooltip.stream().map(ITextComponent::func_241878_f).collect(Collectors.toList());
        });
        this.hoverAreas.add(this.destinationTextHoverArea);
    }

    private boolean hasNBT() {
        return !(this.filter instanceof GasFilter);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.submitButton.field_230693_o_ = this.filter.getTag() != null || this.filter.getMetadata() != null;
    }

    public void onItemTextChanged(String text) {
        if (text.trim().isEmpty()) {
            this.nbt.func_146193_g(TextFormatting.WHITE.func_211163_e().intValue());
            return;
        }
        if (this.filter instanceof ItemFilter) {
            ITag.INamedTag<Item> tag = TagUtils.getItem(text, true);
            this.filter.setTag(tag);
            if (this.filter.getTag() == null) {
                this.item.func_146193_g(TextFormatting.DARK_RED.func_211163_e().intValue());
            } else {
                this.item.func_146193_g(TextFormatting.WHITE.func_211163_e().intValue());
            }
        } else if (this.filter instanceof FluidFilter) {
            ITag.INamedTag<Fluid> tag = TagUtils.getFluid(text, true);
            this.filter.setTag(tag);
            if (this.filter.getTag() == null) {
                this.item.func_146193_g(TextFormatting.DARK_RED.func_211163_e().intValue());
            } else {
                this.item.func_146193_g(TextFormatting.WHITE.func_211163_e().intValue());
            }
        } else if (this.filter instanceof GasFilter) {
            ITag.INamedTag<Gas> tag = GasUtils.getGas(text, true);
            this.filter.setTag(tag);
            if (this.filter.getTag() == null) {
                this.item.func_146193_g(TextFormatting.DARK_RED.func_211163_e().intValue());
            } else {
                this.item.func_146193_g(TextFormatting.WHITE.func_211163_e().intValue());
            }
        }
    }

    public void onNbtTextChanged(String text) {
        if (text.trim().isEmpty()) {
            this.nbt.func_146193_g(TextFormatting.WHITE.func_211163_e().intValue());
            this.nbtButton.field_230693_o_ = false;
            this.filter.setExactMetadata(false);
            return;
        }
        this.nbtButton.field_230693_o_ = true;
        try {
            this.filter.setMetadata(JsonToNBT.func_180713_a((String)text));
            this.nbt.func_146193_g(TextFormatting.WHITE.func_211163_e().intValue());
        }
        catch (CommandSyntaxException e) {
            this.nbt.func_146193_g(TextFormatting.DARK_RED.func_211163_e().intValue());
            this.filter.setMetadata(null);
        }
    }

    public void onInsertStack(ItemStack stack) {
        GasStack gas;
        if (stack == null || stack.func_190926_b()) {
            return;
        }
        if (this.filter instanceof ItemFilter) {
            this.item.func_146180_a(stack.func_77973_b().getRegistryName().toString());
            if (stack.func_77942_o()) {
                this.nbt.func_146180_a(stack.func_77978_p().toString());
            } else {
                this.nbt.func_146180_a("");
            }
        } else if (this.filter instanceof FluidFilter) {
            FluidUtil.getFluidContained((ItemStack)stack).ifPresent(s -> {
                this.item.func_146180_a(s.getFluid().getRegistryName().toString());
                if (s.hasTag()) {
                    this.nbt.func_146180_a(s.getTag().toString());
                } else {
                    this.nbt.func_146180_a("");
                }
            });
        } else if (this.filter instanceof GasFilter && (gas = GasUtils.getGasContained(stack)) != null) {
            this.item.func_146180_a(((Gas)gas.getType()).getRegistryName().toString());
            this.nbt.func_146180_a("");
        }
    }

    public void onInsertDestination(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof FilterDestinationToolItem)) {
            this.filter.setDestination(null);
            return;
        }
        DirectionalPosition dst = FilterDestinationToolItem.getDestination(stack);
        this.filter.setDestination(dst);
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("message.pipez.filter.item_tag"), 8.0f, 7.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("message.pipez.filter.nbt_string"), 8.0f, 39.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("message.pipez.filter.destination"), 8.0f, 71.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrixStack, this.field_213127_e.func_145748_c_(), 8.0f, (float)(this.field_147000_g - 96 + 3), 0x404040);
        this.drawHoverAreas(matrixStack, mouseX, mouseY);
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        AbstractStack<?> stack = FilterList.getStack(this.filter);
        if (stack != null) {
            stack.render(matrixStack, this.field_147003_i + 8, this.field_147009_r + 18);
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(this.field_147003_i + 31), (double)(this.field_147009_r + 89), 0.0);
        matrixStack.func_227862_a_(0.5f, 0.5f, 1.0f);
        if (this.filter.getDestination() != null) {
            DirectionalPosition dst = this.filter.getDestination();
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("message.pipez.filter_destination_tool.destination", new Object[]{this.number(dst.getPos().func_177958_n()), this.number(dst.getPos().func_177956_o()), this.number(dst.getPos().func_177952_p()), new StringTextComponent(String.valueOf(dst.getDirection().name().charAt(0))).func_240699_a_(TextFormatting.DARK_GREEN)}), 0.0f, 0.0f, 0xFFFFFF);
        } else {
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("message.pipez.filter_destination_tool.destination.any"), 0.0f, 0.0f, 0xFFFFFF);
        }
        matrixStack.func_227865_b_();
        if (this.itemHoverArea.isHovered(this.field_147003_i, this.field_147009_r, mouseX, mouseY)) {
            this.drawHoverSlot(matrixStack, this.field_147003_i + 8, this.field_147009_r + 18);
        }
        if (this.destinationHoverArea.isHovered(this.field_147003_i, this.field_147009_r, mouseX, mouseY)) {
            this.drawHoverSlot(matrixStack, this.field_147003_i + 8, this.field_147009_r + 83);
        }
    }

    private IFormattableTextComponent number(int num) {
        return new StringTextComponent(String.valueOf(num)).func_240699_a_(TextFormatting.DARK_GREEN);
    }

    private void drawHoverSlot(MatrixStack matrixStack, int posX, int posY) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.func_238468_a_(matrixStack, posX, posY, posX + 16, posY + 16, this.slotColor, -2130706433);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        Slot sl;
        if (this.itemHoverArea.isHovered(this.field_147003_i, this.field_147009_r, (int)mouseX, (int)mouseY)) {
            if (FilterScreen.func_231173_s_()) {
                this.item.func_146180_a("");
                this.filter.setTag(null);
            } else {
                this.onInsertStack(this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o());
            }
            return true;
        }
        if (this.destinationHoverArea.isHovered(this.field_147003_i, this.field_147009_r, (int)mouseX, (int)mouseY)) {
            this.onInsertDestination(this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o());
            return true;
        }
        if (FilterScreen.func_231173_s_() && (sl = this.getSlotUnderMouse()) != null) {
            this.onInsertStack(sl.func_75211_c());
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.field_230706_i_.field_71439_g.func_71053_j();
            return true;
        }
        return this.item.func_231046_a_(key, scanCode, modifiers) || this.item.func_212955_f() || this.nbt.func_231046_a_(key, scanCode, modifiers) || this.nbt.func_212955_f() || super.func_231046_a_(key, scanCode, modifiers);
    }

    public void func_231152_a_(Minecraft mc, int x, int y) {
        String itemTxt = this.item.func_146179_b();
        String nbtTxt = this.nbt.func_146179_b();
        this.func_231158_b_(mc, x, y);
        this.item.func_146180_a(itemTxt);
        this.nbt.func_146180_a(nbtTxt);
    }
}

