/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.LazyOptional;

public class DirectionalLazyOptionalCache<T> {
    protected Map<Direction, LazyOptional<T>> cache = new HashMap<Direction, LazyOptional<T>>();

    public DirectionalLazyOptionalCache() {
        for (Direction side : Direction.values()) {
            this.cache.put(side, LazyOptional.empty());
        }
    }

    public LazyOptional<T> get(Direction side) {
        return this.cache.get(side);
    }

    public void revalidate(Direction side, Function<Direction, Boolean> validFunction, Function<Direction, T> cachePopulator) {
        this.cache.get(side).invalidate();
        if (validFunction.apply(side).booleanValue()) {
            this.cache.put(side, LazyOptional.of(() -> cachePopulator.apply(side)));
        } else {
            this.cache.put(side, LazyOptional.empty());
        }
    }

    public void revalidate(Function<Direction, Boolean> validFunction, Function<Direction, T> cachePopulator) {
        for (Direction side : Direction.values()) {
            this.revalidate(side, validFunction, cachePopulator);
        }
    }

    public void invalidate() {
        this.cache.values().forEach(LazyOptional::invalidate);
    }
}

