/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Contract;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class SawmillRecipe
extends MekanismRecipe
implements Predicate<ItemStack> {
    protected static final Random RANDOM = new Random();
    private final ItemStackIngredient input;
    private final ItemStack mainOutput;
    private final ItemStack secondaryOutput;
    private final double secondaryChance;

    public SawmillRecipe(ResourceLocation id, ItemStackIngredient input, ItemStack mainOutput, ItemStack secondaryOutput, double secondaryChance) {
        super(id);
        this.input = input;
        this.mainOutput = mainOutput;
        this.secondaryOutput = secondaryOutput;
        this.secondaryChance = secondaryChance;
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.input.test(stack);
    }

    @Contract(value="_ -> new")
    public ChanceOutput getOutput(ItemStack input) {
        return new ChanceOutput(RANDOM.nextDouble());
    }

    public List<ItemStack> getMainOutputDefinition() {
        return this.mainOutput.func_190926_b() ? Collections.emptyList() : Collections.singletonList(this.mainOutput);
    }

    public List<ItemStack> getSecondaryOutputDefinition() {
        return this.secondaryOutput.func_190926_b() ? Collections.emptyList() : Collections.singletonList(this.secondaryOutput);
    }

    public double getSecondaryChance() {
        return this.secondaryChance;
    }

    public ItemStackIngredient getInput() {
        return this.input;
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.input.write(buffer);
        buffer.func_150788_a(this.mainOutput);
        buffer.func_150788_a(this.secondaryOutput);
        buffer.writeDouble(this.secondaryChance);
    }

    public class ChanceOutput {
        protected final double rand;

        public ChanceOutput(double rand) {
            this.rand = rand;
        }

        public ItemStack getMainOutput() {
            return SawmillRecipe.this.mainOutput.func_77946_l();
        }

        public ItemStack getMaxSecondaryOutput() {
            return SawmillRecipe.this.secondaryChance > 0.0 ? SawmillRecipe.this.secondaryOutput.func_77946_l() : ItemStack.field_190927_a;
        }

        public ItemStack getSecondaryOutput() {
            if (this.rand <= SawmillRecipe.this.secondaryChance) {
                return SawmillRecipe.this.secondaryOutput.func_77946_l();
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack nextSecondaryOutput() {
            double rand;
            if (SawmillRecipe.this.secondaryChance > 0.0 && (rand = RANDOM.nextDouble()) <= SawmillRecipe.this.secondaryChance) {
                return SawmillRecipe.this.secondaryOutput.func_77946_l();
            }
            return ItemStack.field_190927_a;
        }
    }
}

