/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemStackToItemStackCachedRecipe
extends CachedRecipe<ItemStackToItemStackRecipe> {
    private final IOutputHandler<@NonNull ItemStack> outputHandler;
    private final IInputHandler<@NonNull ItemStack> inputHandler;

    public ItemStackToItemStackCachedRecipe(ItemStackToItemStackRecipe recipe, IInputHandler<@NonNull ItemStack> inputHandler, IOutputHandler<@NonNull ItemStack> outputHandler) {
        super(recipe);
        this.inputHandler = inputHandler;
        this.outputHandler = outputHandler;
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        ItemStack recipeItem = this.inputHandler.getRecipeInput(((ItemStackToItemStackRecipe)this.recipe).getInput());
        if (recipeItem.func_190926_b()) {
            return -1;
        }
        currentMax = this.inputHandler.operationsCanSupport(((ItemStackToItemStackRecipe)this.recipe).getInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((ItemStackToItemStackRecipe)this.recipe).getOutput(recipeItem), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((ItemStackToItemStackRecipe)this.recipe).test(this.inputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        ItemStack recipeItem = this.inputHandler.getRecipeInput(((ItemStackToItemStackRecipe)this.recipe).getInput());
        if (recipeItem.func_190926_b()) {
            return;
        }
        this.inputHandler.use(recipeItem, operations);
        this.outputHandler.handleOutput(((ItemStackToItemStackRecipe)this.recipe).getOutput(recipeItem), operations);
    }
}

