/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.inputs.chemical;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTags;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.inputs.chemical.ChemicalIngredientInfo;
import mekanism.api.recipes.inputs.chemical.ChemicalStackIngredient;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import mekanism.api.recipes.inputs.chemical.InfusionStackIngredient;
import mekanism.api.recipes.inputs.chemical.PigmentStackIngredient;
import mekanism.api.recipes.inputs.chemical.SlurryStackIngredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ChemicalIngredientDeserializer<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>> {
    public static final ChemicalIngredientDeserializer<Gas, GasStack, GasStackIngredient> GAS = new ChemicalIngredientDeserializer<Gas, GasStack, GasStackIngredient>("gas", ChemicalIngredientInfo.GAS, ChemicalTags.GAS, GasStack::readFromPacket, Gas::getFromRegistry, GasStackIngredient::from, GasStackIngredient::from, GasStackIngredient.Multi::new, GasStackIngredient[]::new);
    public static final ChemicalIngredientDeserializer<InfuseType, InfusionStack, InfusionStackIngredient> INFUSION = new ChemicalIngredientDeserializer<InfuseType, InfusionStack, InfusionStackIngredient>("infuse type", ChemicalIngredientInfo.INFUSION, ChemicalTags.INFUSE_TYPE, InfusionStack::readFromPacket, InfuseType::getFromRegistry, InfusionStackIngredient::from, InfusionStackIngredient::from, InfusionStackIngredient.Multi::new, InfusionStackIngredient[]::new);
    public static final ChemicalIngredientDeserializer<Pigment, PigmentStack, PigmentStackIngredient> PIGMENT = new ChemicalIngredientDeserializer<Pigment, PigmentStack, PigmentStackIngredient>("pigment", ChemicalIngredientInfo.PIGMENT, ChemicalTags.PIGMENT, PigmentStack::readFromPacket, Pigment::getFromRegistry, PigmentStackIngredient::from, PigmentStackIngredient::from, PigmentStackIngredient.Multi::new, PigmentStackIngredient[]::new);
    public static final ChemicalIngredientDeserializer<Slurry, SlurryStack, SlurryStackIngredient> SLURRY = new ChemicalIngredientDeserializer<Slurry, SlurryStack, SlurryStackIngredient>("slurry", ChemicalIngredientInfo.SLURRY, ChemicalTags.SLURRY, SlurryStack::readFromPacket, Slurry::getFromRegistry, SlurryStackIngredient::from, SlurryStackIngredient::from, SlurryStackIngredient.Multi::new, SlurryStackIngredient[]::new);
    private final ChemicalTags<CHEMICAL> tags;
    private final Function<PacketBuffer, STACK> fromPacket;
    private final Function<ResourceLocation, CHEMICAL> fromRegistry;
    private final ChemicalIngredientInfo<CHEMICAL, STACK> info;
    private final Function<STACK, INGREDIENT> stackToIngredient;
    private final TagIngredientCreator<CHEMICAL, STACK, INGREDIENT> tagToIngredient;
    private final IntFunction<INGREDIENT[]> arrayCreator;
    private final Function<INGREDIENT[], INGREDIENT> multiCreator;
    private final String name;

    private ChemicalIngredientDeserializer(String name, ChemicalIngredientInfo<CHEMICAL, STACK> info, ChemicalTags<CHEMICAL> tags, Function<PacketBuffer, STACK> fromPacket, Function<ResourceLocation, CHEMICAL> fromRegistry, Function<STACK, INGREDIENT> stackToIngredient, TagIngredientCreator<CHEMICAL, STACK, INGREDIENT> tagToIngredient, Function<INGREDIENT[], INGREDIENT> multiCreator, IntFunction<INGREDIENT[]> arrayCreator) {
        this.fromPacket = fromPacket;
        this.fromRegistry = fromRegistry;
        this.tags = tags;
        this.info = info;
        this.stackToIngredient = stackToIngredient;
        this.tagToIngredient = tagToIngredient;
        this.arrayCreator = arrayCreator;
        this.multiCreator = multiCreator;
        this.name = name;
    }

    private String getNameWithPrefix() {
        if ("aeiou".indexOf(Character.toLowerCase(this.name.charAt(0))) == -1) {
            return "a " + this.name;
        }
        return "an " + this.name;
    }

    public final INGREDIENT read(PacketBuffer buffer) {
        IngredientType type = (IngredientType)buffer.func_179257_a(IngredientType.class);
        if (type == IngredientType.SINGLE) {
            return (INGREDIENT)((IChemicalStackIngredient)this.stackToIngredient.apply(this.fromPacket.apply(buffer)));
        }
        if (type == IngredientType.TAGGED) {
            return this.tagToIngredient.create((ITag<CHEMICAL>)this.tags.tag(buffer.func_192575_l()), buffer.func_179260_f());
        }
        IChemicalStackIngredient[] ingredients = (IChemicalStackIngredient[])this.arrayCreator.apply(buffer.func_150792_a());
        for (int i = 0; i < ingredients.length; ++i) {
            ingredients[i] = this.read(buffer);
        }
        return (INGREDIENT)this.createMulti(ingredients);
    }

    public final INGREDIENT deserialize(@Nullable JsonElement json) {
        String serializationKey;
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Ingredient cannot be null");
        }
        if (json.isJsonArray()) {
            JsonArray jsonArray = json.getAsJsonArray();
            int size = jsonArray.size();
            if (size == 0) {
                throw new JsonSyntaxException("Ingredient array cannot be empty, at least one ingredient must be defined");
            }
            if (size > 1) {
                IChemicalStackIngredient[] ingredients = (IChemicalStackIngredient[])this.arrayCreator.apply(size);
                for (int i = 0; i < size; ++i) {
                    ingredients[i] = this.deserialize(jsonArray.get(i));
                }
                return (INGREDIENT)this.createMulti(ingredients);
            }
            json = jsonArray.get(0);
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expected " + this.name + " to be object or array of objects");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        if (jsonObject.has(serializationKey = this.info.getSerializationKey()) && jsonObject.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or " + this.getNameWithPrefix() + ", not both");
        }
        if (jsonObject.has(serializationKey)) {
            return (INGREDIENT)((IChemicalStackIngredient)this.stackToIngredient.apply(this.deserializeStack(jsonObject)));
        }
        if (jsonObject.has("tag")) {
            if (!jsonObject.has("amount")) {
                throw new JsonSyntaxException("Expected to receive a amount that is greater than zero");
            }
            JsonElement count = jsonObject.get("amount");
            if (!JSONUtils.func_188175_b((JsonElement)count)) {
                throw new JsonSyntaxException("Expected amount to be a number greater than zero.");
            }
            long amount = count.getAsJsonPrimitive().getAsLong();
            if (amount < 1L) {
                throw new JsonSyntaxException("Expected amount to be greater than zero.");
            }
            ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"tag"));
            ITag tag = this.tags.getCollection().func_199910_a(resourceLocation);
            if (tag == null) {
                throw new JsonSyntaxException("Unknown " + this.name + " tag '" + resourceLocation + "'");
            }
            return this.tagToIngredient.create(tag, amount);
        }
        throw new JsonSyntaxException("Expected to receive a resource location representing either a tag or " + this.getNameWithPrefix() + ".");
    }

    @SafeVarargs
    public final INGREDIENT createMulti(INGREDIENT ... ingredients) {
        if (ingredients.length != 0 && ingredients.length == 1) {
            return ingredients[0];
        }
        ArrayList<INGREDIENT> cleanedIngredients = new ArrayList<INGREDIENT>();
        for (INGREDIENT ingredient : ingredients) {
            if (ingredient instanceof ChemicalStackIngredient.MultiIngredient) {
                cleanedIngredients.addAll(((ChemicalStackIngredient.MultiIngredient)ingredient).getIngredients());
                continue;
            }
            cleanedIngredients.add(ingredient);
        }
        return (INGREDIENT)((IChemicalStackIngredient)this.multiCreator.apply(cleanedIngredients.toArray(this.arrayCreator.apply(0))));
    }

    public final STACK deserializeStack(@Nonnull JsonObject json) {
        if (!json.has("amount")) {
            throw new JsonSyntaxException("Expected to receive a amount that is greater than zero");
        }
        JsonElement count = json.get("amount");
        if (!JSONUtils.func_188175_b((JsonElement)count)) {
            throw new JsonSyntaxException("Expected amount to be a number greater than zero.");
        }
        long amount = count.getAsJsonPrimitive().getAsLong();
        if (amount < 1L) {
            throw new JsonSyntaxException("Expected amount to be greater than zero.");
        }
        ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)this.info.getSerializationKey()));
        Chemical chemical = (Chemical)this.fromRegistry.apply(resourceLocation);
        if (chemical.isEmptyType()) {
            throw new JsonSyntaxException("Invalid " + this.name + " type '" + resourceLocation + "'");
        }
        return (STACK)this.info.createStack(chemical, amount);
    }

    public final JsonObject serializeStack(STACK stack) {
        JsonObject json = new JsonObject();
        json.addProperty(this.info.getSerializationKey(), ((ChemicalStack)stack).getType().getRegistryName().toString());
        json.addProperty("amount", (Number)((ChemicalStack)stack).getAmount());
        return json;
    }

    public static enum IngredientType {
        SINGLE,
        TAGGED,
        MULTI;

    }

    @FunctionalInterface
    public static interface TagIngredientCreator<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>> {
        public INGREDIENT create(ITag<CHEMICAL> var1, long var2);
    }
}

