/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.config;

import fr.raksrinana.fallingtree.fabric.config.ConfigCache;
import fr.raksrinana.fallingtree.fabric.config.ToolConfiguration;
import fr.raksrinana.fallingtree.fabric.config.TreeConfiguration;
import fr.raksrinana.fallingtree.fabric.config.validator.Validators;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.class_1269;

@Config(name="fallingtree")
public class Configuration
implements ConfigData {
    @ConfigEntry.Gui.Tooltip(count=2)
    @Comment(value="When set to true, a tree will only be chopped down if the player is sneaking.")
    public boolean reverseSneaking = false;
    @ConfigEntry.Gui.Tooltip(count=2)
    @Comment(value="When set to true, the mod will cut down trees in creative too.")
    public boolean breakInCreative = false;
    @ConfigEntry.Category(value="trees")
    @ConfigEntry.Gui.TransitiveObject
    public TreeConfiguration trees = new TreeConfiguration();
    @ConfigEntry.Category(value="tools")
    @ConfigEntry.Gui.TransitiveObject
    public ToolConfiguration tools = new ToolConfiguration();

    public static Configuration register() {
        ConfigHolder configHolder = AutoConfig.register(Configuration.class, JanksonConfigSerializer::new);
        configHolder.registerSaveListener((configHolder1, configuration) -> {
            ConfigCache.getInstance().invalidate();
            return class_1269.field_5811;
        });
        configHolder.registerLoadListener((configHolder1, configuration) -> {
            ConfigCache.getInstance().invalidate();
            return class_1269.field_5811;
        });
        return (Configuration)configHolder.getConfig();
    }

    public void validatePostLoad() throws ConfigData.ValidationException {
        Validators.runValidators(Configuration.class, this, "general");
        Validators.runValidators(ToolConfiguration.class, this.tools, "tools");
        Validators.runValidators(TreeConfiguration.class, this.trees, "trees");
    }

    public ToolConfiguration getToolsConfiguration() {
        return this.tools;
    }

    public TreeConfiguration getTreesConfiguration() {
        return this.trees;
    }

    public boolean isBreakInCreative() {
        return this.breakInCreative;
    }

    public boolean isReverseSneaking() {
        return this.reverseSneaking;
    }
}

