/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.config;

import fr.raksrinana.fallingtree.fabric.config.AdjacentStopMode;
import fr.raksrinana.fallingtree.fabric.config.BreakMode;
import fr.raksrinana.fallingtree.fabric.config.ConfigCache;
import fr.raksrinana.fallingtree.fabric.config.DetectionMode;
import fr.raksrinana.fallingtree.fabric.config.validator.BlockId;
import fr.raksrinana.fallingtree.fabric.config.validator.Min;
import fr.raksrinana.fallingtree.fabric.config.validator.MinMax;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.class_2248;

public class TreeConfiguration {
    @ConfigEntry.Gui.Tooltip(count=5)
    @Comment(value="Additional list of blocks considered as logs and that will be destroyed by the mod. \nINFO: Blocks marked with the log tag will already be whitelisted.")
    @BlockId
    public List<String> whitelistedLogs = new ArrayList<String>();
    @ConfigEntry.Gui.Tooltip(count=3)
    @Comment(value="List of blocks that should not be considered as logs. \nINFO: This wins over the whitelist.")
    @BlockId
    public List<String> blacklistedLogs = new ArrayList<String>();
    @ConfigEntry.Gui.Tooltip(count=5)
    @Comment(value="Additional list of blocks considered as leaves (decay naturally). \nINFO: Blocks marked with the leaves tag will already be whitelisted.")
    @BlockId
    public List<String> whitelistedLeaves = new ArrayList<String>();
    @ConfigEntry.Gui.Tooltip(count=2)
    @Comment(value="Additional list of blocks considered as leaves but that doesn't decay (need to be broken by tool).")
    @BlockId
    public List<String> whitelistedNonDecayLeaves = new ArrayList<String>();
    @ConfigEntry.Gui.Tooltip(count=3)
    @Comment(value="List of blocks that should not be considered as leaves. \nINFO: This wins over the whitelist.")
    @BlockId
    public List<String> blacklistedLeaves = new ArrayList<String>();
    @ConfigEntry.Gui.Tooltip(count=7)
    @Comment(value="How to break the tree. \nINSTANTANEOUS will break it in one go. \nSHIFT_DOWN will make the tree fall down as you cut it, so you still have to break x blocks but don't have to climb the tree for them.")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public BreakMode breakMode = BreakMode.INSTANTANEOUS;
    @ConfigEntry.Gui.Tooltip(count=9)
    @Comment(value="What part of the tree should be cut. \nWHOLE_TREE will break the whole tree. \nABOVE_CUT will break only blocks that are connected from above the cut point. \nABOVE_Y will break only blocks that are above the y value of the cut point.")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public DetectionMode detectionMode = DetectionMode.WHOLE_TREE;
    @ConfigEntry.Gui.Tooltip(count=2)
    @Comment(value="The maximum size of a tree. If there's more logs than this value the tree won't be cut.")
    @Min(value=1)
    public int maxSize = 100;
    @ConfigEntry.Gui.Tooltip(count=4)
    @Comment(value="The minimum amount of leaves that needs to be around the top most log in order for the mod to consider it a tree. \nINFO: Only in INSTANTANEOUS mode.")
    @MinMax(min=0, max=5)
    public int minimumLeavesAroundRequired = 1;
    @ConfigEntry.Gui.Tooltip(count=1)
    @Comment(value="When set to true, the mod be applied when cutting trunks.")
    public boolean treeBreaking = true;
    @ConfigEntry.Gui.Tooltip(count=2)
    @Comment(value="When set to true, leaves that should naturally break will be broken instantly.")
    public boolean leavesBreaking = true;
    @ConfigEntry.Gui.Tooltip(count=8)
    @Comment(value="Radius to force break leaves. If another tree is still holding the leaves they'll still be broken. If the leaves are persistent (placed by player) they'll also be destroyed. \nThe radius is applied from one of the top most log blocks. \nINFO: break_leaves must be activated for this to take effect. \nINFO: Only in INSTANTANEOUS mode.")
    @MinMax(min=0, max=10)
    public int leavesBreakingForceRadius = 0;
    @ConfigEntry.Gui.Tooltip(count=4)
    @Comment(value="When set to true this allow to have any kind of log in a tree trunk. \nOtherwise (false) the trunk will be considered as being only one kind of log.")
    public boolean allowMixedLogs = false;
    @ConfigEntry.Gui.Tooltip(count=2)
    @Comment(value="When set to true nether tree warts (leaves) will be broken along with the trunk.")
    public boolean breakNetherTreeWarts = true;
    @ConfigEntry.Gui.Tooltip(count=5)
    @Comment(value="This defines the area in which the tree is searched. If any branch is going out of this area it won't be cut. \nThis value is the radius of the area. \ni.e. Setting a value of 2 will result on an area of 3x3 centered on the log broken. \nIf this value is set to a negative number then no area restriction will be applied.")
    public int searchAreaRadius = -1;
    @ConfigEntry.Gui.Tooltip(count=9)
    @Comment(value="List the blocks that can be against the tree. If something else is adjacent then the tree won't be cut. \nINFO: Use adjacentStopMode to define how we stop the search for the tree.")
    @BlockId
    public List<String> whitelistedAdjacentBlocks = new ArrayList<String>();
    @ConfigEntry.Gui.Tooltip(count=9)
    @Comment(value="What to do when an non whitelisted adjacent block is found. \nSTOP_ALL will stop the search and nothing will be cut. \nSTOP_BRANCH will stop the current branch only. The rest of the tree will be cut.")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public AdjacentStopMode adjacentStopMode = AdjacentStopMode.STOP_ALL;

    public Collection<class_2248> getBlacklistedLeaves() {
        return ConfigCache.getInstance().getBlacklistedLeaves(this::getBlacklistedLeavesStr);
    }

    public Collection<String> getBlacklistedLeavesStr() {
        return this.blacklistedLeaves;
    }

    public Collection<class_2248> getBlacklistedLogs() {
        return ConfigCache.getInstance().getBlacklistedLogs(this::getBlacklistedLogsStr);
    }

    public Collection<String> getBlacklistedLogsStr() {
        return this.blacklistedLogs;
    }

    public BreakMode getBreakMode() {
        return this.breakMode;
    }

    public DetectionMode getDetectionMode() {
        return this.detectionMode;
    }

    public int getLeavesBreakingForceRadius() {
        return this.leavesBreakingForceRadius;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMinimumLeavesAroundRequired() {
        return this.minimumLeavesAroundRequired;
    }

    public Collection<class_2248> getWhitelistedLeaves() {
        return ConfigCache.getInstance().getWhitelistedLeaves(this::getWhitelistedLeavesStr);
    }

    public Collection<class_2248> getWhitelistedNonDecayLeaves() {
        return ConfigCache.getInstance().getWhitelistedNonDecayLeaves(this::getWhitelistedNonDecayLeavesStr);
    }

    public Collection<class_2248> getWhitelistedAdjacentBlocks() {
        return ConfigCache.getInstance().getWhitelistedAdjacentBlocks(this::getWhitelistedAdjacentBlocksString);
    }

    public Collection<class_2248> getWhitelistedLogs() {
        return ConfigCache.getInstance().getWhitelistedLogs(this::getWhitelistedLogsStr);
    }

    public Collection<String> getWhitelistedAdjacentBlocksString() {
        return this.whitelistedAdjacentBlocks;
    }

    public boolean isLeavesBreaking() {
        return this.leavesBreaking;
    }

    public boolean isTreeBreaking() {
        return this.treeBreaking;
    }

    public boolean isAllowMixedLogs() {
        return this.allowMixedLogs;
    }

    public boolean isBreakNetherTreeWarts() {
        return this.breakNetherTreeWarts;
    }

    public int getSearchAreaRadius() {
        return this.searchAreaRadius;
    }

    public AdjacentStopMode getAdjacentStopMode() {
        return this.adjacentStopMode;
    }

    public Collection<String> getWhitelistedLeavesStr() {
        return this.whitelistedLeaves;
    }

    public Collection<String> getWhitelistedNonDecayLeavesStr() {
        return this.whitelistedNonDecayLeaves;
    }

    public Collection<String> getWhitelistedLogsStr() {
        return this.whitelistedLogs;
    }
}

