/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.tree.builder;

import fr.raksrinana.fallingtree.fabric.FallingTree;
import fr.raksrinana.fallingtree.fabric.config.ConfigCache;
import fr.raksrinana.fallingtree.fabric.config.DetectionMode;
import fr.raksrinana.fallingtree.fabric.tree.Tree;
import fr.raksrinana.fallingtree.fabric.tree.builder.AbortSearchException;
import fr.raksrinana.fallingtree.fabric.tree.builder.ToAnalyzePos;
import fr.raksrinana.fallingtree.fabric.tree.builder.TreeTooBigException;
import fr.raksrinana.fallingtree.fabric.tree.builder.position.AbovePositionFetcher;
import fr.raksrinana.fallingtree.fabric.tree.builder.position.AboveYFetcher;
import fr.raksrinana.fallingtree.fabric.tree.builder.position.BasicPositionFetcher;
import fr.raksrinana.fallingtree.fabric.tree.builder.position.IPositionFetcher;
import fr.raksrinana.fallingtree.fabric.utils.FallingTreeUtils;
import fr.raksrinana.fallingtree.fabric.utils.TreePartType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_4970;

public class TreeBuilder {
    private static final EnumSet<class_2350> ALL_DIRECTIONS = EnumSet.allOf(class_2350.class);

    public static Optional<Tree> getTree(class_1937 world, class_2338 originPos) throws TreeTooBigException {
        class_2248 originBlock = world.method_8320(originPos).method_26204();
        if (!FallingTreeUtils.isLogBlock(originBlock)) {
            return Optional.empty();
        }
        int maxLogCount = FallingTree.config.getTreesConfiguration().getMaxSize();
        PriorityQueue<ToAnalyzePos> toAnalyzePos = new PriorityQueue<ToAnalyzePos>();
        HashSet<ToAnalyzePos> analyzedPos = new HashSet<ToAnalyzePos>();
        Tree tree = new Tree(world, originPos);
        toAnalyzePos.add(new ToAnalyzePos(TreeBuilder.getFirstPositionFetcher(), originPos, originBlock, originPos, originBlock, TreePartType.LOG, 0));
        Predicate<class_2338> boundingBoxSearch = TreeBuilder.getBoundingBoxSearch(originPos);
        Predicate<class_2248> adjacentPredicate = TreeBuilder.getAdjacentPredicate();
        try {
            while (!toAnalyzePos.isEmpty()) {
                ToAnalyzePos analyzingPos = (ToAnalyzePos)toAnalyzePos.remove();
                tree.addPart(analyzingPos.toTreePart());
                analyzedPos.add(analyzingPos);
                if (tree.getLogCount() > maxLogCount) {
                    throw new TreeTooBigException();
                }
                Collection<ToAnalyzePos> potentialPositions = analyzingPos.getPositionFetcher().getPositions(world, originPos, analyzingPos);
                Collection<ToAnalyzePos> nextPositions = TreeBuilder.filterPotentialPos(boundingBoxSearch, adjacentPredicate, world, originPos, originBlock, analyzingPos, potentialPositions, analyzedPos);
                nextPositions.removeAll(analyzedPos);
                nextPositions.removeAll(toAnalyzePos);
                toAnalyzePos.addAll(nextPositions);
            }
        }
        catch (AbortSearchException e) {
            return Optional.empty();
        }
        if (FallingTree.config.getTreesConfiguration().getBreakMode().shouldCheckLeavesAround()) {
            int aroundRequired = FallingTree.config.getTreesConfiguration().getMinimumLeavesAroundRequired();
            if (tree.getTopMostLog().map(topLog -> TreeBuilder.getLeavesAround(world, topLog) < (long)aroundRequired).orElse(true).booleanValue()) {
                return Optional.empty();
            }
        }
        return Optional.of(tree);
    }

    private static Predicate<class_2248> getAdjacentPredicate() {
        Collection<class_2248> whitelist = FallingTree.config.getTreesConfiguration().getWhitelistedAdjacentBlocks();
        Collection<class_2248> base = ConfigCache.getInstance().getAdjacentBlocksBase();
        if (whitelist.isEmpty()) {
            return block -> true;
        }
        switch (FallingTree.config.getTreesConfiguration().getAdjacentStopMode()) {
            case STOP_ALL: {
                return block -> {
                    boolean whitelisted;
                    boolean bl = whitelisted = whitelist.contains(block) || base.contains(block);
                    if (!whitelisted) {
                        throw new AbortSearchException("Found block " + block + " that isn't whitelisted");
                    }
                    return true;
                };
            }
            case STOP_BRANCH: {
                return block -> whitelist.contains(block) || base.contains(block);
            }
        }
        return block -> true;
    }

    private static Predicate<class_2338> getBoundingBoxSearch(class_2338 originPos) {
        int radius = FallingTree.config.getTreesConfiguration().getSearchAreaRadius();
        if (radius < 0) {
            return pos -> true;
        }
        int minX = originPos.method_10263() - radius;
        int maxX = originPos.method_10263() + radius;
        int minZ = originPos.method_10260() - radius;
        int maxZ = originPos.method_10260() + radius;
        return pos -> minX <= pos.method_10263() && maxX >= pos.method_10263() && minZ <= pos.method_10260() && maxZ >= pos.method_10260();
    }

    private static IPositionFetcher getFirstPositionFetcher() {
        DetectionMode detectionMode = FallingTree.config.getTreesConfiguration().getDetectionMode();
        if (detectionMode == DetectionMode.ABOVE_CUT) {
            return AbovePositionFetcher.getInstance();
        }
        if (detectionMode == DetectionMode.ABOVE_Y) {
            return AboveYFetcher.getInstance();
        }
        return BasicPositionFetcher.getInstance();
    }

    private static Collection<ToAnalyzePos> filterPotentialPos(Predicate<class_2338> boundingBoxSearch, Predicate<class_2248> adjacentPredicate, class_1937 world, class_2338 originPos, class_2248 originBlock, ToAnalyzePos parent, Collection<ToAnalyzePos> potentialPos, Collection<ToAnalyzePos> analyzedPos) {
        return potentialPos.stream().filter(pos -> !analyzedPos.contains(pos)).filter(pos -> TreeBuilder.shouldIncludeInChain(boundingBoxSearch, originPos, originBlock, parent, pos)).filter(pos -> EnumSet.allOf(class_2350.class).stream().map(direction -> pos.getCheckPos().method_10093(direction)).map(arg_0 -> ((class_1937)world).method_8320(arg_0)).map(class_4970.class_4971::method_26204).allMatch(adjacentPredicate)).collect(Collectors.toList());
    }

    private static long getLeavesAround(class_1937 world, class_2338 blockPos) {
        return ALL_DIRECTIONS.stream().map(arg_0 -> ((class_2338)blockPos).method_10093(arg_0)).filter(testPos -> {
            class_2248 block = world.method_8320(testPos).method_26204();
            return FallingTreeUtils.isLeafBlock(block) || FallingTreeUtils.isNetherWartOrShroomlight(block) || FallingTreeUtils.isLeafNeedBreakBlock(block);
        }).count();
    }

    private static boolean shouldIncludeInChain(Predicate<class_2338> boundingBoxSearch, class_2338 originPos, class_2248 originBlock, ToAnalyzePos parent, ToAnalyzePos check) {
        if (parent.getTreePartType() == TreePartType.LOG && TreeBuilder.isSameTree(originBlock, check) && boundingBoxSearch.test(check.getCheckPos())) {
            return true;
        }
        if (FallingTree.config.getTreesConfiguration().isBreakNetherTreeWarts() && check.getTreePartType() == TreePartType.NETHER_WART) {
            class_2338 checkBlockPos = check.getCheckPos();
            int dx = Math.abs(originPos.method_10263() - checkBlockPos.method_10263());
            int dz = Math.abs(originPos.method_10260() - checkBlockPos.method_10260());
            return dx <= 4 && dz <= 4;
        }
        return check.getTreePartType() == TreePartType.LEAF_NEED_BREAK;
    }

    private static boolean isSameTree(class_2248 parentLogBlock, ToAnalyzePos check) {
        if (FallingTree.config.getTreesConfiguration().isAllowMixedLogs()) {
            return check.getTreePartType() == TreePartType.LOG;
        }
        return check.getCheckBlock().equals(parentLogBlock);
    }
}

