/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.tree;

import fr.raksrinana.fallingtree.forge.tree.TreePart;
import fr.raksrinana.fallingtree.forge.utils.TreePartType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class Tree {
    private final World world;
    private final Set<TreePart> parts;
    private final Map<TreePartType, Integer> partCounts;
    private final BlockPos hitPos;

    public Tree(World world, BlockPos blockPos) {
        this.world = world;
        this.hitPos = blockPos;
        this.parts = new LinkedHashSet<TreePart>();
        this.partCounts = new HashMap<TreePartType, Integer>();
    }

    public void addPart(TreePart treePart) {
        this.parts.add(treePart);
        this.partCounts.compute(treePart.getTreePartType(), (key, value) -> {
            if (Objects.isNull(value)) {
                return 1;
            }
            return value + 1;
        });
    }

    public int getBreakableCount() {
        return Arrays.stream(TreePartType.values()).filter(TreePartType::isBreakable).mapToInt(this::getPartCount).sum();
    }

    private int getPartCount(TreePartType treePartType) {
        return this.partCounts.computeIfAbsent(treePartType, key -> 0);
    }

    public Optional<TreePart> getLastSequencePart() {
        return this.getParts().stream().max(Comparator.comparingInt(TreePart::getSequence));
    }

    public Collection<TreePart> getLogs() {
        return this.getParts().stream().filter(part -> part.getTreePartType() == TreePartType.LOG).collect(Collectors.toSet());
    }

    public Collection<TreePart> getBreakableParts() {
        return this.getParts().stream().filter(part -> part.getTreePartType().isBreakable()).collect(Collectors.toSet());
    }

    public int getLogCount() {
        return this.getPartCount(TreePartType.LOG);
    }

    public Optional<BlockPos> getTopMostLog() {
        return this.getLogs().stream().map(TreePart::getBlockPos).max(Comparator.comparingInt(Vector3i::func_177956_o));
    }

    private Optional<BlockPos> getTopMostPart() {
        return this.getParts().stream().map(TreePart::getBlockPos).max(Comparator.comparingInt(Vector3i::func_177956_o));
    }

    public Collection<TreePart> getWarts() {
        return this.getParts().stream().filter(part -> part.getTreePartType() == TreePartType.NETHER_WART).collect(Collectors.toSet());
    }

    public BlockPos getHitPos() {
        return this.hitPos;
    }

    public World getWorld() {
        return this.world;
    }

    public Collection<TreePart> getParts() {
        return this.parts;
    }
}

