/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.Arrays;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectable;
import mcjty.xnet.XNet;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import terrails.xnetgases.helper.ChannelModule;
import terrails.xnetgases.module.gas.GasChannelModule;
import terrails.xnetgases.module.gas.GasUtils;
import terrails.xnetgases.module.infuse.InfuseChannelModule;
import terrails.xnetgases.module.infuse.InfuseUtils;
import terrails.xnetgases.module.logic.XGLogicChannelModule;
import terrails.xnetgases.module.pigment.PigmentChannelModule;
import terrails.xnetgases.module.pigment.PigmentUtils;
import terrails.xnetgases.module.slurry.SlurryChannelModule;
import terrails.xnetgases.module.slurry.SlurryUtils;

@Mod(value="xnetgases")
public class XNetGases {
    public static final String MOD_ID = "xnetgases";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final ForgeConfigSpec CONFIG_SPEC;
    private static final ChannelModule[] MODULES;

    public XNetGases() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CONFIG_SPEC, "xnetgases.toml");
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        XNetGases.loadConfig(FMLPaths.CONFIGDIR.get().resolve("xnetgases.toml"));
        Arrays.stream(MODULES).forEach(module -> XNet.xNetApi.registerChannelType((IChannelType)module));
        XNet.xNetApi.registerConnectable((reader, connectorPos, blockPos, tile, direction) -> {
            if (GasUtils.getGasHandlerFor((ICapabilityProvider)tile, direction).isPresent() || SlurryUtils.getSlurryHandlerFor((ICapabilityProvider)tile, direction).isPresent() || InfuseUtils.getInfuseHandlerFor((ICapabilityProvider)tile, direction).isPresent() || PigmentUtils.getPigmentHandlerFor((ICapabilityProvider)tile, direction).isPresent()) {
                return IConnectable.ConnectResult.YES;
            }
            return IConnectable.ConnectResult.DEFAULT;
        });
    }

    private static void loadConfig(Path path) {
        LOGGER.debug("Loading config file {}", (Object)path);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        LOGGER.debug("Built TOML config for {}", (Object)path.toString());
        configData.load();
        LOGGER.debug("Loaded TOML config for {}", (Object)path.toString());
        CONFIG_SPEC.setConfig((CommentedConfig)configData);
    }

    static {
        MODULES = new ChannelModule[]{new GasChannelModule(), new InfuseChannelModule(), new XGLogicChannelModule(), new PigmentChannelModule(), new SlurryChannelModule()};
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("General settings").push("general");
        Arrays.stream(MODULES).forEach(module -> module.setupConfig(builder));
        CONFIG_SPEC = builder.pop().build();
    }
}

