/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.infuse;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import terrails.xnetgases.helper.ChannelModule;
import terrails.xnetgases.module.infuse.InfuseChannelSettings;
import terrails.xnetgases.module.infuse.InfuseConnectorSettings;
import terrails.xnetgases.module.infuse.InfuseUtils;

public class InfuseChannelModule
extends ChannelModule {
    public static ForgeConfigSpec.IntValue maxInfuseRateNormal;
    public static ForgeConfigSpec.IntValue maxInfuseRateAdvanced;

    public String getID() {
        return "mekanism.infuse";
    }

    public String getName() {
        return "Mekanism Infuse";
    }

    public boolean supportsBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nullable Direction direction) {
        return InfuseUtils.getInfuseHandlerFor((ICapabilityProvider)world.func_175625_s(pos), direction).isPresent();
    }

    @Nonnull
    public IConnectorSettings createConnector(@Nonnull Direction direction) {
        return new InfuseConnectorSettings(direction);
    }

    @Nonnull
    public IChannelSettings createChannel() {
        return new InfuseChannelSettings();
    }

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        maxInfuseRateNormal = builder.comment("Maximum infuse per operation that a normal connector can input or output").defineInRange("maxInfuseRateNormal", 1000, 1, 1000000000);
        maxInfuseRateAdvanced = builder.comment("Maximum infuse per operation that an advanced connector can input or output").defineInRange("maxInfuseRateAdvanced", 5000, 1, 1000000000);
    }
}

