/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.logic;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.DefaultChannelSettings;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import terrails.xnetgases.Constants;
import terrails.xnetgases.module.logic.XGLogicConnectorSettings;
import terrails.xnetgases.module.logic.XGSensor;

public class XGLogicChannelSettings
extends DefaultChannelSettings
implements IChannelSettings {
    private int delay = 0;
    private int colors = 0;
    private List<Pair<SidedConsumer, XGLogicConnectorSettings>> sensors = null;
    private List<Pair<SidedConsumer, XGLogicConnectorSettings>> outputs = null;

    public JsonObject writeToJson() {
        return new JsonObject();
    }

    public void readFromNBT(CompoundNBT tag) {
        this.delay = tag.func_74762_e("delay");
        this.colors = tag.func_74762_e("colors");
    }

    public void writeToNBT(CompoundNBT tag) {
        tag.func_74768_a("delay", this.delay);
        tag.func_74768_a("colors", this.colors);
    }

    public void tick(int channel, IControllerContext context) {
        XGLogicConnectorSettings settings;
        --this.delay;
        if (this.delay <= 0) {
            this.delay = 1200;
        }
        if (this.delay % 5 != 0) {
            return;
        }
        int d = this.delay / 5;
        this.updateCache(channel, context);
        World world = context.getControllerWorld();
        this.colors = 0;
        for (Pair<SidedConsumer, XGLogicConnectorSettings> entry : this.sensors) {
            settings = (XGLogicConnectorSettings)((Object)entry.getValue());
            if (d % settings.getSpeed() != 0) {
                this.colors |= settings.getColorMask();
                continue;
            }
            int sensorColors = 0;
            BlockPos connectorPos = context.findConsumerPosition(((SidedConsumer)entry.getKey()).getConsumerId());
            if (connectorPos != null) {
                boolean sense;
                Direction side = ((SidedConsumer)entry.getKey()).getSide();
                BlockPos pos = connectorPos.func_177972_a(side);
                if (!LevelTools.isLoaded((World)world, (BlockPos)pos)) {
                    this.colors |= settings.getColorMask();
                    continue;
                }
                boolean bl = sense = !this.checkRedstone(world, settings, connectorPos);
                if (sense && !context.matchColor(settings.getColorsMask())) {
                    sense = false;
                }
                if (sense) {
                    TileEntity te = world.func_175625_s(pos);
                    for (XGSensor sensor : settings.getSensors()) {
                        if (!sensor.test(te, settings)) continue;
                        sensorColors |= 1 << sensor.getOutputColor().ordinal();
                    }
                }
            }
            settings.setColorMask(sensorColors);
            this.colors |= sensorColors;
        }
        for (Pair<SidedConsumer, XGLogicConnectorSettings> entry : this.outputs) {
            TileEntity te;
            BlockPos connectorPos;
            settings = (XGLogicConnectorSettings)((Object)entry.getValue());
            if (d % settings.getSpeed() != 0 || (connectorPos = context.findConsumerPosition(((SidedConsumer)entry.getKey()).getConsumerId())) == null) continue;
            Direction side = ((SidedConsumer)entry.getKey()).getSide();
            if (!LevelTools.isLoaded((World)world, (BlockPos)connectorPos) || !((te = world.func_175625_s(connectorPos)) instanceof ConnectorTileEntity)) continue;
            ConnectorTileEntity connectorTE = (ConnectorTileEntity)te;
            int powerOut = this.checkRedstone(world, settings, connectorPos) ? 0 : (!context.matchColor(settings.getColorsMask()) ? 0 : (settings.getRedstoneOut() == null ? 0 : settings.getRedstoneOut()));
            connectorTE.setPowerOut(side, powerOut);
        }
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.sensors == null || this.outputs == null) {
            XGLogicConnectorSettings con;
            this.sensors = new ArrayList<Pair<SidedConsumer, XGLogicConnectorSettings>>();
            this.outputs = new ArrayList<Pair<SidedConsumer, XGLogicConnectorSettings>>();
            Map connectors = context.getConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                con = (XGLogicConnectorSettings)((Object)entry.getValue());
                if (con.getLogicMode() == XGLogicConnectorSettings.LogicMode.SENSOR) {
                    this.sensors.add((Pair<SidedConsumer, XGLogicConnectorSettings>)Pair.of(entry.getKey(), (Object)((Object)con)));
                    continue;
                }
                this.outputs.add((Pair<SidedConsumer, XGLogicConnectorSettings>)Pair.of(entry.getKey(), (Object)((Object)con)));
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                con = (XGLogicConnectorSettings)((Object)entry.getValue());
                if (con.getLogicMode() != XGLogicConnectorSettings.LogicMode.OUTPUT) continue;
                this.outputs.add((Pair<SidedConsumer, XGLogicConnectorSettings>)Pair.of(entry.getKey(), (Object)((Object)con)));
            }
        }
    }

    public void cleanCache() {
        this.sensors = null;
        this.outputs = null;
    }

    public int getColors() {
        return this.colors;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 11, 90, 11, 10);
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public boolean isEnabled(String s) {
        return true;
    }

    public void createGui(IEditorGui iEditorGui) {
    }

    public void update(Map<String, Object> map) {
    }
}

