/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.logic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mcjty.lib.varia.JSonTools;
import mcjty.rftoolsbase.api.xnet.channels.Color;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.helper.BaseStringTranslators;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import terrails.xnetgases.module.gas.GasUtils;
import terrails.xnetgases.module.infuse.InfuseUtils;
import terrails.xnetgases.module.logic.LogicUtils;
import terrails.xnetgases.module.logic.XGLogicConnectorSettings;
import terrails.xnetgases.module.pigment.PigmentUtils;
import terrails.xnetgases.module.slurry.SlurryUtils;

public class XGSensor {
    public final String modeTag;
    public final String operatorTag;
    public final String amountTag;
    public final String colorTag;
    public final String filterTag;
    private int amount = 0;
    private SensorMode sensorMode = SensorMode.OFF;
    private Color outputColor = Color.OFF;
    private Operator operator = Operator.EQUAL;
    private ItemStack filter = ItemStack.field_190927_a;

    public XGSensor(int index) {
        String temp = String.format("sensor%s_", index);
        this.modeTag = temp + "mode";
        this.operatorTag = temp + "operator";
        this.amountTag = temp + "amount";
        this.colorTag = temp + "color";
        this.filterTag = temp + "filter";
    }

    public Color getOutputColor() {
        return this.outputColor;
    }

    public boolean isEnabled(String tag) {
        if (this.modeTag.equals(tag)) {
            return true;
        }
        if (this.operatorTag.equals(tag)) {
            return true;
        }
        if (this.amountTag.equals(tag)) {
            return true;
        }
        if (this.colorTag.equals(tag)) {
            return true;
        }
        if (this.filterTag.equals(tag)) {
            return this.sensorMode != SensorMode.OFF;
        }
        return false;
    }

    public void createGui(IEditorGui gui) {
        gui.choices(this.modeTag, "Sensor mode", (Enum)this.sensorMode, (Enum[])SensorMode.values()).choices(this.operatorTag, "Operator", (Enum)this.operator, (Enum[])Operator.values()).integer(this.amountTag, "Amount to compare with", Integer.valueOf(this.amount), 46).colors(this.colorTag, "Output color", Integer.valueOf(this.outputColor.getColor()), Color.COLORS).ghostSlot(this.filterTag, this.filter).nl();
    }

    public boolean test(@Nullable TileEntity te, XGLogicConnectorSettings settings) {
        switch (this.sensorMode) {
            case GAS: {
                return GasUtils.getGasHandlerFor((ICapabilityProvider)te, settings.getFacing()).map(handler -> GasUtils.getGasHandlerFor((ICapabilityProvider)this.filter, null).map(filterHandler -> {
                    if (filterHandler.getTanks() <= 0) {
                        return false;
                    }
                    Gas filterChemical = (Gas)((GasStack)filterHandler.getChemicalInTank(0)).getType();
                    return this.operator.match(GasUtils.getGasCount(handler, settings.getFacing(), filterChemical), this.amount);
                }).orElseGet(() -> this.filter.func_190926_b() && this.operator.match(GasUtils.getGasCount(handler, settings.getFacing()), this.amount))).orElse(false);
            }
            case SLURRY: {
                return SlurryUtils.getSlurryHandlerFor((ICapabilityProvider)te, settings.getFacing()).map(handler -> SlurryUtils.getSlurryHandlerFor((ICapabilityProvider)this.filter, null).map(filterHandler -> {
                    if (filterHandler.getTanks() <= 0) {
                        return false;
                    }
                    Slurry filterChemical = (Slurry)((SlurryStack)filterHandler.getChemicalInTank(0)).getType();
                    return this.operator.match(SlurryUtils.getSlurryCount(handler, settings.getFacing(), filterChemical), this.amount);
                }).orElseGet(() -> this.filter.func_190926_b() && this.operator.match(SlurryUtils.getSlurryCount(handler, settings.getFacing()), this.amount))).orElse(false);
            }
            case INFUSE: {
                return InfuseUtils.getInfuseHandlerFor((ICapabilityProvider)te, settings.getFacing()).map(handler -> InfuseUtils.getInfuseHandlerFor((ICapabilityProvider)this.filter, null).map(filterHandler -> {
                    if (filterHandler.getTanks() <= 0) {
                        return false;
                    }
                    InfuseType filterChemical = (InfuseType)((InfusionStack)filterHandler.getChemicalInTank(0)).getType();
                    return this.operator.match(InfuseUtils.getInfuseCount(handler, settings.getFacing(), filterChemical), this.amount);
                }).orElseGet(() -> this.filter.func_190926_b() && this.operator.match(InfuseUtils.getInfuseCount(handler, settings.getFacing()), this.amount))).orElse(false);
            }
            case PIGMENT: {
                return PigmentUtils.getPigmentHandlerFor((ICapabilityProvider)te, settings.getFacing()).map(handler -> PigmentUtils.getPigmentHandlerFor((ICapabilityProvider)this.filter, null).map(filterHandler -> {
                    if (filterHandler.getTanks() <= 0) {
                        return false;
                    }
                    Pigment filterChemical = (Pigment)((PigmentStack)filterHandler.getChemicalInTank(0)).getType();
                    return this.operator.match(PigmentUtils.getPigmentCount(handler, settings.getFacing(), filterChemical), this.amount);
                }).orElseGet(() -> this.filter.func_190926_b() && this.operator.match(PigmentUtils.getPigmentCount(handler, settings.getFacing()), this.amount))).orElse(false);
            }
        }
        return false;
    }

    public void update(Map<String, Object> data) {
        this.sensorMode = this.getObjectFromMap(data, this.modeTag, SensorMode.OFF, object -> SensorMode.valueOf(((String)object).toUpperCase()));
        this.operator = this.getObjectFromMap(data, this.operatorTag, Operator.EQUAL, object -> Operator.byCode(((String)object).toUpperCase()));
        this.amount = this.getObjectFromMap(data, this.amountTag, 0, Integer.class::cast);
        this.outputColor = this.getObjectFromMap(data, this.colorTag, Color.OFF, object -> Color.colorByValue((int)((Integer)object)));
        this.filter = this.getObjectFromMap(data, this.filterTag, ItemStack.field_190927_a, ItemStack.class::cast);
    }

    private <T> T getObjectFromMap(Map<String, Object> data, String key, T defaultValue, Function<Object, T> function) {
        Object object = data.get(key);
        if (object != null) {
            return function.apply(object);
        }
        return defaultValue;
    }

    public void readFromNBT(CompoundNBT tag) {
        this.sensorMode = SensorMode.values()[tag.func_74771_c(this.modeTag)];
        this.operator = Operator.values()[tag.func_74771_c(this.operatorTag)];
        this.amount = tag.func_74762_e(this.amountTag);
        this.outputColor = Color.values()[tag.func_74771_c(this.colorTag)];
        if (tag.func_74764_b(this.filterTag)) {
            CompoundNBT itemTag = tag.func_74775_l(this.filterTag);
            this.filter = ItemStack.func_199557_a((CompoundNBT)itemTag);
        } else {
            this.filter = ItemStack.field_190927_a;
        }
    }

    public void writeToNBT(CompoundNBT tag) {
        tag.func_74774_a(this.modeTag, (byte)this.sensorMode.ordinal());
        tag.func_74774_a(this.operatorTag, (byte)this.operator.ordinal());
        tag.func_74768_a(this.amountTag, this.amount);
        tag.func_74774_a(this.colorTag, (byte)this.outputColor.ordinal());
        if (!this.filter.func_190926_b()) {
            CompoundNBT itemTag = new CompoundNBT();
            this.filter.func_77955_b(itemTag);
            tag.func_218657_a(this.filterTag, (INBT)itemTag);
        }
    }

    public void writeToJson(JsonObject json) {
        json.add(this.modeTag, (JsonElement)new JsonPrimitive(this.sensorMode.name()));
        json.add(this.colorTag, (JsonElement)new JsonPrimitive(this.outputColor.name()));
        json.add(this.operatorTag, (JsonElement)new JsonPrimitive(this.operator.name()));
        json.add(this.amountTag, (JsonElement)new JsonPrimitive((Number)this.amount));
        if (!this.filter.func_190926_b()) {
            json.add(this.filterTag, (JsonElement)JSonTools.itemStackToJson((ItemStack)this.filter));
        }
    }

    public void readFromJson(JsonObject json) {
        this.amount = json.has(this.amountTag) ? json.get(this.amountTag).getAsInt() : 0;
        this.operator = json.has(this.operatorTag) ? LogicUtils.getOperatorFrom(json.get(this.operatorTag).getAsString()) : Operator.EQUAL;
        this.outputColor = json.has(this.colorTag) ? BaseStringTranslators.getColor((String)json.get(this.colorTag).getAsString()) : Color.OFF;
        this.sensorMode = json.has(this.modeTag) ? LogicUtils.getSensorModeFrom(json.get(this.modeTag).getAsString()) : SensorMode.OFF;
        this.filter = json.has(this.filterTag) ? JSonTools.jsonToItemStack((JsonObject)json.get(this.filterTag).getAsJsonObject()) : ItemStack.field_190927_a;
    }

    public static enum Operator {
        EQUAL("=", Long::equals),
        NOTEQUAL("!=", (i1, i2) -> !i1.equals(i2)),
        LESS("<", (i1, i2) -> i1 < i2),
        GREATER(">", (i1, i2) -> i1 > i2),
        LESSOREQUAL("<=", (i1, i2) -> i1 <= i2),
        GREATEROREQUAL(">=", (i1, i2) -> i1 >= i2);

        private final String code;
        private final BiPredicate<Long, Long> matcher;
        private static final Map<String, Operator> OPERATOR_MAP;

        private Operator(String code, BiPredicate<Long, Long> matcher) {
            this.code = code;
            this.matcher = matcher;
        }

        public static Operator byCode(String name) {
            return OPERATOR_MAP.get(name);
        }

        public boolean match(long i1, long i2) {
            return this.matcher.test(i1, i2);
        }

        public String toString() {
            return this.code;
        }

        static {
            OPERATOR_MAP = Arrays.stream(Operator.values()).collect(Collectors.toMap(op -> op.code, op -> op));
        }
    }

    public static enum SensorMode {
        OFF,
        GAS,
        SLURRY,
        INFUSE,
        PIGMENT;

    }
}

