/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.pigment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import terrails.xnetgases.module.pigment.PigmentChannelSettings;
import terrails.xnetgases.module.pigment.PigmentConnectorSettings;

public class PigmentUtils {
    private static Map<String, PigmentConnectorSettings.PigmentMode> connectorModeCache;
    private static Map<String, PigmentChannelSettings.ChannelMode> channelModeCache;

    @Nonnull
    public static PigmentConnectorSettings.PigmentMode getConnectorModeFrom(String s) {
        if (connectorModeCache == null) {
            connectorModeCache = new HashMap<String, PigmentConnectorSettings.PigmentMode>();
            for (PigmentConnectorSettings.PigmentMode mode : PigmentConnectorSettings.PigmentMode.values()) {
                connectorModeCache.put(mode.name(), mode);
            }
        }
        return connectorModeCache.get(s);
    }

    @Nonnull
    public static PigmentChannelSettings.ChannelMode getChannelModeFrom(String s) {
        if (channelModeCache == null) {
            channelModeCache = new HashMap<String, PigmentChannelSettings.ChannelMode>();
            for (PigmentChannelSettings.ChannelMode mode : PigmentChannelSettings.ChannelMode.values()) {
                channelModeCache.put(mode.name(), mode);
            }
        }
        return channelModeCache.get(s);
    }

    @Nonnull
    public static Optional<IPigmentHandler> getPigmentHandlerFor(@Nullable ICapabilityProvider provider, @Nullable Direction direction) {
        if (provider == null) {
            return Optional.empty();
        }
        if (Capabilities.PIGMENT_HANDLER_CAPABILITY != null && provider.getCapability(Capabilities.PIGMENT_HANDLER_CAPABILITY, direction).isPresent()) {
            return Optional.of(provider.getCapability(Capabilities.PIGMENT_HANDLER_CAPABILITY, direction).orElseThrow(() -> new IllegalArgumentException("IPigmentHandler is 'null' even though it said that its present")));
        }
        if (direction != null && provider instanceof IPigmentHandler.ISidedPigmentHandler && ((IPigmentHandler.ISidedPigmentHandler)provider).getTanks(direction) >= 1) {
            return Optional.of((IPigmentHandler)provider);
        }
        if (!(provider instanceof IPigmentHandler.ISidedPigmentHandler) && provider instanceof IPigmentHandler && ((IPigmentHandler)provider).getTanks() >= 1) {
            return Optional.of((IPigmentHandler)provider);
        }
        return Optional.empty();
    }

    @Nonnull
    public static PigmentStack insertPigment(IPigmentHandler handler, PigmentStack stack, @Nullable Direction direction, Action action) {
        if (handler instanceof IPigmentHandler.ISidedPigmentHandler) {
            return (PigmentStack)((IPigmentHandler.ISidedPigmentHandler)handler).insertChemical((ChemicalStack)stack, direction, action);
        }
        return (PigmentStack)handler.insertChemical((ChemicalStack)stack, action);
    }

    @Nonnull
    public static PigmentStack extractPigment(IPigmentHandler handler, long amount, @Nullable Direction direction, Action action) {
        if (handler instanceof IPigmentHandler.ISidedPigmentHandler) {
            return (PigmentStack)((IPigmentHandler.ISidedPigmentHandler)handler).extractChemical(amount, direction, action);
        }
        return (PigmentStack)handler.extractChemical(amount, action);
    }

    public static List<Pigment> getPigmentInTank(@Nonnull IPigmentHandler handler, @Nullable Direction direction) {
        ArrayList<Pigment> pigments = new ArrayList<Pigment>();
        if (handler instanceof IPigmentHandler.ISidedPigmentHandler) {
            for (int i = 0; i < ((IPigmentHandler.ISidedPigmentHandler)handler).getTanks(direction); ++i) {
                pigments.add((Pigment)((PigmentStack)((IPigmentHandler.ISidedPigmentHandler)handler).getChemicalInTank(i, direction)).getType());
            }
        } else {
            for (int i = 0; i < handler.getTanks(); ++i) {
                pigments.add((Pigment)((PigmentStack)handler.getChemicalInTank(i)).getType());
            }
        }
        return pigments;
    }

    public static List<Pigment> getPigmentInTank(@Nonnull IPigmentHandler handler) {
        return PigmentUtils.getPigmentInTank(handler, null);
    }

    public static long getPigmentCount(@Nonnull IPigmentHandler handler, @Nullable Direction direction, @Nullable Predicate<PigmentStack> filter) {
        long count = 0L;
        if (handler instanceof IPigmentHandler.ISidedPigmentHandler) {
            for (int i = 0; i < ((IPigmentHandler.ISidedPigmentHandler)handler).getTanks(direction); ++i) {
                PigmentStack stack = (PigmentStack)((IPigmentHandler.ISidedPigmentHandler)handler).getChemicalInTank(i, direction);
                if (stack.isEmpty() || filter != null && !filter.test(stack)) continue;
                count += stack.getAmount();
            }
        } else {
            for (int i = 0; i < handler.getTanks(); ++i) {
                PigmentStack stack = (PigmentStack)handler.getChemicalInTank(i);
                if (stack.isEmpty() || filter != null && !filter.test(stack)) continue;
                count += stack.getAmount();
            }
        }
        return count;
    }

    public static long getPigmentCount(@Nonnull IPigmentHandler handler, @Nullable Direction direction, @Nullable Pigment filter) {
        return PigmentUtils.getPigmentCount(handler, direction, (PigmentStack stack) -> filter == null || stack.getType() == filter);
    }

    public static long getPigmentCount(@Nonnull IPigmentHandler handler, @Nullable Direction direction, @Nullable PigmentStack filter) {
        return PigmentUtils.getPigmentCount(handler, direction, (PigmentStack stack) -> filter == null || stack.isTypeEqual((ChemicalStack)filter));
    }

    public static long getPigmentCount(@Nonnull IPigmentHandler handler, @Nullable Direction direction) {
        return PigmentUtils.getPigmentCount(handler, direction, (Predicate<PigmentStack>)null);
    }

    public static long getPigmentCount(@Nonnull IPigmentHandler handler) {
        return PigmentUtils.getPigmentCount(handler, null);
    }
}

