/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.annotation.processor.modinit;

import io.github.noeppi_noeppi.libx.annotation.Model;
import io.github.noeppi_noeppi.libx.annotation.processor.modinit.ModEnv;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;

public class ModelProcessor {
    public static void processModel(Element element, ModEnv env) {
        if (element.getKind() != ElementKind.FIELD || !(element instanceof VariableElement) || !(element.getEnclosingElement() instanceof QualifiedNameable)) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "@Model can only be used on fields.");
            return;
        }
        if (!element.getModifiers().contains((Object)Modifier.PUBLIC) || !element.getModifiers().contains((Object)Modifier.STATIC) || element.getModifiers().contains((Object)Modifier.FINAL)) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "@Model can only be used on public static non-final fields.");
            return;
        }
        TypeElement typeElement = env.elements().getTypeElement("net.minecraft.client.renderer.model.IBakedModel");
        if (typeElement != null) {
            if (!env.sameErasure(element.asType(), typeElement.asType())) {
                env.messager().printMessage(Diagnostic.Kind.ERROR, "Field annotated @Model needs a type of IBakedModel.");
                return;
            }
        } else if (!env.types().isSubtype(element.asType(), env.elements().getTypeElement("net.minecraftforge.client.extensions.IForgeBakedModel").asType())) {
            env.messager().printMessage(Diagnostic.Kind.ERROR, "Field annotated @Model needs a type of IBakedModel.");
            return;
        }
        Model model = element.getAnnotation(Model.class);
        env.getMod(element).addModel(((QualifiedNameable)element.getEnclosingElement()).getQualifiedName().toString(), element.getSimpleName().toString(), model.namespace(), model.value());
    }
}

