/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.github.noeppi_noeppi.libx.impl.config.ConfigGroup;
import io.github.noeppi_noeppi.libx.impl.config.ConfigImpl;
import io.github.noeppi_noeppi.libx.impl.config.ConfigKey;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;

public class ConfigState {
    private final ConfigImpl config;
    private final Map<ConfigKey, Object> values;
    private final Set<ConfigGroup> groups;

    public ConfigState(ConfigImpl config, ImmutableMap<ConfigKey, Object> values, ImmutableSet<ConfigGroup> groups) {
        this.config = config;
        this.values = values;
        this.groups = groups;
    }

    public Object getValue(ConfigKey key) {
        if (!this.values.containsKey(key)) {
            throw new IllegalStateException("Can't get value from config state: Key is invalid.");
        }
        return this.values.get(key);
    }

    public void apply() {
        try {
            for (Map.Entry<ConfigKey, Object> entry : this.values.entrySet()) {
                ConfigKey key = entry.getKey();
                Object value = entry.getValue();
                key.field.setAccessible(true);
                key.field.set(null, value);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to insert value into field.", e);
        }
    }

    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.values.size());
        for (Map.Entry<ConfigKey, Object> entry : this.values.entrySet()) {
            ConfigKey key = entry.getKey();
            Object value = entry.getValue();
            buffer.func_211400_a(key.field.getDeclaringClass().getName(), Short.MAX_VALUE);
            buffer.func_211400_a(key.field.getName(), Short.MAX_VALUE);
            buffer.func_192572_a(key.mapperId);
            buffer.func_211400_a(key.elementType == Void.TYPE ? "" : key.elementType.getName(), Short.MAX_VALUE);
            key.mapper.write(value, buffer, key.elementType);
        }
    }

    public void writeToFile() throws IOException {
        if (!Files.isDirectory(this.config.path.getParent(), new LinkOption[0])) {
            Files.createDirectories(this.config.path.getParent(), new FileAttribute[0]);
        }
        BufferedWriter writer = Files.newBufferedWriter(this.config.path, StandardOpenOption.CREATE);
        writer.write("{\n" + this.applyIndent(this.writeObject(this.values.keySet(), this.groups, 0), "  ") + "\n}\n");
        ((Writer)writer).close();
    }

    public String writeObject(@Nonnull Set<ConfigKey> keys, Set<ConfigGroup> groups, int pathStrip) {
        List simpleKeysSorted = keys.stream().filter(key -> key.path.size() == pathStrip + 1).sorted(ConfigKey.BY_PATH).collect(Collectors.toList());
        Map subGroups = keys.stream().filter(key -> key.path.size() > pathStrip + 1).collect(Collectors.groupingBy(key -> key.path.get(pathStrip), Collectors.toSet()));
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (ConfigKey key2 : simpleKeysSorted) {
            if (first) {
                first = false;
            } else {
                builder.append(",\n\n");
            }
            key2.comment.forEach(line -> builder.append("// ").append(line.replace('\n', ' ')).append("\n"));
            builder.append("\"").append(ConfigState.quote(key2.path.get(key2.path.size() - 1))).append("\": ");
            Object value = this.values.get(key2);
            Object json = key2.mapper.toJSON(value, key2.elementType);
            builder.append(this.specialString((JsonElement)json));
        }
        List subGroupKeys = subGroups.keySet().stream().sorted().collect(Collectors.toList());
        for (String group : subGroupKeys) {
            ConfigGroup cg = groups.stream().filter(g -> g.path.size() == pathStrip + 1).filter(g -> g.path.get(pathStrip).equals(group)).findFirst().orElse(null);
            Set<ConfigGroup> subGroupInstances = groups.stream().filter(g -> g.path.size() > pathStrip + 1).filter(g -> g.path.get(pathStrip).equals(group)).collect(Collectors.toSet());
            if (first) {
                first = false;
            } else {
                builder.append(",\n\n");
            }
            if (cg != null) {
                cg.comment.forEach(line -> builder.append("// ").append(line.replace('\n', ' ')).append("\n"));
            }
            builder.append("\"").append(ConfigState.quote(group)).append("\": {\n\n");
            builder.append(this.applyIndent(this.writeObject(subGroups.get(group), subGroupInstances, pathStrip + 1), "  "));
            builder.append("\n}");
        }
        return builder.toString();
    }

    private String specialString(JsonElement json) {
        String content;
        List list;
        if (json.isJsonObject() && json.getAsJsonObject().size() == 0) {
            return "{}";
        }
        if (json.isJsonArray() && json.getAsJsonArray().size() == 0) {
            return "[]";
        }
        if (json.isJsonArray() && json.getAsJsonArray().size() < 5 && (list = Streams.stream((Iterable)json.getAsJsonArray()).collect(Collectors.toList())).stream().allMatch(this::isSimple)) {
            return "[ " + list.stream().map(arg_0 -> ((Gson)ConfigImpl.GSON).toJson(arg_0)).collect(Collectors.joining(", ")) + " ]";
        }
        if (json.isJsonObject()) {
            content = json.getAsJsonObject().entrySet().stream().map(e -> ConfigImpl.GSON.toJson((JsonElement)new JsonPrimitive((String)e.getKey())) + ": " + this.specialString((JsonElement)e.getValue())).collect(Collectors.joining(",\n")).trim();
            return "{\n" + this.applyIndent(content, "  ") + "\n}";
        }
        if (json.isJsonArray()) {
            content = Streams.stream((Iterable)json.getAsJsonArray()).map(this::specialString).collect(Collectors.joining(",\n")).trim();
            return "[\n" + this.applyIndent(content, "  ") + "\n]";
        }
        return ConfigImpl.GSON.toJson(json);
    }

    private boolean isSimple(JsonElement json) {
        if (json.isJsonNull()) {
            return true;
        }
        if (json.isJsonPrimitive()) {
            return !json.getAsJsonPrimitive().isString() || json.getAsJsonPrimitive().getAsString().length() <= 10;
        }
        return false;
    }

    private String applyIndent(String str, String indentStr) {
        return indentStr + str.replace("\n", "\n" + indentStr);
    }

    private static String quote(String str) {
        return str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "\\\t").replace("\b", "\\\b").replace("\n", "\\\n").replace("\r", "\\\r").replace("\f", "\\\f");
    }
}

