/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.inventory.container;

import com.mojang.datafixers.util.Function5;
import io.github.noeppi_noeppi.libx.fi.Function6;
import io.github.noeppi_noeppi.libx.inventory.container.CommonContainer;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeContainerType;

public abstract class ContainerBase<T extends TileEntity>
extends CommonContainer {
    public final T tile;
    public final PlayerEntity player;
    public final BlockPos pos;
    public final World world;
    public final int firstOutputSlot;
    public final int firstInventorySlot;

    protected ContainerBase(@Nullable ContainerType<?> type, int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player, int firstOutputSlot, int firstInventorySlot) {
        super(type, windowId, playerInventory);
        this.tile = world.func_175625_s(pos);
        this.player = player;
        this.pos = pos;
        this.world = world;
        this.firstOutputSlot = firstOutputSlot;
        this.firstInventorySlot = firstInventorySlot;
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return ContainerBase.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.tile.func_145831_w(), (BlockPos)this.tile.func_174877_v()), (PlayerEntity)this.player, (Block)this.tile.func_195044_w().func_177230_c());
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public World getWorld() {
        return this.world;
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            itemstack = stack.func_77946_l();
            int inventorySize = this.firstInventorySlot;
            int playerInventoryEnd = inventorySize + 27;
            int playerHotBarEnd = playerInventoryEnd + 9;
            if (index < this.firstOutputSlot) {
                if (!this.func_75135_a(stack, inventorySize, playerHotBarEnd, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stack, itemstack);
            } else if (index >= inventorySize) {
                if (!this.func_75135_a(stack, 0, this.firstOutputSlot, false)) {
                    return ItemStack.field_190927_a;
                }
                if (index < playerInventoryEnd ? !this.func_75135_a(stack, playerInventoryEnd, playerHotBarEnd, false) : index < playerHotBarEnd && !this.func_75135_a(stack, inventorySize, playerInventoryEnd, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (!this.func_75135_a(stack, inventorySize, playerHotBarEnd, false)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stack);
        }
        return itemstack;
    }

    public static <T extends Container> ContainerType<T> createContainerType(Function5<Integer, World, BlockPos, PlayerInventory, PlayerEntity, T> constructor) {
        return IForgeContainerType.create((windowId1, inv, data) -> {
            BlockPos pos1 = data.func_179259_c();
            World world1 = inv.field_70458_d.func_130014_f_();
            return (Container)constructor.apply((Object)windowId1, (Object)world1, (Object)pos1, (Object)inv, (Object)inv.field_70458_d);
        });
    }

    public static <T extends Container> ContainerType<T> createContainerType(Function6<ContainerType<T>, Integer, World, BlockPos, PlayerInventory, PlayerEntity, T> constructor) {
        AtomicReference<Object> typeRef = new AtomicReference<Object>(null);
        ContainerType type = IForgeContainerType.create((windowId1, inv, data) -> {
            BlockPos pos1 = data.func_179259_c();
            World world1 = inv.field_70458_d.func_130014_f_();
            return (Container)constructor.apply((ContainerType)typeRef.get(), windowId1, world1, pos1, inv, inv.field_70458_d);
        });
        typeRef.set(type);
        return type;
    }
}

