/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.util;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class NbtToTextComponent {
    private static final HoverEvent COPY_NBT = new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("libx.misc.copy_nbt"));

    public static IFormattableTextComponent toText(INBT nbt) {
        Style copyTag = Style.field_240709_b_.func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, nbt.toString())).func_240716_a_(COPY_NBT);
        return NbtToTextComponent.toTextInternal(nbt).func_240703_c_(copyTag);
    }

    private static IFormattableTextComponent toTextInternal(INBT nbt) {
        if (nbt instanceof EndNBT) {
            return new StringTextComponent("");
        }
        if (nbt instanceof CompoundNBT) {
            StringTextComponent tc = new StringTextComponent("{");
            List keys = ((CompoundNBT)nbt).func_150296_c().stream().sorted().collect(Collectors.toList());
            for (int i = 0; i < keys.size(); ++i) {
                if (NbtToTextComponent.quotesRequired((String)keys.get(i))) {
                    tc = tc.func_230529_a_((ITextComponent)new StringTextComponent("\""));
                }
                tc = tc.func_230529_a_((ITextComponent)new StringTextComponent(NbtToTextComponent.escape((String)keys.get(i))).func_240699_a_(TextFormatting.AQUA));
                tc = NbtToTextComponent.quotesRequired((String)keys.get(i)) ? tc.func_230529_a_((ITextComponent)new StringTextComponent("\": ")) : tc.func_230529_a_((ITextComponent)new StringTextComponent(": "));
                tc = tc.func_230529_a_((ITextComponent)NbtToTextComponent.toTextInternal(((CompoundNBT)nbt).func_74781_a((String)keys.get(i))));
                if (i + 1 >= keys.size()) continue;
                tc = tc.func_230529_a_((ITextComponent)new StringTextComponent(", "));
            }
            tc = tc.func_230529_a_((ITextComponent)new StringTextComponent("}"));
            return tc;
        }
        if (nbt instanceof ListNBT) {
            StringTextComponent tc = new StringTextComponent("[");
            for (int i = 0; i < ((ListNBT)nbt).size(); ++i) {
                tc = tc.func_230529_a_((ITextComponent)NbtToTextComponent.toTextInternal(((ListNBT)nbt).get(i)));
                if (i + 1 >= ((ListNBT)nbt).size()) continue;
                tc = tc.func_230529_a_((ITextComponent)new StringTextComponent(", "));
            }
            tc = tc.func_230529_a_((ITextComponent)new StringTextComponent("]"));
            return tc;
        }
        if (nbt instanceof ByteNBT) {
            return new StringTextComponent(Integer.toString(((ByteNBT)nbt).func_150290_f())).func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new StringTextComponent("b").func_240699_a_(TextFormatting.RED));
        }
        if (nbt instanceof DoubleNBT) {
            return new StringTextComponent(Double.toString(((DoubleNBT)nbt).func_150286_g())).func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new StringTextComponent("d").func_240699_a_(TextFormatting.RED));
        }
        if (nbt instanceof FloatNBT) {
            return new StringTextComponent(Float.toString(((FloatNBT)nbt).func_150288_h())).func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new StringTextComponent("f").func_240699_a_(TextFormatting.RED));
        }
        if (nbt instanceof IntNBT) {
            return new StringTextComponent(Integer.toString(((IntNBT)nbt).func_150287_d())).func_240699_a_(TextFormatting.GOLD);
        }
        if (nbt instanceof LongNBT) {
            return new StringTextComponent(Long.toString(((LongNBT)nbt).func_150291_c())).func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new StringTextComponent("l").func_240699_a_(TextFormatting.RED));
        }
        if (nbt instanceof ShortNBT) {
            return new StringTextComponent(Integer.toString(((ShortNBT)nbt).func_150289_e())).func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new StringTextComponent("s").func_240699_a_(TextFormatting.RED));
        }
        if (nbt instanceof StringNBT) {
            return new StringTextComponent("\"").func_230529_a_((ITextComponent)new StringTextComponent(NbtToTextComponent.escape(nbt.func_150285_a_())).func_240699_a_(TextFormatting.GREEN)).func_230529_a_((ITextComponent)new StringTextComponent("\""));
        }
        if (nbt instanceof ByteArrayNBT) {
            StringTextComponent tc = new StringTextComponent("[");
            tc = tc.func_230529_a_((ITextComponent)new StringTextComponent("B").func_240699_a_(TextFormatting.LIGHT_PURPLE));
            tc = tc.func_230529_a_((ITextComponent)new StringTextComponent("; "));
            for (int i = 0; i < ((ByteArrayNBT)nbt).size(); ++i) {
                tc = tc.func_230529_a_((ITextComponent)NbtToTextComponent.toTextInternal((INBT)((ByteArrayNBT)nbt).get(i)));
                if (i + 1 >= ((ByteArrayNBT)nbt).size()) continue;
                tc = tc.func_230529_a_((ITextComponent)new StringTextComponent(", "));
            }
            tc = tc.func_230529_a_((ITextComponent)new StringTextComponent("]"));
            return tc;
        }
        if (nbt instanceof IntArrayNBT) {
            StringTextComponent tc = new StringTextComponent("[");
            tc = tc.func_230529_a_((ITextComponent)new StringTextComponent("I").func_240699_a_(TextFormatting.LIGHT_PURPLE));
            tc = tc.func_230529_a_((ITextComponent)new StringTextComponent("; "));
            for (int i = 0; i < ((IntArrayNBT)nbt).size(); ++i) {
                tc = tc.func_230529_a_((ITextComponent)NbtToTextComponent.toTextInternal((INBT)((IntArrayNBT)nbt).get(i)));
                if (i + 1 >= ((IntArrayNBT)nbt).size()) continue;
                tc = tc.func_230529_a_((ITextComponent)new StringTextComponent(", "));
            }
            tc = tc.func_230529_a_((ITextComponent)new StringTextComponent("]"));
            return tc;
        }
        if (nbt instanceof LongArrayNBT) {
            StringTextComponent tc = new StringTextComponent("[");
            tc = tc.func_230529_a_((ITextComponent)new StringTextComponent("L").func_240699_a_(TextFormatting.LIGHT_PURPLE));
            tc = tc.func_230529_a_((ITextComponent)new StringTextComponent("; "));
            for (int i = 0; i < ((LongArrayNBT)nbt).size(); ++i) {
                tc = tc.func_230529_a_((ITextComponent)NbtToTextComponent.toTextInternal((INBT)((LongArrayNBT)nbt).get(i)));
                if (i + 1 >= ((LongArrayNBT)nbt).size()) continue;
                tc = tc.func_230529_a_((ITextComponent)new StringTextComponent(", "));
            }
            tc = tc.func_230529_a_((ITextComponent)new StringTextComponent("]"));
            return tc;
        }
        throw new IllegalArgumentException("NBT type unknown: " + nbt.getClass());
    }

    private static boolean quotesRequired(String text) {
        for (char chr : text.toCharArray()) {
            if (Character.isLetterOrDigit(chr) || chr == '_') continue;
            return true;
        }
        return false;
    }

    private static String escape(String text) {
        return text.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\\n").replace("\t", "\\\t").replace("\r", "\\\r").replace("\u0000", "\\\u0000").replace("\f", "\\\f");
    }
}

