/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.pavocado.exoticbirds.container.ContainerIdentifier;
import net.pavocado.exoticbirds.tileentity.TileEntityIdentifier;

public class ScreenIdentifier
extends ContainerScreen<ContainerIdentifier> {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("exoticbirds", "textures/gui/container/egg_identifier.png");

    public ScreenIdentifier(ContainerIdentifier container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_238742_p_ = (this.field_146999_f - this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_)) / 2;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderHelper.func_227783_c_();
        this.getMinecraft().func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        int startX = this.field_147003_i;
        int startY = this.field_147009_r;
        this.func_238474_b_(matrixStack, startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
        TileEntityIdentifier tileEntity = ((ContainerIdentifier)this.field_147002_h).tileEntity;
        if (tileEntity.isBurning()) {
            int glassHeight = this.getCookProgressScaled(23);
            this.func_238474_b_(matrixStack, startX + 7, startY + 55 - glassHeight, 176, 78 - glassHeight, 23, glassHeight);
            int scanHeight = this.getCookProgressRapidScaled(54);
            this.func_238474_b_(matrixStack, startX + 7, startY + 70 - scanHeight, 176, 54 - scanHeight, 23, scanHeight + 1);
            int fuelHeight = this.getBurnTimeScaled(53);
            this.func_238474_b_(matrixStack, startX + 55, startY + 69 - fuelHeight, 199, 53 - fuelHeight, 8, fuelHeight + 1);
        }
    }

    private int getCookProgressScaled(int pixels) {
        TileEntityIdentifier tileEntity = ((ContainerIdentifier)this.field_147002_h).tileEntity;
        if (tileEntity.eggIncubateTime <= 0) {
            return 0;
        }
        return (200 - tileEntity.eggIncubateTime) * pixels / 200;
    }

    private int getCookProgressRapidScaled(int pixels) {
        TileEntityIdentifier tileEntity = ((ContainerIdentifier)this.field_147002_h).tileEntity;
        if (tileEntity.eggIncubateTime <= 0) {
            return 0;
        }
        return (200 - tileEntity.eggIncubateTime) % 50 * pixels / 50;
    }

    private int getBurnTimeScaled(int pixels) {
        TileEntityIdentifier tileEntity = ((ContainerIdentifier)this.field_147002_h).tileEntity;
        if (tileEntity.maxFuelBurnTime <= 0 || tileEntity.fuelBurnTimeLeft <= 0) {
            return 0;
        }
        return tileEntity.fuelBurnTimeLeft * pixels / tileEntity.maxFuelBurnTime;
    }
}

