/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.entity.EntityAbstractBird;
import net.pavocado.exoticbirds.entity.EntityBirdEgg;

public class ItemBirdEgg
extends Item {
    private EntityType<? extends EntityAbstractBird> birdType;

    public ItemBirdEgg(Item.Properties builder) {
        super(builder);
    }

    public void initType(final EntityType<? extends EntityAbstractBird> birdType) {
        this.birdType = birdType;
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            protected ProjectileEntity func_82499_a(World worldIn, IPosition posIn, ItemStack stackIn) {
                return new EntityBirdEgg(worldIn, posIn.func_82615_a(), posIn.func_82617_b(), posIn.func_82616_c(), (EntityType<? extends EntityAbstractBird>)birdType, stackIn);
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187511_aA, SoundCategory.PLAYERS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.field_72995_K) {
            EntityBirdEgg eggEntity = new EntityBirdEgg(worldIn, (LivingEntity)playerIn, this.birdType, itemstack);
            eggEntity.func_213884_b(itemstack);
            eggEntity.func_234612_a_((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, 1.5f, 1.0f);
            worldIn.func_217376_c((Entity)eggEntity);
        }
        playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        if (!playerIn.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        EntityAbstractBird bird;
        int spawnChance = 30;
        CompoundNBT compoundnbt = stack.func_179543_a("eggValues");
        if (compoundnbt != null && compoundnbt.func_74764_b("SpawnChance")) {
            spawnChance = compoundnbt.func_74762_e("SpawnChance");
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("egg.exoticbirds.spawn_chance", new Object[]{spawnChance}).func_240699_a_(TextFormatting.GRAY));
        String variantName = new TranslationTextComponent("egg.exoticbirds.unknown_variant").getString();
        if (compoundnbt != null && compoundnbt.func_74764_b("Variant") && worldIn != null && (bird = (EntityAbstractBird)this.birdType.func_200721_a(worldIn)) != null) {
            variantName = bird.getTranslatedVariantName(compoundnbt.func_74762_e("Variant"), true);
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("egg.exoticbirds.variant", new Object[]{variantName}).func_240699_a_(TextFormatting.GRAY));
    }

    public void setEggVariant(ItemStack stack, @Nullable World worldIn) {
        EntityAbstractBird bird;
        CompoundNBT compoundnbt = stack.func_179543_a("eggValues");
        if (compoundnbt != null && worldIn != null && (bird = (EntityAbstractBird)this.birdType.func_200721_a(worldIn)) != null) {
            compoundnbt.func_74768_a("Variant", bird.getRandomVariant());
        }
    }

    public static boolean canIncubate(ItemStack stack, int max) {
        CompoundNBT compoundnbt = stack.func_179543_a("eggValues");
        if (compoundnbt != null && compoundnbt.func_74764_b("SpawnChance")) {
            return compoundnbt.func_74762_e("SpawnChance") < max;
        }
        return true;
    }
}

