/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.ExoticBirdsMod;
import net.pavocado.exoticbirds.config.ExoticBirdsConfig;
import net.pavocado.exoticbirds.entity.EntityAbstractBird;

public class ItemBirdcage
extends BlockItem {
    public ItemBirdcage(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        if (target.field_70170_p.field_72995_K) {
            return ActionResultType.PASS;
        }
        ItemBirdcage.captureEntity(stack, playerIn, target, hand);
        return ActionResultType.SUCCESS;
    }

    private static boolean captureEntity(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        if (target.field_70170_p.field_72995_K) {
            return false;
        }
        if (playerIn.field_71075_bZ.field_75098_d) {
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("cage.exoticbirds.survival_only"), true);
            return false;
        }
        if (ItemBirdcage.containsData(stack)) {
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("cage.exoticbirds.cage_full"), true);
            return false;
        }
        if (target instanceof MonsterEntity || !(target instanceof EntityAbstractBird) && !ExoticBirdsConfig.allowAnythingInCages) {
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("cage.exoticbirds.cage_only_birds"), true);
            return false;
        }
        return ItemBirdcage.captureTarget(stack, playerIn, target, hand);
    }

    private static boolean captureTarget(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        if (target.field_70170_p.field_72995_K) {
            return false;
        }
        target.func_184210_p();
        target.func_184226_ay();
        CompoundNBT entityTagCompound = new CompoundNBT();
        target.func_189511_e(entityTagCompound);
        entityTagCompound.func_74778_a("id", Registry.field_212629_r.func_177774_c((Object)target.func_200600_R()).toString());
        entityTagCompound.func_82580_o("Motion");
        entityTagCompound.func_82580_o("Dimension");
        entityTagCompound.func_82580_o("Rotation");
        entityTagCompound.func_82580_o("Pos");
        entityTagCompound.func_82580_o("UUIDMost");
        entityTagCompound.func_82580_o("UUIDLeast");
        if (!target.func_70089_S()) {
            return false;
        }
        target.func_70106_y();
        stack.func_77983_a("EntityData", (INBT)entityTagCompound);
        return true;
    }

    public static boolean containsData(ItemStack stack) {
        return stack.func_179543_a("EntityData") != null;
    }

    public static CompoundNBT getCageData(ItemStack stack) {
        return stack.func_179543_a("EntityData");
    }

    public String func_77667_c(ItemStack stack) {
        CompoundNBT compoundnbt = ItemBirdcage.getCageData(stack);
        if (compoundnbt != null && compoundnbt.func_74764_b("id")) {
            return this.func_77658_a() + '.' + "full";
        }
        return super.func_77667_c(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT compoundnbt = ItemBirdcage.getCageData(stack);
        if (compoundnbt != null) {
            if (compoundnbt.func_74764_b("id")) {
                ResourceLocation entityId = new ResourceLocation(compoundnbt.func_74779_i("id"));
                tooltip.add((ITextComponent)new TranslationTextComponent(((EntityType)Registry.field_212629_r.func_82594_a(entityId)).func_210760_d()).func_240699_a_(TextFormatting.GRAY));
            }
            if (compoundnbt.func_150297_b("CustomName", 8)) {
                String s = compoundnbt.func_74779_i("CustomName");
                try {
                    tooltip.add((ITextComponent)new TranslationTextComponent("cage.exoticbirds.name", new Object[]{ITextComponent.Serializer.func_240643_a_((String)s)}).func_240699_a_(TextFormatting.GRAY));
                }
                catch (Exception exception) {
                    ExoticBirdsMod.LOGGER.warn("Failed to parse entity custom name {}", (Object)s, (Object)exception);
                }
            }
            if (compoundnbt.func_74764_b("Health")) {
                tooltip.add((ITextComponent)new TranslationTextComponent("cage.exoticbirds.health", new Object[]{Float.valueOf(compoundnbt.func_74760_g("Health") * 0.5f)}).func_240699_a_(TextFormatting.GRAY));
            }
        }
    }
}

