/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavebiomes.core.api;

import com.blackgear.cavebiomes.mixin.NetherBiomeProviderAccessor;
import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.NetherBiomeProvider;

public class CaveLayer {
    public static final Map<RegistryKey<Biome>, Biome.Attributes> CAVE_BIOMES = new HashMap<RegistryKey<Biome>, Biome.Attributes>();
    public static final List<Biome> CAVE_BIOME_LIST = new ArrayList<Biome>();
    public static final NetherBiomeProvider.Preset CAVE_BIOME_SOURCE = new NetherBiomeProvider.Preset(new ResourceLocation("cavebiomeapi", "cave_biome_source"), (preset, biomes, seed) -> {
        ArrayList<Pair<Biome.Attributes, Supplier<Biome>>> caveBiomes = new ArrayList<Pair<Biome.Attributes, Supplier<Biome>>>();
        CAVE_BIOMES.forEach((key, attributes) -> {
            Biome biome = (Biome)biomes.func_243576_d(key);
            caveBiomes.add(Pair.of((Object)attributes, () -> biome));
        });
        NetherBiomeProvider.Noise temperatureNoiseParameters = CaveLayer.createNoiseParameters(-9, 1.5, 0.0, 1.0, 0.0, 0.0, 0.0);
        NetherBiomeProvider.Noise humidityNoiseParameters = CaveLayer.createNoiseParameters(-7, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0);
        NetherBiomeProvider.Noise altitudeNoiseParameters = CaveLayer.createNoiseParameters(-9, 1.0, 1.0, 2.0, 2.0, 2.0, 1.0, 1.0, 1.0, 1.0);
        NetherBiomeProvider.Noise weirdnessNoiseParameters = CaveLayer.createNoiseParameters(-7, 1.0, 2.0, 1.0, 0.0, 0.0, 0.0, 0.0);
        return NetherBiomeProviderAccessor.createMultiNoiseBiomeSource(seed, caveBiomes, temperatureNoiseParameters, humidityNoiseParameters, altitudeNoiseParameters, weirdnessNoiseParameters, Optional.empty());
    });

    public static NetherBiomeProvider create(Registry<Biome> biomes, long seed) {
        CAVE_BIOME_LIST.addAll(CAVE_BIOMES.keySet().stream().map(arg_0 -> biomes.func_230516_a_(arg_0)).collect(Collectors.toList()));
        return CAVE_BIOME_SOURCE.func_242619_a(biomes, seed);
    }

    public static void addCaveBiome(RegistryKey<Biome> biome, Biome.Attributes attributes) {
        Preconditions.checkNotNull(biome, (Object)"biome is null");
        Preconditions.checkNotNull((Object)attributes, (Object)"attributes are null");
        CAVE_BIOMES.put(biome, attributes);
    }

    private static NetherBiomeProvider.Noise createNoiseParameters(int firstOctave, double ... amplitudes) {
        return new NetherBiomeProvider.Noise(firstOctave, (List)new DoubleArrayList(amplitudes));
    }
}

