/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavebiomes.mixin;

import com.blackgear.cavebiomes.core.api.CaveLayer;
import com.blackgear.cavebiomes.core.utils.FeatureGenerationHelper;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructureManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkGenerator.class})
public class ChunkGeneratorMixin {
    @Shadow
    @Final
    protected BiomeProvider field_222542_c;

    @Redirect(method={"applyBiomeDecoration(Lnet/minecraft/world/gen/WorldGenRegion;Lnet/minecraft/world/gen/feature/structure/StructureManager;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/biome/provider/BiomeProvider;getNoiseBiome(III)Lnet/minecraft/world/biome/Biome;"), remap=false)
    private Biome cba$generateSurfaceFeatures(BiomeProvider provider, int x, int y, int z) {
        return provider.func_225526_b_(x, 128, z);
    }

    @Inject(method={"applyBiomeDecoration(Lnet/minecraft/world/gen/WorldGenRegion;Lnet/minecraft/world/gen/feature/structure/StructureManager;)V"}, at={@At(value="RETURN")})
    private void cba$generateUndergroundFeatures(WorldGenRegion region, StructureManager manager, CallbackInfo ci) {
        int mainChunkX = region.func_201679_a();
        int mainChunkZ = region.func_201680_b();
        int x = mainChunkX * 16;
        int z = mainChunkZ * 16;
        BlockPos pos = new BlockPos(x, 0, z);
        Biome biome = this.field_222542_c.func_225526_b_((mainChunkX << 2) + 2, 10, (mainChunkZ << 2) + 2);
        if (!CaveLayer.CAVE_BIOME_LIST.contains(biome)) {
            return;
        }
        SharedSeedRandom random = new SharedSeedRandom();
        long seed = random.func_202424_a(region.func_72905_C(), x, z);
        try {
            FeatureGenerationHelper.generateOnlyFeatures(biome, (ChunkGenerator)this, region, seed, random, pos);
        }
        catch (Exception exception) {
            CrashReport report = CrashReport.func_85055_a((Throwable)exception, (String)"Biome decoration");
            report.func_85058_a("Generation").func_71507_a("CenterX", (Object)mainChunkX).func_71507_a("CenterZ", (Object)mainChunkZ).func_71507_a("Seed", (Object)seed).func_71507_a("Biome", (Object)biome);
            throw new ReportedException(report);
        }
    }

    @Redirect(method={"createStructures(Lnet/minecraft/util/registry/DynamicRegistries;Lnet/minecraft/world/gen/feature/structure/StructureManager;Lnet/minecraft/world/chunk/IChunk;Lnet/minecraft/world/gen/feature/template/TemplateManager;J)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/biome/provider/BiomeProvider;getNoiseBiome(III)Lnet/minecraft/world/biome/Biome;"))
    private Biome cba$setStructureStarts(BiomeProvider biomeProvider, int x, int y, int z) {
        return biomeProvider.func_225526_b_(x, 128, z);
    }

    @Redirect(method={"applyCarvers(JLnet/minecraft/world/biome/BiomeManager;Lnet/minecraft/world/chunk/IChunk;Lnet/minecraft/world/gen/GenerationStage$Carving;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/biome/provider/BiomeProvider;getNoiseBiome(III)Lnet/minecraft/world/biome/Biome;"))
    private Biome cba$carve(BiomeProvider provider, int x, int y, int z) {
        return provider.func_225526_b_(x, 128, z);
    }
}

