/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.content;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.client.screen.book.BookScreen;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.TextElement;

@OnlyIn(value=Dist.CLIENT)
public abstract class PageContent {
    public static final transient int TITLE_HEIGHT = 16;
    public static final transient int LARGE_TITLE_HEIGHT = 20;
    public transient PageData parent;
    public transient BookRepository source;
    @Nullable
    private Boolean centerTitle;
    @Nullable
    private Boolean largeTitle;

    public void load() {
    }

    public abstract void build(BookData var1, ArrayList<BookElement> var2, boolean var3);

    private boolean isLarge() {
        if (this.largeTitle != null) {
            return this.largeTitle;
        }
        if (this.parent != null && this.parent.parent != null && this.parent.parent.parent != null) {
            return this.parent.parent.parent.appearance.largePageTitles;
        }
        return false;
    }

    private boolean isCentered() {
        if (this.centerTitle != null) {
            return this.centerTitle;
        }
        if (this.parent != null && this.parent.parent != null && this.parent.parent.parent != null) {
            return this.parent.parent.parent.appearance.centerPageTitles;
        }
        return false;
    }

    protected int getTitleHeight() {
        return this.isLarge() ? 20 : 16;
    }

    public void addTitle(ArrayList<BookElement> list, String titleText) {
        this.addTitle(list, titleText, false);
    }

    public void addTitle(ArrayList<BookElement> list, String titleText, boolean dropShadow) {
        this.addTitle(list, titleText, dropShadow, 0, 0);
    }

    public void addTitle(ArrayList<BookElement> list, String titleText, boolean dropShadow, int color) {
        this.addTitle(list, titleText, dropShadow, color, 0);
    }

    public void addTitle(ArrayList<BookElement> list, String titleText, boolean dropShadow, int color, int y) {
        TextData title = new TextData(titleText);
        boolean isLarge = this.isLarge();
        title.scale = isLarge ? 1.2f : 1.0f;
        title.underlined = true;
        title.dropshadow = dropShadow;
        if (color != 0) {
            title.useOldColor = false;
            title.rgbColor = color;
        }
        int x = 0;
        int w = BookScreen.PAGE_WIDTH;
        if (this.isCentered()) {
            w = (int)Math.ceil((float)this.parent.parent.parent.fontRenderer.func_78256_a(titleText) * title.scale) + 1;
            x = (BookScreen.PAGE_WIDTH - w) / 2;
        }
        list.add(new TextElement(x, y, w, isLarge ? 11 : 9, title));
    }

    public void addText(ArrayList<BookElement> list, String subText, boolean dropShadow) {
        this.addText(list, subText, dropShadow, 0, 0);
    }

    public void addText(ArrayList<BookElement> list, String subText, boolean dropShadow, int color) {
        this.addText(list, subText, dropShadow, color, 0);
    }

    public int addText(ArrayList<BookElement> list, String text, boolean dropShadow, int color, int y) {
        TextData subText = new TextData(text);
        subText.dropshadow = dropShadow;
        if (color != 0) {
            subText.useOldColor = false;
            subText.rgbColor = color;
        }
        int height = this.parent.parent.parent.fontRenderer.func_78267_b(text, BookScreen.PAGE_WIDTH) * 12 / 9;
        list.add(new TextElement(5, y, BookScreen.PAGE_WIDTH, height, subText));
        return height;
    }

    @Deprecated
    public void addTitle(ArrayList<BookElement> list, TextData[] title) {
        list.add(new TextElement(0, 0, BookScreen.PAGE_WIDTH, 9, title));
    }

    public void setCenterTitle(@Nullable Boolean centerTitle) {
        this.centerTitle = centerTitle;
    }

    @Nullable
    public Boolean getCenterTitle() {
        return this.centerTitle;
    }

    public void setLargeTitle(@Nullable Boolean largeTitle) {
        this.largeTitle = largeTitle;
    }

    @Nullable
    public Boolean getLargeTitle() {
        return this.largeTitle;
    }
}

