/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tileentity.TileEntity;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.item.RetexturedBlockItem;
import slimeknights.mantle.loot.MantleLoot;
import slimeknights.mantle.tileentity.IRetexturedTileEntity;

public class RetexturedLootFunction
extends LootFunction {
    public RetexturedLootFunction(ILootCondition[] conditions) {
        super(conditions);
    }

    public RetexturedLootFunction() {
        super(new ILootCondition[0]);
    }

    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of((Object)LootParameters.field_216288_h);
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        TileEntity te = (TileEntity)context.func_216031_c(LootParameters.field_216288_h);
        if (te instanceof IRetexturedTileEntity) {
            RetexturedBlockItem.setTexture(stack, ((IRetexturedTileEntity)te).getTextureName());
        } else {
            String name = te == null ? "null" : te.getClass().getName();
            Mantle.logger.warn("Found wrong tile entity for loot function, expected IRetexturedTileEntity, found {}", (Object)name);
        }
        return stack;
    }

    public LootFunctionType func_230425_b_() {
        return MantleLoot.RETEXTURED_FUNCTION;
    }

    public static class Serializer
    extends LootFunction.Serializer<RetexturedLootFunction> {
        public RetexturedLootFunction deserialize(JsonObject json, JsonDeserializationContext ctx, ILootCondition[] conditions) {
            return new RetexturedLootFunction(conditions);
        }
    }
}

