/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.betterburning;

import net.darkhax.betterburning.Configuration;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod(value="betterburning")
public class BetterBurning {
    private final Configuration configuration = new Configuration();

    public BetterBurning() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, this.configuration.getSpec());
        MinecraftForge.EVENT_BUS.addListener(this::onLivingDeath);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityJoinWorld);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingTick);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingAttack);
        MinecraftForge.EVENT_BUS.addListener(this::onBlockBreak);
        MinecraftForge.EVENT_BUS.addListener(this::rightClickBlockWithItem);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(this::onBlockOverlay);
        }
    }

    private void rightClickBlockWithItem(PlayerInteractEvent.RightClickBlock event) {
        if (this.configuration.canExtinguishWithBottledWater() && event.getPlayer() != null && !(event.getPlayer() instanceof FakePlayer)) {
            BlockState state = event.getWorld().func_180495_p(event.getPos());
            Block block = state.func_177230_c();
            ItemStack stack = event.getItemStack();
            Potion potion = PotionUtils.func_185191_c((ItemStack)stack);
            if (!(block != Blocks.field_150480_ab && block != Blocks.field_235335_bO_ || stack.func_77973_b() != Items.field_151068_bn || Potions.field_185230_b != potion || event.getWorld().field_72995_K)) {
                event.getWorld().func_175656_a(event.getPos(), Blocks.field_150350_a.func_176223_P());
                event.getWorld().func_217378_a((PlayerEntity)null, 1009, event.getPos(), 0);
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)event.getPlayer(), (ItemStack)new ItemStack((IItemProvider)Items.field_151069_bo));
                stack.func_190918_g(1);
            }
        }
    }

    private void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null && !(event.getPlayer() instanceof FakePlayer)) {
            int burnTime;
            Block block = event.getState().func_177230_c();
            int n = block == Blocks.field_150480_ab ? this.configuration.getFirePunchBurnTime() : (burnTime = block == Blocks.field_235335_bO_ ? this.configuration.getSoulfirePunchBurnTime() : 0);
            if (burnTime > 0) {
                event.getPlayer().func_70015_d(burnTime);
            }
            if (block instanceof AbstractFireBlock && !this.configuration.canPunchOutFlames()) {
                event.setCanceled(true);
            }
        }
    }

    private void onLivingDeath(LivingDeathEvent event) {
        if (event.getSource().func_76347_k() && this.configuration.shouldDamageSourceCauseFire() && !event.getEntityLiving().func_70027_ad() && !event.getEntity().field_70170_p.field_72995_K) {
            event.getEntityLiving().func_70015_d(1);
        }
    }

    private void onEntityJoinWorld(EntityJoinWorldEvent event) {
        ArrowEntity arrowEntity;
        Entity shooter;
        if (this.configuration.shouldSkeletonsShootFireArrows() && event.getEntity() instanceof ArrowEntity && !event.getEntity().field_70170_p.field_72995_K && (shooter = (arrowEntity = (ArrowEntity)event.getEntity()).func_234616_v_()) instanceof AbstractSkeletonEntity && shooter.func_70027_ad() && shooter.func_70089_S() && this.tryPercentage(this.configuration.getSkeletonFlameArrowChance())) {
            arrowEntity.func_70015_d(shooter.func_223314_ad());
        }
    }

    private void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        if (this.configuration.shouldFireResExtinguish() && !event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving().func_70027_ad() && event.getEntityLiving().func_70644_a(Effects.field_76426_n)) {
            event.getEntityLiving().func_70066_B();
        }
    }

    private void onLivingAttack(LivingAttackEvent event) {
        Entity sourceEntity;
        if (this.configuration.shouldFireDamageSpread() && !event.getEntity().field_70170_p.field_72995_K && (sourceEntity = event.getSource().func_76346_g()) instanceof LivingEntity) {
            LivingEntity sourceLiving = (LivingEntity)sourceEntity;
            ItemStack heldItem = sourceLiving.func_184614_ca();
            if (!(sourceLiving instanceof ZombieEntity) && heldItem.func_190926_b() && sourceLiving.func_70027_ad() && this.tryPercentage(this.configuration.getFireDamageSpreadChance())) {
                float damage = Math.max(1.0f, event.getEntityLiving().field_70170_p.func_175649_E(new BlockPos(event.getEntity().func_213303_ch())).func_180168_b());
                event.getEntityLiving().func_70015_d(2 * (int)damage);
            }
            if (heldItem.func_77973_b() == Items.field_151033_d && this.configuration.shouldFlintAndSteelDoFireDamage()) {
                event.getEntityLiving().func_70015_d(this.configuration.getFlintAndSteelFireDamage());
                heldItem.func_222118_a(1, sourceLiving, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
            }
        }
    }

    private void onBlockOverlay(RenderBlockOverlayEvent event) {
        if (event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.FIRE && this.configuration.hideFireOverlay() && (event.getPlayer().func_230279_az_() || event.getPlayer().func_70644_a(Effects.field_76426_n))) {
            event.setCanceled(true);
        }
    }

    private boolean tryPercentage(double chance) {
        return Math.random() < chance;
    }
}

