/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.mixin.client;

import com.minecraftabnormals.abnormals_core.core.config.ACConfig;
import com.minecraftabnormals.abnormals_core.core.events.AnimateFluidTickEvent;
import com.minecraftabnormals.abnormals_core.core.events.AnimateTickEvent;
import com.minecraftabnormals.abnormals_core.core.mixin.FluidInvokerMixin;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.fluid.FluidState;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.storage.ISpawnWorldInfo;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientWorld.class})
public abstract class ClientWorldMixin
extends World {
    @Shadow
    @Final
    private DimensionRenderInfo field_239131_x_;
    @Shadow
    private int field_228314_A_;

    protected ClientWorldMixin(ISpawnWorldInfo p_i241925_1_, RegistryKey<World> p_i241925_2_, DimensionType p_i241925_3_, Supplier<IProfiler> p_i241925_4_, boolean p_i241925_5_, boolean p_i241925_6_, long p_i241925_7_) {
        super(p_i241925_1_, p_i241925_2_, p_i241925_3_, p_i241925_4_, p_i241925_5_, p_i241925_6_, p_i241925_7_);
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;animateTick(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)V"), method={"doAnimateTick(IIIILjava/util/Random;ZLnet/minecraft/util/math/BlockPos$Mutable;)V"})
    private void animateTick(Block block, BlockState state, World world, BlockPos pos, Random rand) {
        if (!AnimateTickEvent.onAnimateTick(state, world, pos, rand)) {
            block.func_180655_c(state, world, pos, rand);
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/fluid/FluidState;animateTick(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)V"), method={"doAnimateTick(IIIILjava/util/Random;ZLnet/minecraft/util/math/BlockPos$Mutable;)V"})
    private void animateFluidTick(FluidState state, World world, BlockPos pos, Random random) {
        if (!AnimateFluidTickEvent.onAnimateFluidTick(world, pos, state, random)) {
            ((FluidInvokerMixin)state.func_206886_c()).callAnimateTick(world, pos, state, random);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getSkyColor"}, cancellable=true)
    private void getSkyColor(BlockPos blockPos, float partialTicks, CallbackInfoReturnable<Vector3d> info) {
        if (ACConfig.ValuesHolder.isSmoothSkyColorEnabled() && this.field_239131_x_.func_241683_c_() == DimensionRenderInfo.FogType.NORMAL) {
            float thunderStrength;
            Vector3d scaledOffset = Vector3d.func_237491_b_((Vector3i)blockPos).func_178786_a(2.0, 2.0, 2.0).func_186678_a(0.25);
            BiomeManager biomemanager = this.func_225523_d_();
            Vector3d sampledSkyColor = CubicSampler.func_240807_a_((Vector3d)scaledOffset, (x, y, z) -> Vector3d.func_237487_a_((int)biomemanager.func_235199_a_(x, y, z).func_225529_c_()));
            float celestialAngleFactor = MathHelper.func_76131_a((float)(MathHelper.func_76134_b((float)(this.func_242415_f(partialTicks) * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
            float r = (float)sampledSkyColor.field_72450_a * celestialAngleFactor;
            float g = (float)sampledSkyColor.field_72448_b * celestialAngleFactor;
            float b = (float)sampledSkyColor.field_72449_c * celestialAngleFactor;
            float rainStrength = this.func_72867_j(partialTicks);
            if (rainStrength > 0.0f) {
                float colorModifier = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.6f;
                float strengthFactor = 1.0f - rainStrength * 0.75f;
                r = r * strengthFactor + colorModifier * (1.0f - strengthFactor);
                g = g * strengthFactor + colorModifier * (1.0f - strengthFactor);
                b = b * strengthFactor + colorModifier * (1.0f - strengthFactor);
            }
            if ((thunderStrength = this.func_72819_i(partialTicks)) > 0.0f) {
                float colorModifier = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.2f;
                float strengthFactor = 1.0f - thunderStrength * 0.75f;
                r = r * strengthFactor + colorModifier * (1.0f - strengthFactor);
                g = g * strengthFactor + colorModifier * (1.0f - strengthFactor);
                b = b * strengthFactor + colorModifier * (1.0f - strengthFactor);
            }
            if (this.field_228314_A_ > 0) {
                float flash = (float)this.field_228314_A_ - partialTicks;
                if (flash > 1.0f) {
                    flash = 1.0f;
                }
                r = r * (1.0f - (flash *= 0.45f)) + 0.8f * flash;
                g = g * (1.0f - flash) + 0.8f * flash;
                b = b * (1.0f - flash) + 1.0f * flash;
            }
            info.setReturnValue((Object)new Vector3d((double)r, (double)g, (double)b));
        }
    }
}

