/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.util.registry;

import com.minecraftabnormals.abnormals_core.common.world.modification.BiomeModificationManager;
import com.minecraftabnormals.abnormals_core.core.util.registry.AbstractSubRegistryHelper;
import com.minecraftabnormals.abnormals_core.core.util.registry.RegistryHelper;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.util.LazyValue;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class BiomeSubRegistryHelper
extends AbstractSubRegistryHelper<Biome> {
    public BiomeSubRegistryHelper(RegistryHelper parent, DeferredRegister<Biome> deferredRegister) {
        super(parent, deferredRegister);
    }

    public BiomeSubRegistryHelper(RegistryHelper parent) {
        super(parent, DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)parent.modId));
    }

    public KeyedBiome createBiome(String name, Supplier<Biome> biome) {
        return new KeyedBiome((RegistryObject<Biome>)this.deferredRegister.register(name, biome));
    }

    public KeyedBiome createBiomeWithModifiers(String name, Supplier<Biome> biome, BiConsumer<RegistryObject<Biome>, BiomeModificationManager> consumer) {
        RegistryObject biomeRegistryObject = this.deferredRegister.register(name, biome);
        consumer.accept((RegistryObject<Biome>)biomeRegistryObject, BiomeModificationManager.INSTANCE);
        return new KeyedBiome((RegistryObject<Biome>)biomeRegistryObject);
    }

    public static final class KeyedBiome {
        private static final ForgeRegistry<Biome> BIOME_REGISTRY = (ForgeRegistry)ForgeRegistries.BIOMES;
        private final RegistryObject<Biome> biome;
        private final LazyValue<RegistryKey<Biome>> lazyKey;

        public KeyedBiome(RegistryObject<Biome> biome) {
            this.biome = biome;
            this.lazyKey = new LazyValue(() -> BIOME_REGISTRY.getKey(BIOME_REGISTRY.getID(this.biome.get())));
        }

        public Biome get() {
            return (Biome)this.biome.get();
        }

        public RegistryObject<Biome> getObject() {
            return this.biome;
        }

        public RegistryKey<Biome> getKey() {
            return (RegistryKey)this.lazyKey.func_179281_c();
        }
    }
}

