/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.commons.io.IOUtils;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.EofSensorInputStream;
import org.apache.http.conn.EofSensorWatcher;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OnlineRequest {
    private static final Logger LOGGER = LogManager.getLogger();
    private static String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11";

    public static InputStream get(String url) throws IOException {
        HttpGet get = new HttpGet(url);
        CloseableHttpClient client = HttpClients.custom().setUserAgent(USER_AGENT).build();
        final CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            client.close();
            response.close();
            throw new IOException("Failed to connect to '" + url + "'. " + statusLine.getStatusCode() + " " + statusLine.getReasonPhrase());
        }
        return new EofSensorInputStream(response.getEntity().getContent(), new EofSensorWatcher(){

            public boolean eofDetected(InputStream wrapped) {
                return true;
            }

            public boolean streamClosed(InputStream wrapped) throws IOException {
                response.close();
                return true;
            }

            public boolean streamAbort(InputStream wrapped) throws IOException {
                response.close();
                return true;
            }
        });
    }

    public static CompletableFuture<InputStream> request(String url, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            try (InputStream stream = OnlineRequest.get(url);){
                InputStream inputStream = IOUtils.toBufferedInputStream((InputStream)stream);
                return inputStream;
            }
            catch (Exception e) {
                LOGGER.error("Failed to fully read stream from '" + url + "'", (Throwable)e);
                return null;
            }
        }, executor);
    }

    public static CompletableFuture<InputStream> request(String url) {
        return CompletableFuture.supplyAsync(() -> {
            try (InputStream stream = OnlineRequest.get(url);){
                InputStream inputStream = IOUtils.toBufferedInputStream((InputStream)stream);
                return inputStream;
            }
            catch (Exception e) {
                LOGGER.error("Failed to fully read stream from '" + url + "'", (Throwable)e);
                return null;
            }
        });
    }

    public static void setUserAgent(String userAgent) {
        USER_AGENT = userAgent;
    }
}

