/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.powertap;

import it.zerono.mods.extremereactors.gamecontent.multiblock.common.AbstractGeneratorMultiblockController;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.AbstractMultiblockEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.powertap.AbstractPowerTapHandler;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.powertap.IPowerTapHandler;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.variant.IMultiblockGeneratorVariant;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullPredicate;
import net.minecraftforge.energy.IEnergyStorage;

public class PowerTapHandlerFE<Controller extends AbstractGeneratorMultiblockController<Controller, V>, V extends IMultiblockGeneratorVariant, T extends AbstractMultiblockEntity<Controller>>
extends AbstractPowerTapHandler<Controller, V, T>
implements IEnergyStorage {
    @CapabilityInject(value=IEnergyStorage.class)
    private static Capability<IEnergyStorage> CAPAP_FORGE_ENERGYSTORAGE = null;
    private IEnergyStorage _consumer = null;
    private final LazyOptional<IEnergyStorage> _capability = LazyOptional.of(() -> this);

    public PowerTapHandlerFE(T part, IoMode mode) {
        super(EnergySystem.ForgeEnergy, part, mode);
    }

    @Override
    public double outputEnergy(double amount) {
        if (null == this._consumer || this.isPassive()) {
            return 0.0;
        }
        int maxUnits = (int)Math.min(amount, 2.147483647E9);
        return this._consumer.receiveEnergy(maxUnits, false);
    }

    @Override
    public boolean isConnected() {
        return null != this._consumer;
    }

    @Override
    public void checkConnections(@Nullable IWorldReader world, BlockPos position) {
        this._consumer = this.lookupConsumer(world, position, CAPAP_FORGE_ENERGYSTORAGE, (NonNullPredicate<TileEntity>)((NonNullPredicate)te -> te instanceof IPowerTapHandler), this._consumer);
    }

    @Override
    public void invalidate() {
        this._capability.invalidate();
    }

    @Override
    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction direction) {
        if (CAPAP_FORGE_ENERGYSTORAGE == capability) {
            return this._capability.cast();
        }
        return null;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.canExtract() ? (int)this.getEnergyProvider().extractEnergy(this.getEnergySystem(), null, (double)maxExtract, simulate) : 0;
    }

    public int getEnergyStored() {
        return (int)this.getEnergyProvider().getEnergyStored(this.getEnergySystem(), null);
    }

    public int getMaxEnergyStored() {
        return (int)this.getEnergyProvider().getCapacity(this.getEnergySystem(), null);
    }

    public boolean canExtract() {
        return this.isPassive();
    }

    public boolean canReceive() {
        return false;
    }
}

