/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor;

import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IFuelContainer;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import net.minecraft.nbt.CompoundNBT;

public class Stats
implements ISyncableEntity {
    private final IFuelContainer _fuelContainer;
    private double _amountGeneratedLastTick;
    private float _fuelConsumedLastTick;

    public Stats(IFuelContainer fc) {
        this._fuelContainer = fc;
        this._amountGeneratedLastTick = 0.0;
        this._fuelConsumedLastTick = 0.0f;
    }

    public float getFuelConsumedLastTick() {
        return this._fuelConsumedLastTick;
    }

    public double getAmountGeneratedLastTick() {
        return this._amountGeneratedLastTick;
    }

    public float getFuelRichness() {
        int wasteAmount;
        int fuelAmount = this._fuelContainer.getFuelAmount();
        if ((float)(fuelAmount + (wasteAmount = this._fuelContainer.getWasteAmount())) <= 0.0f) {
            return 0.0f;
        }
        return (float)fuelAmount / (float)(fuelAmount + wasteAmount);
    }

    void setFuelConsumedLastTick(float value) {
        this._fuelConsumedLastTick = value;
    }

    void changeFuelConsumedLastTick(float delta) {
        this._fuelConsumedLastTick += delta;
    }

    void setAmountGeneratedLastTick(double value) {
        this._amountGeneratedLastTick = value;
    }

    void changeAmountGeneratedLastTick(double delta) {
        this._amountGeneratedLastTick += delta;
    }

    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        if (data.func_74764_b("stuff")) {
            this.setAmountGeneratedLastTick(data.func_74769_h("stuff"));
        }
        if (data.func_74764_b("fuel")) {
            this.setFuelConsumedLastTick(data.func_74760_g("fuel"));
        }
    }

    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        data.func_74780_a("stuff", this.getAmountGeneratedLastTick());
        data.func_74776_a("fuel", this.getFuelConsumedLastTick());
        return data;
    }

    public String toString() {
        return "Generated: " + this._amountGeneratedLastTick + ", Consumed: " + this._fuelConsumedLastTick;
    }
}

