/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.unimi.dsi.fastutil.shorts.Short2ObjectArrayMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CachedSprites;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model.ReactorFuelRodModelData;
import it.zerono.mods.zerocore.lib.block.BlockFacings;
import it.zerono.mods.zerocore.lib.client.model.AbstractDynamicBakedModel;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.locks.StampedLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.SimpleModelTransform;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ReactorFuelRodModel
extends AbstractDynamicBakedModel {
    public static int HORIZONTAL_MAX_STEPS = 10;
    public static int VERTICAL_MAX_STEPS = 12;
    private static final List<BakedQuad> EMPTY_QUADS = ObjectLists.emptyList();
    private static final ResourceLocation FAKE_RESOURCELOCATION = new ResourceLocation("fake");
    private final StampedLock _lock = new StampedLock();
    private final IBakedModel _baseModel;
    private final Short2ObjectMap<List<BakedQuad>> _cachedQuads;
    private final FaceBakery _faceBakery;

    protected ReactorFuelRodModel(IBakedModel baseModel) {
        super(baseModel.func_177555_b(), baseModel.func_177556_c());
        this._baseModel = baseModel;
        this._cachedQuads = new Short2ObjectArrayMap(208);
        this._faceBakery = new FaceBakery();
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData modelData) {
        long writeLockStamp;
        if (side != null) {
            return EMPTY_QUADS;
        }
        if (!(modelData instanceof ReactorFuelRodModelData)) {
            return this._baseModel.getQuads(state, null, rand, (IModelData)EmptyModelData.INSTANCE);
        }
        ReactorFuelRodModelData fuelRodModelData = (ReactorFuelRodModelData)modelData;
        short modelIndex = fuelRodModelData.getModelKey();
        if (fuelRodModelData.isOccluded()) {
            return EMPTY_QUADS;
        }
        if (0 == modelIndex) {
            return this._baseModel.getQuads(state, null, rand, (IModelData)EmptyModelData.INSTANCE);
        }
        long lockStamp = this._lock.readLock();
        List quads = (List)this._cachedQuads.get(modelIndex);
        if (null != quads) {
            this._lock.unlockRead(lockStamp);
            return quads;
        }
        while (true) {
            if (0L != (writeLockStamp = this._lock.tryConvertToWriteLock(lockStamp))) break;
            this._lock.unlockRead(lockStamp);
            lockStamp = this._lock.writeLock();
        }
        LinkedList tempQuads = Lists.newLinkedList((Iterable)this._baseModel.getQuads(state, null, rand, (IModelData)EmptyModelData.INSTANCE));
        tempQuads.addAll(this.buildQuads(fuelRodModelData.getFuelLevel(), fuelRodModelData.getWasteLevel(), fuelRodModelData.isVertical() ? Direction.Axis.Y : Direction.Axis.X));
        quads = new ObjectArrayList((Collection)tempQuads);
        this._cachedQuads.put(modelIndex, (Object)quads);
        lockStamp = writeLockStamp;
        this._lock.unlock(lockStamp);
        return quads;
    }

    public TextureAtlasSprite func_177554_e() {
        return this._baseModel.getParticleTexture((IModelData)EmptyModelData.INSTANCE);
    }

    public ItemOverrideList func_188617_f() {
        return this._baseModel.func_188617_f();
    }

    public ItemCameraTransforms func_177552_f() {
        return this._baseModel.func_177552_f();
    }

    public boolean func_188618_c() {
        return this._baseModel.func_188618_c();
    }

    public boolean func_230044_c_() {
        return this._baseModel.func_230044_c_();
    }

    public boolean func_177556_c() {
        return this._baseModel.func_177556_c();
    }

    public boolean func_177555_b() {
        return false;
    }

    private List<BakedQuad> buildQuads(byte fuelLevel, byte wasteLevel, Direction.Axis axis) {
        Vector3f to;
        Vector3f from;
        BlockFacings wasteVisibleFaces;
        BlockFacings fuelVisibleFaces;
        float[] stillUV;
        float[] wasteFlowingUV;
        float[] fuelFlowingUV;
        float baseWidth;
        float fromZ;
        float fromY;
        float fromX;
        TextureAtlasSprite fuelColumnStill = CachedSprites.REACTOR_FUEL_COLUMN_STILL.get().getAtlasSprite().orElse(ModRenderHelper.getMissingTexture());
        TextureAtlasSprite fuelColumnFlowing = CachedSprites.REACTOR_FUEL_COLUMN_FLOWING.get().getAtlasSprite().orElse(ModRenderHelper.getMissingTexture());
        switch (axis.func_176716_d()) {
            default: {
                BlockFacings visibleFaces;
                fuelLevel = (byte)Math.min(fuelLevel, 12);
                wasteLevel = (byte)Math.min(wasteLevel, 12);
                fromX = 3.0f;
                fromY = 2.0f;
                fromZ = 3.0f;
                baseWidth = 10.0f;
                fuelFlowingUV = new float[]{3.0f, 2.0f, 13.0f, 2 + fuelLevel};
                wasteFlowingUV = new float[]{3.0f, 2.0f, 13.0f, 2 + wasteLevel};
                stillUV = new float[]{3.0f, 3.0f, 13.0f, 13.0f};
                fuelVisibleFaces = visibleFaces = BlockFacings.ALL.set(Direction.UP, fuelLevel + wasteLevel < 12).set(Direction.DOWN, false);
                wasteVisibleFaces = visibleFaces.set(Direction.UP, 0 == fuelLevel && wasteLevel < 12);
                break;
            }
            case HORIZONTAL: {
                fuelLevel = (byte)Math.min(fuelLevel, 10);
                wasteLevel = (byte)Math.min(wasteLevel, 10);
                fromX = 2.0f;
                fromY = 3.0f;
                fromZ = 2.0f;
                baseWidth = 12.0f;
                fuelFlowingUV = new float[]{2.0f, 3.0f, 14.0f, 2 + fuelLevel};
                wasteFlowingUV = new float[]{2.0f, 3.0f, 14.0f, 2 + wasteLevel};
                stillUV = new float[]{2.0f, 2.0f, 14.0f, 14.0f};
                BlockFacings visibleFaces = BlockFacings.ALL;
                for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                    if (direction2.func_176740_k() != axis) continue;
                    visibleFaces = visibleFaces.set(direction2, false);
                }
                fuelVisibleFaces = visibleFaces.set(Direction.DOWN, 0 == wasteLevel);
                wasteVisibleFaces = visibleFaces.set(Direction.UP, 0 == fuelLevel);
            }
        }
        LinkedList quads = Lists.newLinkedList();
        if (wasteLevel > 0) {
            from = new Vector3f(fromX, fromY, fromZ);
            to = new Vector3f(fromX + baseWidth, fromY + (float)wasteLevel, fromZ + baseWidth);
            wasteVisibleFaces.stream().forEach(direction -> quads.add(this.createFace((Direction)direction, from, to, wasteFlowingUV, stillUV, 1, fuelColumnFlowing, fuelColumnStill)));
        }
        if (fuelLevel > 0) {
            from = new Vector3f(fromX, fromY + (float)wasteLevel, fromZ);
            to = new Vector3f(fromX + baseWidth, fromY + (float)wasteLevel + (float)fuelLevel, fromZ + baseWidth);
            fuelVisibleFaces.stream().forEach(direction -> quads.add(this.createFace((Direction)direction, from, to, fuelFlowingUV, stillUV, 0, fuelColumnFlowing, fuelColumnStill)));
        }
        return new ObjectArrayList((Collection)quads);
    }

    private BakedQuad createFace(Direction direction, Vector3f cubeFrom, Vector3f cubeTo, float[] flowingUV, float[] stillUV, int tintIndex, TextureAtlasSprite flowingTexture, TextureAtlasSprite stillTexture) {
        boolean isVertical = direction.func_176740_k().func_200128_b();
        float[] uv = isVertical ? stillUV : flowingUV;
        TextureAtlasSprite sprite = isVertical ? stillTexture : flowingTexture;
        BlockPartFace partFace = new BlockPartFace(null, tintIndex, "", new BlockFaceUV(uv, 0));
        return this._faceBakery.func_228824_a_(cubeFrom, cubeTo, partFace, sprite, direction, (IModelTransform)SimpleModelTransform.IDENTITY, null, true, FAKE_RESOURCELOCATION);
    }
}

