/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part;

import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.reactor.Reactant;
import it.zerono.mods.extremereactors.api.reactor.ReactantMappingsRegistry;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IFuelSource;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactantHelper;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.container.ReactorSolidAccessPortContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.AbstractReactorEntity;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.DebuggableHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.IIoEntity;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.item.inventory.handler.ItemHandlerModifiableForwarder;
import it.zerono.mods.zerocore.lib.item.inventory.handler.TileEntityItemStackHandler;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ReactorSolidAccessPortEntity
extends AbstractReactorEntity
implements IFuelSource<ItemStack>,
IIoEntity,
INeighborChangeListener,
INamedContainerProvider {
    public static String COMMAND_DUMP_FUEL = "dumpfuel";
    public static String COMMAND_DUMP_WASTE = "dumpwaste";
    @CapabilityInject(value=IItemHandler.class)
    private static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = null;
    private final TileEntityItemStackHandler _fuelInventory;
    private final TileEntityItemStackHandler _wasteInventory;
    private final LazyOptional<IItemHandlerModifiable> _fuelCapability;
    private final LazyOptional<IItemHandlerModifiable> _wasteCapability;
    private IoDirection _direction;

    public ReactorSolidAccessPortEntity() {
        super((TileEntityType)Content.TileEntityTypes.REACTOR_SOLID_ACCESSPORT.get());
        this.setIoDirection(IoDirection.Input);
        this._fuelInventory = new TileEntityItemStackHandler((TileEntity)this, 1);
        this._wasteInventory = new TileEntityItemStackHandler((TileEntity)this, 1);
        this._fuelCapability = LazyOptional.of(this::createFuelCapability);
        this._wasteCapability = LazyOptional.of(this::createWasteCapability);
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(CommonConstants.COMMAND_SET_INPUT, tile -> tile.setIoDirection(IoDirection.Input)).addServerHandler(CommonConstants.COMMAND_SET_OUTPUT, tile -> tile.setIoDirection(IoDirection.Output)).addServerHandler(COMMAND_DUMP_FUEL, ReactorSolidAccessPortEntity::handleCommandEjectFuel).addServerHandler(COMMAND_DUMP_WASTE, ReactorSolidAccessPortEntity::handleCommandEjectWaste).build((AbstractModBlockEntity)this));
    }

    public IItemHandlerModifiable getItemStackHandler(ReactantType type) {
        return type.isFuel() ? this._fuelInventory : this._wasteInventory;
    }

    public void onItemsReceived() {
        this.distributeItems();
        this.markChunkDirty();
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        int connectedOffset = this.isMachineAssembled() && this.getNeighborCapability().isPresent() ? 1 : 0;
        return this.getIoDirection().isInput() ? 2 + connectedOffset : 0 + connectedOffset;
    }

    @Override
    public ItemStack getFuelStack() {
        return this.getStack(ReactantType.Fuel);
    }

    @Override
    public ItemStack consumeFuelSource(ItemStack sourceToConsume) {
        ItemStack sourceStack = this.getStack(ReactantType.Fuel);
        if (!sourceStack.func_190926_b() && !sourceToConsume.func_190926_b()) {
            return this._fuelInventory.extractItem(0, Math.min(sourceStack.func_190916_E(), sourceToConsume.func_190916_E()), false);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public int emitReactant(Reactant reactant, int amount) {
        if (amount <= 0) {
            return 0;
        }
        ItemStack outputStack = this.getStack(ReactantType.Waste);
        int outputStackMaxSize = Math.min(this._wasteInventory.getSlotLimit(0), outputStack.func_77976_d());
        if (!outputStack.func_190926_b() && outputStack.func_190916_E() >= outputStackMaxSize) {
            return 0;
        }
        if (!outputStack.func_190926_b()) {
            IMapping mapping = ReactantMappingsRegistry.getFromSolid(outputStack).orElse(null);
            if (null == mapping || !reactant.equals(mapping.getProduct())) {
                return 0;
            }
            int amountToProduce = Math.min(mapping.getSourceAmount(amount), outputStackMaxSize - outputStack.func_190916_E());
            if (amountToProduce <= 0) {
                return 0;
            }
            int reactantToConsume = mapping.getProductAmount(amountToProduce);
            if (reactantToConsume <= 0) {
                return 0;
            }
            outputStack.func_190917_f(amountToProduce);
            this.onItemsReceived();
            return reactantToConsume;
        }
        IMapping bestMapping = null;
        List mappings = ReactantMappingsRegistry.getToSolid(reactant).orElse(null);
        if (null != mappings) {
            int bestReactantAmount = 0;
            for (IMapping mapping : mappings) {
                int potentialProducts = mapping.getProductAmount(amount);
                int potentialReactant = mapping.getSourceAmount(potentialProducts);
                if (null != bestMapping && bestReactantAmount >= potentialReactant) continue;
                bestMapping = mapping;
                bestReactantAmount = potentialReactant;
            }
        }
        if (null == bestMapping) {
            Log.LOGGER.warn(Log.REACTOR, "There are no mapped item types for reactant {}. Nothing to emit here.", (Object)reactant);
            return 0;
        }
        int itemsToProduce = Math.min(bestMapping.getProductAmount(amount), outputStackMaxSize);
        if (itemsToProduce <= 0) {
            return 0;
        }
        int reactantConsumed = bestMapping.getSourceAmount(itemsToProduce);
        itemsToProduce = bestMapping.getProductAmount(reactantConsumed);
        ItemStack newItem = ReactantMappingsRegistry.getSolidStackFrom(bestMapping, 1);
        if (newItem.func_190926_b()) {
            Log.LOGGER.warn(Log.REACTOR, "Can't create a stack from tag {}. Nothing to emit here.", bestMapping.getProduct());
            return 0;
        }
        ItemHelper.stackSetSize((ItemStack)newItem, (int)itemsToProduce);
        this._wasteInventory.setStackInSlot(0, newItem);
        this.onItemsReceived();
        return reactantConsumed;
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return new ReactorSolidAccessPortContainer(windowId, inventory, this);
    }

    public ITextComponent func_145748_c_() {
        return super.getPartDisplayName();
    }

    public IoDirection getIoDirection() {
        return this._direction;
    }

    public void setIoDirection(IoDirection direction) {
        if (this.getIoDirection() == direction) {
            return;
        }
        this._direction = direction;
        this.notifyBlockUpdate();
        this.callOnLogicalSide(() -> {
            this.notifyOutwardNeighborsOfStateChange();
            this.distributeItems();
            this.func_70296_d();
        }, this::markForRenderUpdate);
        this.notifyNeighborsOfTileChange();
    }

    public void onBlockReplaced(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        ItemHelper.inventoryDropItems((IItemHandlerModifiable)this.getItemStackHandler(ReactantType.Fuel), (World)world, (BlockPos)pos);
        ItemHelper.inventoryDropItems((IItemHandlerModifiable)this.getItemStackHandler(ReactantType.Waste), (World)world, (BlockPos)pos);
    }

    public void onNeighborBlockChanged(BlockState state, BlockPos neighborPosition, boolean isMoving) {
        this.requestClientRenderUpdate();
    }

    public void onNeighborTileChanged(BlockState state, BlockPos neighborPosition) {
        this.requestClientRenderUpdate();
    }

    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        this.setIoDirection(IoDirection.read((CompoundNBT)data, (String)"iodir", (IoDirection)IoDirection.Input));
        if (syncReason.isFullSync()) {
            if (data.func_74764_b("invin")) {
                this._fuelInventory.deserializeNBT(data.func_74775_l("invin"));
            }
            if (data.func_74764_b("invout")) {
                this._wasteInventory.deserializeNBT(data.func_74775_l("invout"));
            }
        }
    }

    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        IoDirection.write((CompoundNBT)data, (String)"iodir", (IoDirection)this.getIoDirection());
        if (syncReason.isFullSync()) {
            data.func_218657_a("invin", (INBT)this._fuelInventory.serializeNBT());
            data.func_218657_a("invout", (INBT)this._wasteInventory.serializeNBT());
        }
        return data;
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        this.getIoDirection().getDebugMessages(side, messages);
        messages.add((Object)this.getItemStackHandler(ReactantType.Fuel), DebuggableHelper::getDebugMessagesFor, "Fuel");
        messages.add((Object)this.getItemStackHandler(ReactantType.Waste), DebuggableHelper::getDebugMessagesFor, "Waste");
    }

    public boolean canOpenGui(World world, BlockPos position, BlockState state) {
        return true;
    }

    @Override
    public void onPostMachineAssembled(MultiblockReactor controller) {
        super.onPostMachineAssembled(controller);
        this.listenForControllerDataUpdates();
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (!this.func_145837_r() && ITEM_HANDLER_CAPABILITY == capability) {
            if (this.getIoDirection().isInput()) {
                return this._fuelCapability.cast();
            }
            return this._wasteCapability.cast();
        }
        return super.getCapability(capability, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this._fuelCapability.invalidate();
        this._wasteCapability.invalidate();
    }

    private ItemStack getStack(ReactantType type) {
        return this.getItemStackHandler(type).getStackInSlot(0);
    }

    private void setStack(ReactantType type, ItemStack stack) {
        this.getItemStackHandler(type).setStackInSlot(0, stack);
    }

    private void distributeItems() {
        if (this.getIoDirection().isInput()) {
            return;
        }
        this.callOnLogicalServer(() -> this.getNeighborCapability().ifPresent(itemHandler -> {
            this.setStack(ReactantType.Waste, ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)this.getStack(ReactantType.Waste), (boolean)false));
            this.markChunkDirty();
        }));
    }

    private LazyOptional<IItemHandler> getNeighborCapability() {
        return CodeHelper.optionalFlatMap((Optional)this.getPartWorld(), (Optional)this.getOutwardDirection(), (world, direction) -> WorldHelper.getTile((World)world, (BlockPos)this.getWorldPosition().func_177972_a(direction)).map(te -> te.getCapability(ITEM_HANDLER_CAPABILITY, direction.func_176734_d()))).orElse(LazyOptional.empty());
    }

    @Nonnull
    private IItemHandlerModifiable createFuelCapability() {
        return new ItemHandlerModifiableForwarder(this.getItemStackHandler(ReactantType.Fuel)){

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return this.isItemValid(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return ReactantHelper.isValidSource(ReactantType.Fuel, stack);
            }
        };
    }

    @Nonnull
    private IItemHandlerModifiable createWasteCapability() {
        return new ItemHandlerModifiableForwarder(this.getItemStackHandler(ReactantType.Waste)){

            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return stack;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return false;
            }
        };
    }

    private void handleCommandEjectFuel(CompoundNBT options) {
        this.getMultiblockController().ifPresent(c -> c.ejectFuel(options.func_74764_b("void") && options.func_74767_n("void")));
    }

    private void handleCommandEjectWaste(CompoundNBT options) {
        this.getMultiblockController().ifPresent(c -> c.ejectWaste(options.func_74764_b("void") && options.func_74767_n("void")));
    }
}

