/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.CachedTranslations;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.ComponentModelData;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorBladeState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.NonNullConsumer;

@OnlyIn(value=Dist.CLIENT)
public class BladeSpan
implements NonNullConsumer<MatrixStack> {
    public final RotorBladeState State;
    public final short Length;
    public final Direction Direction;
    public final IModelData BladeModelData;
    public final Matrix4f Translation;
    private static final Int2ObjectMap<BladeSpan> s_cache = new Int2ObjectOpenHashMap(8);

    public static BladeSpan from(RotorBladeState state, short length, Direction direction) {
        return (BladeSpan)s_cache.computeIfAbsent(BladeSpan.key(state, length, direction), k -> new BladeSpan(state, length, direction));
    }

    public static int key(RotorBladeState state, short length, Direction direction) {
        byte stateValue = (byte)state.ordinal();
        byte directionValue = (byte)direction.ordinal();
        return stateValue << 24 | directionValue << 16 | length;
    }

    public void accept(MatrixStack stack) {
        stack.func_227866_c_().func_227870_a_().func_226595_a_(this.Translation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BladeSpan bladeSpan = (BladeSpan)o;
        return this.Length == bladeSpan.Length && this.State == bladeSpan.State && this.Direction == bladeSpan.Direction;
    }

    public int hashCode() {
        return BladeSpan.key(this.State, this.Length, this.Direction);
    }

    private BladeSpan(RotorBladeState state, short length, Direction direction) {
        this.State = state;
        this.Length = length;
        this.Direction = direction;
        this.BladeModelData = ComponentModelData.from(state);
        this.Translation = CachedTranslations.getFor(direction);
    }
}

