/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.AbstractMultiblockEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.TurbinePartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.AbstractTurbineEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRotorComponentBlock;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorBladeState;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorShaftState;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.IMultiblockTurbineVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.TurbineVariant;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TurbineRotorComponentEntity
extends AbstractTurbineEntity
implements INeighborChangeListener {
    private final TurbinePartType _componentType;
    private static final Map<Direction.Axis, Function<Set<Direction.Axis>, RotorShaftState>> SHAFT_STATE_MAP = new Object2ObjectArrayMap(3);

    public static TurbineRotorComponentEntity shaft() {
        return new TurbineRotorComponentEntity(TurbinePartType.RotorShaft, (TileEntityType)Content.TileEntityTypes.TURBINE_ROTORSHAFT.get());
    }

    public static TurbineRotorComponentEntity blade() {
        return new TurbineRotorComponentEntity(TurbinePartType.RotorBlade, (TileEntityType)Content.TileEntityTypes.TURBINE_ROTORBLADE.get());
    }

    public static RotorShaftState computeShaftState(TurbineRotorComponentEntity shaft) {
        return TurbineRotorComponentEntity.computeShaftState(shaft, true);
    }

    public static RotorBladeState computeBladeState(TurbineRotorComponentEntity blade) {
        return TurbineRotorComponentEntity.computeBladeState(blade, true);
    }

    public boolean isShaft() {
        return TurbinePartType.RotorShaft == this._componentType;
    }

    public boolean isBlade() {
        return TurbinePartType.RotorBlade == this._componentType;
    }

    public void onNeighborBlockChanged(BlockState state, BlockPos neighborPosition, boolean isMoving) {
        if (this.getPartWorldOrFail().func_180495_p(neighborPosition).func_177230_c() instanceof TurbineRotorComponentBlock) {
            this.requestClientRenderUpdate();
        }
    }

    @Override
    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        if (PartPosition.Interior != position) {
            validatorCallback.setLastError(this.getWorldPosition(), "multiblock.validation.turbine.invalid_rotor_position", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public void onMachineActivated() {
        this.markForRenderUpdate();
    }

    @Override
    public void onMachineDeactivated() {
        this.markForRenderUpdate();
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        boolean assembled = this.isMachineAssembled();
        if (assembled) {
            return 0;
        }
        return this.getPartType().map(type -> {
            switch (type) {
                case RotorShaft: {
                    return TurbineRotorComponentEntity.computeShaftState(this, false).ordinal();
                }
                case RotorBlade: {
                    return TurbineRotorComponentEntity.computeBladeState(this, false).ordinal();
                }
            }
            return 0;
        }).orElse(0);
    }

    public void func_145843_s() {
        this.callOnLogicalClient(() -> TurbineRotorComponentEntity.updateNeighborsRenderState(this.getPartWorldOrFail(), this.getWorldPosition()));
        super.func_145843_s();
    }

    protected TurbineRotorComponentEntity(TurbinePartType componentType, TileEntityType<?> type) {
        super(type);
        this._componentType = componentType;
    }

    private static void updateNeighborsRenderState(World world, BlockPos position) {
        WorldHelper.getTilesFrom((World)world, (Stream)WorldHelper.getNeighboringPositions((BlockPos)position)).filter(te -> te instanceof TurbineRotorComponentEntity).map(te -> (TurbineRotorComponentEntity)((Object)te)).forEach(AbstractMultiblockEntity::markForRenderUpdate);
    }

    private static RotorShaftState computeShaftState(TurbineRotorComponentEntity shaft, boolean ignoreTurbineStatus) {
        if (!ignoreTurbineStatus && ((Boolean)shaft.evalOnController(MultiblockTurbine::isAssembledAndActive, false)).booleanValue()) {
            return RotorShaftState.HIDDEN;
        }
        return TurbineRotorComponentEntity.computeShaftStateInternal(shaft);
    }

    private static RotorShaftState computeShaftStateInternal(TurbineRotorComponentEntity shaft) {
        World world = shaft.getPartWorldOrFail();
        BlockPos shaftPosition = shaft.getWorldPosition();
        Map<Direction, BlockState> neighborsStates = Arrays.stream(CodeHelper.DIRECTIONS).collect(Collectors.toMap(direction -> direction, direction -> world.func_180495_p(shaftPosition.func_177972_a(direction))));
        Block shaftBlock = shaft.getBlockType();
        Direction shaftDirection = neighborsStates.entrySet().stream().filter(entry -> ((BlockState)entry.getValue()).func_177230_c() == shaftBlock).map(Map.Entry::getKey).findFirst().orElse(Direction.UP);
        Block bladeBlock = TurbineRotorComponentEntity.getBladeForVariant(shaft.getMultiblockVariant().orElse(TurbineVariant.Basic));
        Set bladesAxis = CodeHelper.perpendicularDirections((Direction)shaftDirection).stream().filter(direction -> bladeBlock == ((BlockState)neighborsStates.get(direction)).func_177230_c()).map(Direction::func_176740_k).collect(Collectors.toSet());
        return SHAFT_STATE_MAP.get(shaftDirection.func_176740_k()).apply(bladesAxis);
    }

    private static RotorBladeState computeBladeState(TurbineRotorComponentEntity blade, boolean ignoreTurbineStatus) {
        if (!ignoreTurbineStatus && ((Boolean)blade.evalOnController(MultiblockTurbine::isAssembledAndActive, false)).booleanValue()) {
            return RotorBladeState.HIDDEN;
        }
        return TurbineRotorComponentEntity.computeBladeStateInternal(blade);
    }

    private static RotorBladeState computeBladeStateInternal(TurbineRotorComponentEntity blade) {
        World world = blade.getPartWorldOrFail();
        BlockPos bladePosition = blade.getWorldPosition();
        Map<Direction, BlockState> neighborsStates = Arrays.stream(CodeHelper.DIRECTIONS).collect(Collectors.toMap(direction -> direction, direction -> world.func_180495_p(bladePosition.func_177972_a(direction))));
        Block shaftBlock = TurbineRotorComponentEntity.getShaftForVariant(blade.getMultiblockVariant().orElse(TurbineVariant.Basic));
        RotorBladeState candidate = neighborsStates.entrySet().stream().filter(entry -> ((BlockState)entry.getValue()).func_177230_c() == shaftBlock).map(entry -> WorldHelper.getTile((World)world, (BlockPos)bladePosition.func_177972_a((Direction)entry.getKey())).filter(te -> te instanceof TurbineRotorComponentEntity).map(te -> TurbineRotorComponentEntity.computeShaftStateInternal((TurbineRotorComponentEntity)((Object)((Object)te)))).map(shaftState -> RotorBladeState.from(shaftState, (Direction)entry.getKey())).orElse(RotorBladeState.HIDDEN)).findFirst().orElse(RotorBladeState.HIDDEN);
        if (RotorBladeState.HIDDEN != candidate) {
            return candidate;
        }
        Block bladeBlock = blade.getBlockType();
        candidate = neighborsStates.entrySet().stream().filter(entry -> ((BlockState)entry.getValue()).func_177230_c() == bladeBlock).map(entry -> TurbineRotorComponentEntity.computeBladeStateFromBladesChain(world, bladePosition, (Direction)entry.getKey(), bladeBlock, shaftBlock)).filter(bladeState -> RotorBladeState.HIDDEN != bladeState).findFirst().orElse(RotorBladeState.HIDDEN);
        if (RotorBladeState.HIDDEN != candidate) {
            return candidate;
        }
        return RotorBladeState.getDefault();
    }

    private static RotorBladeState computeBladeStateFromBladesChain(World world, BlockPos startPosition, Direction direction, Block bladeBlock, Block shaftBlock) {
        Block block;
        do {
            if (shaftBlock != (block = world.func_180495_p(startPosition = startPosition.func_177972_a(direction)).func_177230_c())) continue;
            return WorldHelper.getTile((World)world, (BlockPos)startPosition).filter(te -> te instanceof TurbineRotorComponentEntity).map(te -> TurbineRotorComponentEntity.computeShaftStateInternal((TurbineRotorComponentEntity)((Object)te))).map(shaftState -> RotorBladeState.from(shaftState, direction)).orElse(RotorBladeState.HIDDEN);
        } while (bladeBlock == block);
        return RotorBladeState.HIDDEN;
    }

    private static Block getShaftForVariant(IMultiblockTurbineVariant variant) {
        if (!(variant instanceof TurbineVariant)) {
            return Blocks.field_150350_a;
        }
        switch ((TurbineVariant)variant) {
            default: {
                return (Block)Content.Blocks.TURBINE_ROTORSHAFT_BASIC.get();
            }
            case Reinforced: 
        }
        return (Block)Content.Blocks.TURBINE_ROTORSHAFT_REINFORCED.get();
    }

    private static Block getBladeForVariant(IMultiblockTurbineVariant variant) {
        if (!(variant instanceof TurbineVariant)) {
            return Blocks.field_150350_a;
        }
        switch ((TurbineVariant)variant) {
            default: {
                return (Block)Content.Blocks.TURBINE_ROTORBLADE_BASIC.get();
            }
            case Reinforced: 
        }
        return (Block)Content.Blocks.TURBINE_ROTORBLADE_REINFORCED.get();
    }

    static {
        SHAFT_STATE_MAP.put(Direction.Axis.Y, set -> {
            switch (set.size()) {
                default: {
                    return RotorShaftState.Y_NOBLADES;
                }
                case 1: {
                    return set.contains(Direction.Axis.X) ? RotorShaftState.Y_X : RotorShaftState.Y_Z;
                }
                case 2: 
            }
            return RotorShaftState.Y_XZ;
        });
        SHAFT_STATE_MAP.put(Direction.Axis.X, set -> {
            switch (set.size()) {
                default: {
                    return RotorShaftState.X_NOBLADES;
                }
                case 1: {
                    return set.contains(Direction.Axis.Y) ? RotorShaftState.X_Y : RotorShaftState.X_Z;
                }
                case 2: 
            }
            return RotorShaftState.X_YZ;
        });
        SHAFT_STATE_MAP.put(Direction.Axis.Z, set -> {
            switch (set.size()) {
                default: {
                    return RotorShaftState.Z_NOBLADES;
                }
                case 1: {
                    return set.contains(Direction.Axis.X) ? RotorShaftState.Z_X : RotorShaftState.Z_Y;
                }
                case 2: 
            }
            return RotorShaftState.Z_XY;
        });
    }
}

